/*
	Copyright 2009 Anatol Gregory Mayen
	
	Licensed under the Apache License, Version 2.0 (the "License");
	you may not use this file except in compliance with the License. 
	You may obtain a copy of the License at 
	
	http://www.apache.org/licenses/LICENSE-2.0 
	
	Unless required by applicable law or agreed to in writing, software 
	distributed under the License is distributed on an "AS IS" BASIS, 
	WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
	See the License for the specific language governing permissions and 
	limitations under the License. 
*/
package eu.maydu.gwt.validation.client;

import java.util.LinkedList;
import java.util.List;

import eu.maydu.gwt.validation.client.i18n.ValidationMessages;

/**
 * 
 * @author Anatol Mayen
 *
 * @param <T> 
 */
public abstract class GroupValidator<T> extends Validator<T> {

	private List<Validator> validators = new LinkedList<Validator>();
	
	public GroupValidator(boolean preventsPropagationOfValidationChain) {
		super();
		this.setPreventsPropagationOfValidationChain(preventsPropagationOfValidationChain);
	}
	
	@Override
	public ValidationResult validate(ValidationMessages messages) {
		ValidationResult result = null;
		
		for(Validator validator : this.validators) {
			ValidationResult val = validator.validate(messages);
			if(val != null) {
				if(result == null)
					result = new ValidationResult();
				result.getErrors().addAll(val.getErrors());
			}
		}
		
		return result;
	}
	
	/**
	 * Adds new validators to this group.
	 * 
	 * @param validators The validators to add
	 */
	public void addValidators(Validator... validators) {
		if(validators == null || validators.length < 1)
			return;
		for(Validator validator : validators) {
			if(!this.validators.contains(validator))
				this.validators.add(validator);
		}
	}
	
	@Override
	public void invokeActions(ValidationResult result) {
		//Invoke child validators actions
		for(Validator val : validators)
			val.invokeActions(result);
		
	}
	
	@Override
	public void resetActions() {
		//Reset child validators actions
		for(Validator val : validators)
			val.resetActions();
		
		//Reset own actions
		for(ValidationAction actions : getFailureActions())
			actions.reset();
	}

}
