/*
	Copyright 2009 Anatol Gregory Mayen
	
	Licensed under the Apache License, Version 2.0 (the "License");
	you may not use this file except in compliance with the License. 
	You may obtain a copy of the License at 
	
	http://www.apache.org/licenses/LICENSE-2.0 
	
	Unless required by applicable law or agreed to in writing, software 
	distributed under the License is distributed on an "AS IS" BASIS, 
	WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
	See the License for the specific language governing permissions and 
	limitations under the License. 
*/
package eu.maydu.gwt.validation.client.showcase;

import com.google.gwt.core.client.EntryPoint;
import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.DisclosurePanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.MultiWordSuggestOracle;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.SuggestBox;
import com.google.gwt.user.client.ui.TabPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;

import eu.maydu.gwt.validation.client.DefaultValidationProcessor;
import eu.maydu.gwt.validation.client.ValidationProcessor;
import eu.maydu.gwt.validation.client.actions.DisclosureTextAction;
import eu.maydu.gwt.validation.client.actions.FocusAction;
import eu.maydu.gwt.validation.client.actions.StyleAction;
import eu.maydu.gwt.validation.client.description.PopupDescription;
import eu.maydu.gwt.validation.client.groupTransformers.TrimmedUpperCaseTransformer;
import eu.maydu.gwt.validation.client.showcase.panels.MultiFieldValidators;
import eu.maydu.gwt.validation.client.showcase.panels.TestPanel;
import eu.maydu.gwt.validation.client.transformers.CaesarEncryptionTransformer;
import eu.maydu.gwt.validation.client.transformers.UpperCaseTransformer;
import eu.maydu.gwt.validation.client.validators.StringLengthValidator;
import eu.maydu.gwt.validation.client.validators.ValidatorConfigurationSource;
import eu.maydu.gwt.validation.client.validators.numeric.IntegerValidator;
import eu.maydu.gwt.validation.client.validators.standard.NotEmptyValidator;
import eu.maydu.gwt.validation.client.validators.standard.RegularExpressionValidator;


 
/**
 * A showcase for the GWT Validation Library.
 * 
 * @author Anatol Gregory Mayen
 */
public class ValidationShowcase implements EntryPoint {

	private TextBox integerPositiveTextBox, integerMinus5000To5000TextBox, integerTextBox3;
	public TextBox getIntegerPositiveTextBox() {
		return integerPositiveTextBox;
	}

	public TextBox getIntegerMinus5000To5000TextBox() {
		return integerMinus5000To5000TextBox;
	}

	public TextBox getIntegerTextBox3() {
		return integerTextBox3;
	}

	public SuggestBox getSuggestBox1() {
		return suggestBox1;
	}

	public SuggestBox getSuggestBox2() {
		return suggestBox2;
	}

	public TextBox getStringLengthSmaller5TextBox() {
		return stringLengthSmaller5TextBox;
	}

	public TextBox getStringLengthBetween2And5TextBox2() {
		return stringLengthBetween2And5TextBox;
	}

	private SuggestBox suggestBox1, suggestBox2;
	private TextBox stringLengthSmaller5TextBox, stringLengthBetween2And5TextBox;
	private TextBox uppercaseTextBox, trimmedUppercaseTextBox;
	private TextBox caesarTextBox;
	private TextBox notEmptyTextBox;
	private TextBox regexEntryTextBox;
	private TextBox regexValidateEntryTextBox;
	private DisclosurePanel allErrorsPanel;
	private PopupDescription popupDesc;
	
	private MultiWordSuggestOracle oracle;
	
	private ValidationProcessor validator;
	private ValidationProcessor transValidator;
	private ShowcaseValidationMessages showcaseMessages;
	private ShowcaseValidationConstants showcaseConstants;
	public boolean testMode = false;

	/**
	 * This is the entry point method.
	 */
	public void onModuleLoad() {

		setup();
		

		FormLayoutPanel form = new FormLayoutPanel();
		
		

		//form.add(showcaseConstants.getString("positiveInteger"), integerPositiveTextBox, true)
		form.add("positiveInteger", integerPositiveTextBox, true)
		.addDelimiter("")
		.add(showcaseConstants.integerInRangeMinus5000Plus5000(), integerMinus5000To5000TextBox, true)
		.newRow()
		.add(showcaseConstants.anyInteger(), integerTextBox3, true, 1, 5)
		.newRow()
		.add(showcaseConstants.stringLengthSmaller5(), stringLengthSmaller5TextBox, true)
		.addDelimiter("")
		.add(showcaseConstants.stringLengthBetween2And5(), stringLengthBetween2And5TextBox, true)
		.newRow()
		.add(showcaseConstants.notEmpty(), notEmptyTextBox, true)
		.newRow()
		.add(showcaseConstants.enterRegEx(), regexEntryTextBox, false)
		.addDelimiter("")
		.add(showcaseConstants.enterRegExedText(), regexValidateEntryTextBox, false)
		//.newRow()
		/*.add("Equals SuggestBox2", suggestBox1, true)
		.addDelimiter("")
		.add("Equals SuggestBox1", suggestBox2, true)
		.newRow()*/
		//.add("All errors", allErrors, false, 1, 6)
		.newRow()
		.add(null, allErrorsPanel, false, 1, 6)
		
		.create();
		
		setupValidation();
		
		Button validateButton = new Button(showcaseConstants.validate());
		validateButton.addClickListener(new ClickListener() {
			public void onClick(Widget sender) {
				validate();
			}
		});
		
		Button resetButton = new Button(showcaseConstants.resetValidations());
		resetButton.addClickListener(new ClickListener() {
			public void onClick(Widget sender) {
				reset();
			}
		});
	
		HorizontalPanel hp = new HorizontalPanel();
		hp.add(resetButton);
		hp.add(validateButton);
		VerticalPanel vp = new VerticalPanel();
		vp.add(form);
		vp.add(hp);
		
		//Setup transformation panel
		Button transformButton = new Button(showcaseConstants.transform());
		transformButton.addClickListener(new ClickListener() {
			public void onClick(Widget sender) {
				transValidator.validate();
			}
		});
		
		FormLayoutPanel transformationForm = new FormLayoutPanel();
		transformationForm.add("Uppercase transformation", uppercaseTextBox, false)
			.add("Trimmed uppercase transformation", trimmedUppercaseTextBox, false)
			.newRow()
			.add("Encrypt with Caesar cipher", caesarTextBox, false)
			.create();
		VerticalPanel transformationPanel = new VerticalPanel();
		transformationPanel.add(transformationForm);
		transformationPanel.add(transformButton);
		
		
		VerticalPanel vp2 = new VerticalPanel();

		if(!testMode) {
			HTML sourceCode = new HTML();
			sourceCode.getElement().setInnerHTML(getSourceCodeText());
			ScrollPanel codeScroller = new ScrollPanel(sourceCode);
			
			codeScroller.setSize("844px", "500px");
			
			vp2.add(codeScroller);
		}
		vp.setSize("1024px", "500px");
		
		TabPanel tabPanel = new TabPanel();
		tabPanel.add(vp, "Validations");
		if(!testMode) {
			tabPanel.add(getMultiFieldTab(), "Multifield validations");
			tabPanel.add(transformationPanel, "Transformations");
			tabPanel.add(vp2, "Source code");
			//tabPanel.add(getTestPanel(), "Custom tests");
		}
		tabPanel.selectTab(0);
		
		if(!testMode)
			RootPanel.get("main").add(tabPanel);
		else
			RootPanel.get().add(tabPanel);
	}

	private void setup() {
		showcaseMessages = new ShowcaseValidationMessages();
		showcaseConstants = showcaseMessages.getPropertyNameConstants();
		integerPositiveTextBox = new TextBox();
		integerMinus5000To5000TextBox = new TextBox();
		integerTextBox3 = new TextBox();
		stringLengthSmaller5TextBox = new TextBox();
		stringLengthBetween2And5TextBox = new TextBox();
		notEmptyTextBox = new TextBox();
		regexEntryTextBox = new TextBox();
		regexEntryTextBox.setText("(a|b)*");
		regexValidateEntryTextBox = new TextBox();
		
		allErrorsPanel = new DisclosurePanel(showcaseConstants.allErrors());
		
		uppercaseTextBox = new TextBox();
		uppercaseTextBox.setText("Supersize Me!");
		trimmedUppercaseTextBox = new TextBox();
		trimmedUppercaseTextBox.setText("     Trim and uppercase me!     ");
		caesarTextBox = new TextBox();
		caesarTextBox.setText("Encrypt me!");
		
		
		
		
		oracle = new MultiWordSuggestOracle();
		oracle.add("Anton");
		oracle.add("Berta");
		oracle.add("Claudia");
		oracle.add("Dimitri");
		oracle.add("Erkan");
		oracle.add("Felix");
		oracle.add("Günther");
		oracle.add("Harald");
		oracle.add("Isolde");
		oracle.add("Jan");
		oracle.add("Klaus");
		oracle.add("Luisa");
		oracle.add("Martha");
		oracle.add("Norbert");
		oracle.add("Orhan");
		oracle.add("Peter");
		oracle.add("Qwasi");
		oracle.add("Rosemarie");
		oracle.add("Sabine");
		oracle.add("Thomas");
		oracle.add("Ursula");
		oracle.add("Vivienne");
		oracle.add("Waldemar");
		oracle.add("Yildirim");
		oracle.add("Zafer");
		suggestBox1 = new SuggestBox(oracle);
		suggestBox2 = new SuggestBox(oracle);
		
		
		
	}
	
	private String getSourceCodeText() {
		Element sourceCode = DOM.getElementById("sourceCode");
		String html = sourceCode.getInnerHTML();
		sourceCode.setInnerHTML("");
		return html;
	}
	
	private void setupValidation() {
		validator = new DefaultValidationProcessor(showcaseMessages);
		popupDesc = new PopupDescription(showcaseMessages);
		FocusAction focusAction = new FocusAction();
		
		IntegerValidator val = new IntegerValidator(integerPositiveTextBox, 1, Integer.MAX_VALUE, "customNotInRange");
		//val.setRequired(false);
		
		validator.addValidators("positiveInteger",
				val
					.addActionForFailure(focusAction)
					.addActionForFailure(new StyleAction("validationFailedBorder"))
					//.addActionForFailure(new TextAction(errorLabel))
		);
		
		
		popupDesc.addDescription("positiveIntegerHelp", integerPositiveTextBox);
		
		validator.addValidators("integerInRangeMinus5000Plus5000", 
			new IntegerValidator(integerMinus5000To5000TextBox, -5000, 5000)
				.addActionForFailure(focusAction)
				.addActionForFailure(new StyleAction("validationFailedBorder"))
		);
		
		popupDesc.addDescription("integerInRangeMinus5000Plus5000Help", integerMinus5000To5000TextBox);
		
		validator.addValidators("anyInteger", 
				new IntegerValidator(integerTextBox3)
					.addActionForFailure(focusAction)
					.addActionForFailure(new StyleAction("validationFailedBorder"))
			);
		
		popupDesc.addDescription("anyIntegerHelp", integerTextBox3);
		
		
		validator.addValidators("stringLengthSmaller5",
			new StringLengthValidator(stringLengthSmaller5TextBox, 0, 4)
				.addActionForFailure(focusAction)
				.addActionForFailure(new StyleAction("validationFailedBorder"))
		);
		
		popupDesc.addDescription("stringLengthSmaller5Help", stringLengthSmaller5TextBox);
		
		
		
		validator.addValidators("stringLengthBetween2And5",
				new StringLengthValidator(stringLengthBetween2And5TextBox, 2, 5)
					.addActionForFailure(focusAction)
					.addActionForFailure(new StyleAction("validationFailedBorder"))
		);
		
		popupDesc.addDescription("stringLengthBetween2And5Help", stringLengthBetween2And5TextBox);
		
		validator.addValidators("notEmpty",
				new NotEmptyValidator(notEmptyTextBox)
					.addActionForFailure(focusAction)
					.addActionForFailure(new StyleAction("validationFailedBorder"))
		);
		
		popupDesc.addDescription("notEmptyHelp", notEmptyTextBox);

		RegularExpressionValidator regex = new RegularExpressionValidator(regexValidateEntryTextBox, new ValidatorConfigurationSource<String>() {

			public String getConfigurationValue() {
				String regex = regexEntryTextBox.getText();
				if(regex.trim().equals("")) {
					regexEntryTextBox.setText("(a|b)*");
					return "(a|b)*";
				}
				
				return regex;
			}
			
		}, "regexNotMatched");
		
		validator.addValidators("enterRegExedText", regex
			.addActionForFailure(new StyleAction("validationFailedBorder"))
			.addActionForFailure(focusAction)
		);
		
		popupDesc.addDescription("regexText.description", regexValidateEntryTextBox);
		
		validator.addGlobalAction(new DisclosureTextAction(allErrorsPanel, "redText") );
		
		
		transValidator = new DefaultValidationProcessor();
		transValidator.addValidators("string1", new UpperCaseTransformer(uppercaseTextBox));
		transValidator.addValidators("string2", new TrimmedUpperCaseTransformer(trimmedUppercaseTextBox));
		transValidator.addValidators("caesar1", new CaesarEncryptionTransformer(caesarTextBox, 1));
		
	}
	
	
	public void validate() {
		validator.validate();
	}
	
	public void reset() {
		validator.reset();
	}
	
	private Panel getMultiFieldTab() {
		MultiFieldValidators val = new MultiFieldValidators();
		
		return val.getMultiFieldValidatorPanel();
	}
	
	private Panel getTestPanel() {
		TestPanel panel = new TestPanel();
		return panel.getPanel();
	}
}