/*
 * Decompiled with CFR 0.152.
 */
package io.agroal.api.configuration.supplier;

import io.agroal.api.configuration.AgroalConnectionFactoryConfiguration;
import io.agroal.api.configuration.AgroalConnectionPoolConfiguration;
import io.agroal.api.configuration.supplier.AgroalConnectionFactoryConfigurationSupplier;
import io.agroal.api.transaction.TransactionIntegration;
import java.time.Duration;
import java.util.function.Function;
import java.util.function.Supplier;

public class AgroalConnectionPoolConfigurationSupplier
implements Supplier<AgroalConnectionPoolConfiguration> {
    private volatile boolean lock = false;
    private AgroalConnectionFactoryConfigurationSupplier connectionFactoryConfigurationSupplier = new AgroalConnectionFactoryConfigurationSupplier();
    private TransactionIntegration transactionIntegration = TransactionIntegration.none();
    private int initialSize = 0;
    private volatile int minSize = 0;
    private volatile int maxSize = Integer.MAX_VALUE;
    private AgroalConnectionPoolConfiguration.ConnectionValidator connectionValidator = AgroalConnectionPoolConfiguration.ConnectionValidator.emptyValidator();
    private AgroalConnectionPoolConfiguration.ExceptionSorter exceptionSorter = AgroalConnectionPoolConfiguration.ExceptionSorter.emptyExceptionSorter();
    private Duration idleValidationTimeout = Duration.ZERO;
    private Duration leakTimeout = Duration.ZERO;
    private Duration validationTimeout = Duration.ZERO;
    private Duration reapTimeout = Duration.ZERO;
    private Duration maxLifetime = Duration.ZERO;
    private volatile Duration acquisitionTimeout = Duration.ZERO;

    public AgroalConnectionPoolConfigurationSupplier() {
    }

    public AgroalConnectionPoolConfigurationSupplier(AgroalConnectionPoolConfiguration existingConfiguration) {
        this();
        if (existingConfiguration == null) {
            return;
        }
        this.connectionFactoryConfigurationSupplier = new AgroalConnectionFactoryConfigurationSupplier(existingConfiguration.connectionFactoryConfiguration());
        this.transactionIntegration = existingConfiguration.transactionIntegration();
        this.initialSize = existingConfiguration.initialSize();
        this.minSize = existingConfiguration.minSize();
        this.maxSize = existingConfiguration.maxSize();
        this.connectionValidator = existingConfiguration.connectionValidator();
        this.exceptionSorter = existingConfiguration.exceptionSorter();
        this.idleValidationTimeout = existingConfiguration.idleValidationTimeout();
        this.leakTimeout = existingConfiguration.leakTimeout();
        this.validationTimeout = existingConfiguration.validationTimeout();
        this.reapTimeout = existingConfiguration.reapTimeout();
        this.maxLifetime = existingConfiguration.maxLifetime();
        this.acquisitionTimeout = existingConfiguration.acquisitionTimeout();
    }

    private void checkLock() {
        if (this.lock) {
            throw new IllegalStateException("Attempt to modify an immutable configuration");
        }
    }

    private AgroalConnectionPoolConfigurationSupplier connectionFactoryConfiguration(AgroalConnectionFactoryConfiguration configuration) {
        this.checkLock();
        this.connectionFactoryConfigurationSupplier = new AgroalConnectionFactoryConfigurationSupplier(configuration);
        return this;
    }

    public AgroalConnectionPoolConfigurationSupplier connectionFactoryConfiguration(Supplier<AgroalConnectionFactoryConfiguration> supplier) {
        return this.connectionFactoryConfiguration(supplier.get());
    }

    public AgroalConnectionPoolConfigurationSupplier connectionFactoryConfiguration(Function<AgroalConnectionFactoryConfigurationSupplier, AgroalConnectionFactoryConfigurationSupplier> function) {
        return this.connectionFactoryConfiguration(function.apply(this.connectionFactoryConfigurationSupplier));
    }

    public AgroalConnectionFactoryConfigurationSupplier connectionFactoryConfiguration() {
        return this.connectionFactoryConfigurationSupplier;
    }

    public AgroalConnectionPoolConfigurationSupplier transactionIntegration(TransactionIntegration integration) {
        this.checkLock();
        this.transactionIntegration = integration;
        return this;
    }

    public AgroalConnectionPoolConfigurationSupplier initialSize(int size) {
        this.checkLock();
        this.initialSize = size;
        return this;
    }

    public AgroalConnectionPoolConfigurationSupplier minSize(int size) {
        this.checkLock();
        this.minSize = size;
        return this;
    }

    public AgroalConnectionPoolConfigurationSupplier maxSize(int size) {
        this.checkLock();
        this.maxSize = size;
        return this;
    }

    public AgroalConnectionPoolConfigurationSupplier connectionValidator(AgroalConnectionPoolConfiguration.ConnectionValidator validator) {
        this.checkLock();
        this.connectionValidator = validator;
        return this;
    }

    public AgroalConnectionPoolConfigurationSupplier exceptionSorter(AgroalConnectionPoolConfiguration.ExceptionSorter sorter) {
        this.checkLock();
        this.exceptionSorter = sorter;
        return this;
    }

    public AgroalConnectionPoolConfigurationSupplier acquisitionTimeout(Duration timeout) {
        this.checkLock();
        this.acquisitionTimeout = timeout;
        return this;
    }

    public AgroalConnectionPoolConfigurationSupplier idleValidationTimeout(Duration timeout) {
        this.checkLock();
        this.idleValidationTimeout = timeout;
        return this;
    }

    public AgroalConnectionPoolConfigurationSupplier leakTimeout(Duration timeout) {
        this.checkLock();
        this.leakTimeout = timeout;
        return this;
    }

    public AgroalConnectionPoolConfigurationSupplier validationTimeout(Duration timeout) {
        this.checkLock();
        this.validationTimeout = timeout;
        return this;
    }

    public AgroalConnectionPoolConfigurationSupplier reapTimeout(Duration timeout) {
        this.checkLock();
        this.reapTimeout = timeout;
        return this;
    }

    public AgroalConnectionPoolConfigurationSupplier maxLifetime(Duration time) {
        this.checkLock();
        this.maxLifetime = time;
        return this;
    }

    private void validate() {
        if (this.maxSize == Integer.MAX_VALUE) {
            throw new IllegalArgumentException("max size attribute is mandatory");
        }
        if (this.maxSize <= 0) {
            throw new IllegalArgumentException("A Positive max size is required");
        }
        if (this.minSize < 0) {
            throw new IllegalArgumentException("Invalid min size: smaller than 0");
        }
        if (this.minSize > this.maxSize) {
            throw new IllegalArgumentException("Invalid min size: greater than max size");
        }
        if (this.initialSize < 0) {
            throw new IllegalArgumentException("Invalid value for initial size. Must not be negative, and ideally between min size and max size");
        }
        if (this.acquisitionTimeout.isNegative()) {
            throw new IllegalArgumentException("Acquisition timeout must not be negative");
        }
        if (this.idleValidationTimeout.isNegative()) {
            throw new IllegalArgumentException("Idle validation timeout must not be negative");
        }
        if (this.leakTimeout.isNegative()) {
            throw new IllegalArgumentException("Leak detection timeout must not be negative");
        }
        if (this.reapTimeout.isNegative()) {
            throw new IllegalArgumentException("Reap timeout must not be negative");
        }
        if (this.maxLifetime.isNegative()) {
            throw new IllegalArgumentException("Max Lifetime must not be negative");
        }
        if (this.validationTimeout.isNegative()) {
            throw new IllegalArgumentException("Validation timeout must not be negative");
        }
        if (this.connectionFactoryConfigurationSupplier == null) {
            throw new IllegalArgumentException("Connection factory configuration not defined");
        }
    }

    @Override
    public AgroalConnectionPoolConfiguration get() {
        this.validate();
        this.lock = true;
        return new AgroalConnectionPoolConfiguration(){

            @Override
            public AgroalConnectionFactoryConfiguration connectionFactoryConfiguration() {
                return AgroalConnectionPoolConfigurationSupplier.this.connectionFactoryConfigurationSupplier.get();
            }

            @Override
            public TransactionIntegration transactionIntegration() {
                return AgroalConnectionPoolConfigurationSupplier.this.transactionIntegration;
            }

            @Override
            public int initialSize() {
                return AgroalConnectionPoolConfigurationSupplier.this.initialSize;
            }

            @Override
            public int minSize() {
                return AgroalConnectionPoolConfigurationSupplier.this.minSize;
            }

            @Override
            public void setMinSize(int size) {
                if (size < 0) {
                    throw new IllegalArgumentException("Invalid min size: smaller than 0");
                }
                if (size > AgroalConnectionPoolConfigurationSupplier.this.maxSize) {
                    throw new IllegalArgumentException("Invalid min size: greater than max size");
                }
                AgroalConnectionPoolConfigurationSupplier.this.minSize = size;
            }

            @Override
            public int maxSize() {
                return AgroalConnectionPoolConfigurationSupplier.this.maxSize;
            }

            @Override
            public void setMaxSize(int size) {
                if (size <= 0) {
                    throw new IllegalArgumentException("A Positive max size is required");
                }
                if (size < AgroalConnectionPoolConfigurationSupplier.this.minSize) {
                    throw new IllegalArgumentException("Invalid max size: smaller than min size");
                }
                AgroalConnectionPoolConfigurationSupplier.this.maxSize = size;
            }

            @Override
            public Duration acquisitionTimeout() {
                return AgroalConnectionPoolConfigurationSupplier.this.acquisitionTimeout;
            }

            @Override
            public void setAcquisitionTimeout(Duration timeout) {
                if (timeout.isNegative()) {
                    throw new IllegalArgumentException("Acquisition timeout must not be negative");
                }
                AgroalConnectionPoolConfigurationSupplier.this.acquisitionTimeout = timeout;
            }

            @Override
            public AgroalConnectionPoolConfiguration.ConnectionValidator connectionValidator() {
                return AgroalConnectionPoolConfigurationSupplier.this.connectionValidator;
            }

            @Override
            public AgroalConnectionPoolConfiguration.ExceptionSorter exceptionSorter() {
                return AgroalConnectionPoolConfigurationSupplier.this.exceptionSorter;
            }

            @Override
            public Duration idleValidationTimeout() {
                return AgroalConnectionPoolConfigurationSupplier.this.idleValidationTimeout;
            }

            @Override
            public Duration leakTimeout() {
                return AgroalConnectionPoolConfigurationSupplier.this.leakTimeout;
            }

            @Override
            public Duration validationTimeout() {
                return AgroalConnectionPoolConfigurationSupplier.this.validationTimeout;
            }

            @Override
            public Duration reapTimeout() {
                return AgroalConnectionPoolConfigurationSupplier.this.reapTimeout;
            }

            @Override
            public Duration maxLifetime() {
                return AgroalConnectionPoolConfigurationSupplier.this.maxLifetime;
            }
        };
    }
}

