/*
 * Decompiled with CFR 0.152.
 */
package io.agroal.pool;

import io.agroal.api.configuration.AgroalConnectionFactoryConfiguration;
import io.agroal.api.security.NamePrincipal;
import io.agroal.api.security.SimplePassword;
import java.security.Principal;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;

public final class ConnectionFactory {
    private static final String USER_PROPERTY_NAME = "user";
    private static final String PASSWORD_PROPERTY_NAME = "password";
    private AgroalConnectionFactoryConfiguration configuration;
    private Driver driver;
    private Properties jdbcProperties;

    public ConnectionFactory(AgroalConnectionFactoryConfiguration configuration) {
        try {
            ClassLoader driverLoader = configuration.classLoaderProvider().getClassLoader(configuration.driverClassName());
            Class<?> driverClass = driverLoader.loadClass(configuration.driverClassName());
            this.driver = (Driver)driverClass.newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            try {
                this.driver = DriverManager.getDriver(configuration.jdbcUrl());
            }
            catch (SQLException ig) {
                throw new RuntimeException("Unable to load driver class", e);
            }
        }
        this.configuration = configuration;
        this.jdbcProperties = configuration.jdbcProperties();
        this.setupSecurity(configuration);
    }

    private void setupSecurity(AgroalConnectionFactoryConfiguration configuration) {
        Principal principal = configuration.principal();
        if (principal != null) {
            if (principal instanceof NamePrincipal) {
                this.jdbcProperties.put(USER_PROPERTY_NAME, principal.getName());
            } else {
                throw new IllegalArgumentException("Unknown Principal type: " + principal.getClass().getName());
            }
        }
        for (Object credential : configuration.credentials()) {
            if (credential instanceof SimplePassword) {
                this.jdbcProperties.put(PASSWORD_PROPERTY_NAME, ((SimplePassword)credential).getWord());
                continue;
            }
            throw new IllegalArgumentException("Unknown Credential type: " + credential.getClass().getName());
        }
    }

    public Connection createConnection() throws SQLException {
        Connection connection = this.driver.connect(this.configuration.jdbcUrl(), this.jdbcProperties);
        connection.setAutoCommit(this.configuration.autoCommit());
        connection.setTransactionIsolation(this.configuration.jdbcTransactionIsolation().level());
        if (this.configuration.initialSql() != null && !this.configuration.initialSql().isEmpty()) {
            try (Statement statement = connection.createStatement();){
                statement.execute(this.configuration.initialSql());
            }
        }
        return connection;
    }
}

