/*
 * Decompiled with CFR 0.152.
 */
package io.agroal.pool;

import io.agroal.api.AgroalDataSource;
import io.agroal.api.AgroalDataSourceListener;
import io.agroal.api.AgroalDataSourceMetrics;
import io.agroal.api.configuration.AgroalDataSourceConfiguration;
import io.agroal.pool.ConnectionPool;
import io.agroal.pool.DefaultMetricsRepository;
import io.agroal.pool.MetricsRepository;
import io.agroal.pool.util.UncheckedArrayList;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;

public final class DataSource
implements AgroalDataSource,
AgroalDataSourceConfiguration.MetricsEnabledListener {
    private static final long serialVersionUID = 6485903416474487024L;
    private final AgroalDataSourceConfiguration configuration;
    private final List<AgroalDataSourceListener> listenerList;
    private final ConnectionPool connectionPool;
    private MetricsRepository dataSourceMetrics;

    public DataSource(AgroalDataSourceConfiguration dataSourceConfiguration, AgroalDataSourceListener ... listeners) {
        this.configuration = dataSourceConfiguration;
        this.connectionPool = new ConnectionPool(dataSourceConfiguration.connectionPoolConfiguration(), this);
        dataSourceConfiguration.registerMetricsEnabledListener((AgroalDataSourceConfiguration.MetricsEnabledListener)this);
        this.onMetricsEnabled(dataSourceConfiguration.metricsEnabled());
        this.listenerList = listeners.length == 0 ? Collections.emptyList() : new UncheckedArrayList<AgroalDataSourceListener>(AgroalDataSourceListener.class, listeners);
        this.connectionPool.init();
    }

    public Collection<AgroalDataSourceListener> listenerList() {
        return this.listenerList;
    }

    public MetricsRepository metricsRepository() {
        return this.dataSourceMetrics;
    }

    public void onMetricsEnabled(boolean metricsEnabled) {
        this.dataSourceMetrics = metricsEnabled ? new DefaultMetricsRepository(this.connectionPool) : new MetricsRepository.EmptyMetricsRepository();
    }

    public AgroalDataSourceConfiguration getConfiguration() {
        return this.configuration;
    }

    public AgroalDataSourceMetrics getMetrics() {
        return this.dataSourceMetrics;
    }

    @Deprecated
    public void addListener(AgroalDataSourceListener listener) {
        throw new UnsupportedOperationException("Deprecated. Add listeners using the constructor or AgroalDataSource factory methods");
    }

    public void close() {
        this.connectionPool.close();
    }

    public Connection getConnection() throws SQLException {
        return this.connectionPool.getConnection();
    }

    public Connection getConnection(String username, String password) throws SQLException {
        throw new SQLException("username and password combination invalid on a pooled data source!");
    }

    public <T> T unwrap(Class<T> target) throws SQLException {
        return null;
    }

    public boolean isWrapperFor(Class<?> target) throws SQLException {
        return false;
    }

    public PrintWriter getLogWriter() throws SQLException {
        return null;
    }

    public void setLogWriter(PrintWriter out) throws SQLException {
    }

    public int getLoginTimeout() throws SQLException {
        return 0;
    }

    public void setLoginTimeout(int seconds) throws SQLException {
    }

    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("Not Supported");
    }
}

