/*
 * Decompiled with CFR 0.152.
 */
package io.agroal.pool;

import io.agroal.pool.ConnectionPool;
import io.agroal.pool.MetricsRepository;
import java.time.Duration;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;

public final class DefaultMetricsRepository
implements MetricsRepository {
    private final ConnectionPool connectionPool;
    private final LongAdder creationCount = new LongAdder();
    private final LongAdder creationTotalTime = new LongAdder();
    private final LongAdder acquireCount = new LongAdder();
    private final LongAdder returnCount = new LongAdder();
    private final LongAdder acquireTotalTime = new LongAdder();
    private final LongAdder leakDetectionCount = new LongAdder();
    private final LongAdder invalidCount = new LongAdder();
    private final LongAdder flushCount = new LongAdder();
    private final LongAdder reapCount = new LongAdder();
    private final LongAdder destroyCount = new LongAdder();
    private final AtomicLong maxCreatedDuration = new AtomicLong(0L);
    private final AtomicLong maxAcquireDuration = new AtomicLong(0L);

    public DefaultMetricsRepository(ConnectionPool pool) {
        this.connectionPool = pool;
    }

    private void setMaxValue(AtomicLong field, long value) {
        long oldMax;
        while (value > (oldMax = field.get())) {
            if (!field.compareAndSet(oldMax, value)) continue;
            return;
        }
    }

    @Override
    public long beforeConnectionCreation() {
        return System.nanoTime();
    }

    @Override
    public void afterConnectionCreation(long timestamp) {
        long duration = System.nanoTime() - timestamp;
        this.creationCount.increment();
        this.creationTotalTime.add(duration);
        this.setMaxValue(this.maxCreatedDuration, duration);
    }

    @Override
    public long beforeConnectionAcquire() {
        return System.nanoTime();
    }

    @Override
    public void afterConnectionAcquire(long timestamp) {
        long duration = System.nanoTime() - timestamp;
        this.acquireCount.increment();
        this.acquireTotalTime.add(duration);
        this.setMaxValue(this.maxAcquireDuration, duration);
    }

    @Override
    public void afterConnectionReturn() {
        this.returnCount.increment();
    }

    @Override
    public void afterLeakDetection() {
        this.leakDetectionCount.increment();
    }

    @Override
    public void afterConnectionInvalid() {
        this.invalidCount.increment();
    }

    @Override
    public void afterConnectionFlush() {
        this.flushCount.increment();
    }

    @Override
    public void afterConnectionReap() {
        this.reapCount.increment();
    }

    @Override
    public void afterConnectionDestroy() {
        this.destroyCount.increment();
    }

    public long creationCount() {
        return this.creationCount.longValue();
    }

    public Duration creationTimeAverage() {
        if (this.creationCount.longValue() == 0L) {
            return Duration.ZERO;
        }
        return Duration.ofNanos(this.creationTotalTime.longValue() / this.creationCount.longValue());
    }

    public Duration creationTimeMax() {
        return Duration.ofNanos(this.maxCreatedDuration.get());
    }

    public Duration creationTimeTotal() {
        return Duration.ofNanos(this.creationTotalTime.longValue());
    }

    public long acquireCount() {
        return this.acquireCount.longValue();
    }

    public long leakDetectionCount() {
        return this.leakDetectionCount.longValue();
    }

    public long invalidCount() {
        return this.invalidCount.longValue();
    }

    public long flushCount() {
        return this.flushCount.longValue();
    }

    public long reapCount() {
        return this.reapCount.longValue();
    }

    public long destroyCount() {
        return this.destroyCount.longValue();
    }

    public long activeCount() {
        return this.connectionPool.activeCount();
    }

    public long maxUsedCount() {
        return this.connectionPool.maxUsedCount();
    }

    public long availableCount() {
        return this.connectionPool.availableCount();
    }

    public Duration blockingTimeAverage() {
        if (this.acquireCount.longValue() == 0L) {
            return Duration.ZERO;
        }
        return Duration.ofNanos(this.acquireTotalTime.longValue() / this.acquireCount.longValue());
    }

    public Duration blockingTimeMax() {
        return Duration.ofNanos(this.maxAcquireDuration.get());
    }

    public Duration blockingTimeTotal() {
        return Duration.ofNanos(this.acquireTotalTime.longValue());
    }

    public long awaitingCount() {
        return this.connectionPool.awaitingCount();
    }

    public void reset() {
        this.creationCount.reset();
        this.creationTotalTime.reset();
        this.acquireCount.reset();
        this.acquireTotalTime.reset();
        this.leakDetectionCount.reset();
        this.invalidCount.reset();
        this.maxCreatedDuration.set(0L);
        this.maxAcquireDuration.set(0L);
        this.connectionPool.resetMaxUsedCount();
    }

    public String toString() {
        double avgCreationMs = (double)this.creationTimeAverage().toNanos() / (double)TimeUnit.MILLISECONDS.toNanos(1L);
        double avgBlockingMs = (double)this.blockingTimeAverage().toNanos() / (double)TimeUnit.MILLISECONDS.toNanos(1L);
        String s1 = String.format(Locale.ROOT, "Connections: {0} created | {1} invalid | {2} reap | {3} flush | {4} destroyed", this.creationCount, this.invalidCount, this.reapCount, this.flushCount, this.destroyCount);
        String s2 = String.format(Locale.ROOT, "Pool: {0} available | {1} active | {2} max | {3} acquired | {4} returned", this.availableCount(), this.activeCount(), this.maxUsedCount(), this.acquireCount, this.returnCount);
        String s3 = String.format(Locale.ROOT, "Created duration: {0,number,000.000}ms average | {1}ms max | {2}ms total", avgCreationMs, this.creationTimeMax().toMillis(), this.creationTimeTotal().toMillis());
        String s4 = String.format(Locale.ROOT, "Acquire duration: {0,number,000.000}ms average | {1}ms max | {2}ms total", avgBlockingMs, this.blockingTimeMax().toMillis(), this.blockingTimeTotal().toMillis());
        String s5 = String.format(Locale.ROOT, "Threads awaiting: {0}", this.awaitingCount());
        String nl = System.lineSeparator();
        return nl + "===" + nl + s1 + nl + s2 + nl + s3 + nl + s4 + nl + s5 + nl + "===";
    }
}

