/*
 * Decompiled with CFR 0.152.
 */
package io.agroal.springframework.boot.health;

import io.agroal.api.AgroalDataSource;
import io.agroal.springframework.boot.AgroalDataSourceAutoConfiguration;
import io.agroal.springframework.boot.health.AgroalDataSourceHealthIndicator;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.autoconfigure.health.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.actuate.autoconfigure.jdbc.DataSourceHealthContributorAutoConfiguration;
import org.springframework.boot.actuate.health.CompositeHealthContributor;
import org.springframework.boot.actuate.health.HealthContributor;
import org.springframework.boot.actuate.jdbc.DataSourceHealthIndicator;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.jdbc.DataSourceUnwrapper;
import org.springframework.boot.jdbc.metadata.CompositeDataSourcePoolMetadataProvider;
import org.springframework.boot.jdbc.metadata.DataSourcePoolMetadata;
import org.springframework.boot.jdbc.metadata.DataSourcePoolMetadataProvider;
import org.springframework.context.annotation.Bean;
import org.springframework.util.Assert;

@AutoConfiguration(before={DataSourceHealthContributorAutoConfiguration.class}, after={AgroalDataSourceAutoConfiguration.class})
@ConditionalOnClass(value={DataSourceHealthContributorAutoConfiguration.class, AgroalDataSource.class})
@ConditionalOnBean(value={DataSource.class})
@ConditionalOnEnabledHealthIndicator(value="db")
public class AgroalDataSourceHealthContributorAutoConfiguration {
    private final DataSourcePoolMetadataProvider poolMetadataProvider;

    public AgroalDataSourceHealthContributorAutoConfiguration(ObjectProvider<DataSourcePoolMetadataProvider> metadataProviders) {
        this.poolMetadataProvider = new CompositeDataSourcePoolMetadataProvider((Collection)metadataProviders.orderedStream().collect(Collectors.toList()));
    }

    @Bean
    @ConditionalOnMissingBean(name={"dbHealthIndicator", "dbHealthContributor"})
    public HealthContributor dbHealthContributor(Map<String, DataSource> dataSources) {
        Assert.notEmpty(dataSources, (String)"Beans must not be empty");
        Map<String, HealthContributor> healthContributors = dataSources.entrySet().stream().map(this::createContributor).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        if (healthContributors.size() == 1) {
            return healthContributors.values().iterator().next();
        }
        return CompositeHealthContributor.fromMap(healthContributors);
    }

    private Map.Entry<String, HealthContributor> createContributor(Map.Entry<String, DataSource> entry) {
        AgroalDataSource agroalDataSource = (AgroalDataSource)DataSourceUnwrapper.unwrap((DataSource)entry.getValue(), AgroalDataSource.class);
        HealthContributor hc = agroalDataSource != null ? this.createContributor(agroalDataSource) : this.createContributor(entry.getValue());
        return Map.entry(entry.getKey(), hc);
    }

    private HealthContributor createContributor(AgroalDataSource source) {
        return new AgroalDataSourceHealthIndicator(source);
    }

    private HealthContributor createContributor(DataSource source) {
        DataSourcePoolMetadata poolMetadata = this.poolMetadataProvider.getDataSourcePoolMetadata(source);
        String query = poolMetadata != null ? poolMetadata.getValidationQuery() : null;
        return new DataSourceHealthIndicator(source, query);
    }
}

