/*
 * Decompiled with CFR 0.152.
 */
package io.agroal.test;

import io.agroal.test.MockConnection;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public interface MockDriver
extends Driver {
    public static final DriverPropertyInfo[] EMPTY_PROPERTY_INFO = new DriverPropertyInfo[0];

    public static void registerMockDriver(final Class<? extends Connection> connectionType) {
        try {
            DriverManager.registerDriver(new MockDriver(){

                @Override
                public Connection connect(String url, Properties info) throws SQLException {
                    try {
                        return (Connection)connectionType.newInstance();
                    }
                    catch (IllegalAccessException | InstantiationException e) {
                        throw new SQLException("Cannot create mock connection", e);
                    }
                }
            });
        }
        catch (SQLException e) {
            Logger.getLogger(MockDriver.class.getName()).log(Level.WARNING, "Unable to register MockDriver into Driver Manager", e);
        }
    }

    public static void registerMockDriver() {
        MockDriver.registerMockDriver(MockConnection.Empty.class);
    }

    public static void deregisterMockDriver() {
        try {
            DriverManager.deregisterDriver(DriverManager.getDriver(""));
        }
        catch (SQLException e) {
            Logger.getLogger(MockDriver.class.getName()).log(Level.WARNING, "Unable to deregister MockDriver from Driver Manager", e);
        }
    }

    @Override
    default public Connection connect(String url, Properties info) throws SQLException {
        return null;
    }

    @Override
    default public boolean acceptsURL(String url) throws SQLException {
        return true;
    }

    @Override
    default public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return EMPTY_PROPERTY_INFO;
    }

    @Override
    default public int getMajorVersion() {
        return 0;
    }

    @Override
    default public int getMinorVersion() {
        return 0;
    }

    @Override
    default public boolean jdbcCompliant() {
        return false;
    }

    @Override
    default public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return null;
    }
}

