// Copyright (C) 2017 Red Hat, Inc. and individual contributors as indicated by the @author tags.
// You may not use this file except in compliance with the Apache License, Version 2.0.

package io.agroal.test;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;

import static java.lang.System.identityHashCode;

/**
 * @author <a href="lbarreiro@redhat.com">Luis Barreiro</a>
 */
public interface MockStatement extends Statement {

    long[] LARGE_BATCH = new long[0];
    int[] BATCH = new int[0];

    // --- //

    @Override
    default long getLargeUpdateCount() throws SQLException {
        return 0;
    }

    @Override
    default long getLargeMaxRows() throws SQLException {
        return Statement.super.getLargeMaxRows();
    }

    @Override
    default void setLargeMaxRows(long max) throws SQLException {
    }

    @Override
    default long[] executeLargeBatch() throws SQLException {
        return LARGE_BATCH;
    }

    @Override
    default long executeLargeUpdate(String sql) throws SQLException {
        return 0;
    }

    @Override
    default long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return 0;
    }

    @Override
    default long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return 0;
    }

    @Override
    default long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        return 0;
    }

    @Override
    default ResultSet executeQuery(String sql) throws SQLException {
        return new MockResultSet.Empty();
    }

    @Override
    default int executeUpdate(String sql) throws SQLException {
        return 0;
    }

    @Override
    default void close() throws SQLException {

    }

    @Override
    default int getMaxFieldSize() throws SQLException {
        return 0;
    }

    @Override
    default void setMaxFieldSize(int max) throws SQLException {
    }

    @Override
    default int getMaxRows() throws SQLException {
        return 0;
    }

    @Override
    default void setMaxRows(int max) throws SQLException {
    }

    @Override
    default void setEscapeProcessing(boolean enable) throws SQLException {
    }

    @Override
    default int getQueryTimeout() throws SQLException {
        return 0;
    }

    @Override
    default void setQueryTimeout(int seconds) throws SQLException {
    }

    @Override
    default void cancel() throws SQLException {
    }

    @Override
    default SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    default void clearWarnings() throws SQLException {
    }

    @Override
    default void setCursorName(String name) throws SQLException {
    }

    @Override
    default boolean execute(String sql) throws SQLException {
        return false;
    }

    @Override
    default ResultSet getResultSet() throws SQLException {
        return new MockResultSet.Empty();
    }

    @Override
    default int getUpdateCount() throws SQLException {
        return 0;
    }

    @Override
    default boolean getMoreResults() throws SQLException {
        return false;
    }

    @Override
    default int getFetchDirection() throws SQLException {
        return ResultSet.FETCH_FORWARD;
    }

    @Override
    default void setFetchDirection(int direction) throws SQLException {

    }

    @Override
    default int getFetchSize() throws SQLException {
        return 0;
    }

    @Override
    default void setFetchSize(int rows) throws SQLException {

    }

    @Override
    default int getResultSetConcurrency() throws SQLException {
        return ResultSet.CONCUR_READ_ONLY;
    }

    @Override
    default int getResultSetType() throws SQLException {
        return ResultSet.TYPE_FORWARD_ONLY;
    }

    @Override
    default void addBatch(String sql) throws SQLException {
    }

    @Override
    default void clearBatch() throws SQLException {
    }

    @Override
    default int[] executeBatch() throws SQLException {
        return BATCH;
    }

    @Override
    default Connection getConnection() throws SQLException {
        return null;
    }

    @Override
    default boolean getMoreResults(int current) throws SQLException {
        return false;
    }

    @Override
    default ResultSet getGeneratedKeys() throws SQLException {
        return new MockResultSet.Empty();
    }

    @Override
    default int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return 0;
    }

    @Override
    default int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return 0;
    }

    @Override
    default int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return 0;
    }

    @Override
    default boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return false;
    }

    @Override
    default boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return false;
    }

    @Override
    default boolean execute(String sql, String[] columnNames) throws SQLException {
        return false;
    }

    @Override
    default int getResultSetHoldability() throws SQLException {
        return 0;
    }

    @Override
    default boolean isClosed() throws SQLException {
        return false;
    }

    @Override
    default boolean isPoolable() throws SQLException {
        return false;
    }

    @Override
    default void setPoolable(boolean poolable) throws SQLException {
    }

    @Override
    default void closeOnCompletion() throws SQLException {
    }

    @Override
    default boolean isCloseOnCompletion() throws SQLException {
        return false;
    }

    @Override
    default <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    default boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    // --- //

    class Empty implements MockStatement {

        @Override
        public String toString() {
            return "MockStatement@" + identityHashCode( this );
        }
    }
}
