/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.common.config;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;

public class ConfigFileConfiguration
extends PropertiesConfiguration {
    protected static URL findConfigUrlInDirectory(File directory, String configName) {
        File cfile;
        if (directory.isDirectory() && (cfile = new File(directory, configName)).isFile()) {
            try {
                return cfile.toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public static ConfigFileConfiguration create(String configFileName) {
        try {
            return new ConfigFileConfiguration(configFileName);
        }
        catch (ConfigurationException e) {
            throw new RuntimeException("Failed to find configuration file: " + configFileName, e);
        }
    }

    private static URL discoverConfigFileUrl(String configFileName) {
        File dirFile;
        String jbossConfigDir = System.getProperty("jboss.server.config.dir");
        String jbossConfigUrl = System.getProperty("jboss.server.config.url");
        URL rval = null;
        if (jbossConfigDir != null && (rval = ConfigFileConfiguration.findConfigUrlInDirectory(dirFile = new File(jbossConfigDir), configFileName)) != null) {
            return rval;
        }
        if (jbossConfigUrl != null && (rval = ConfigFileConfiguration.findConfigUrlInDirectory(dirFile = new File(jbossConfigUrl), configFileName)) != null) {
            return rval;
        }
        return ConfigFileConfiguration.class.getResource("empty.properties");
    }

    private ConfigFileConfiguration(String configFileName) throws ConfigurationException {
        super(ConfigFileConfiguration.discoverConfigFileUrl(configFileName));
    }
}

