/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.common.plugin;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.IOUtils;

public class PluginClassLoader
extends ClassLoader {
    private ZipFile pluginArtifactZip;
    private List<ZipFile> dependencyZips;
    private File workDir;

    public PluginClassLoader(File pluginArtifactFile) throws IOException {
        this.pluginArtifactZip = new ZipFile(pluginArtifactFile);
        this.workDir = this.createWorkDir(pluginArtifactFile);
        this.indexPluginArtifact();
    }

    public PluginClassLoader(File pluginArtifactFile, ClassLoader parent) throws IOException {
        super(parent);
        this.pluginArtifactZip = new ZipFile(pluginArtifactFile);
        this.workDir = this.createWorkDir(pluginArtifactFile);
        this.indexPluginArtifact();
    }

    protected File createWorkDir(File pluginArtifactFile) throws IOException {
        File tempDir = File.createTempFile(pluginArtifactFile.getName(), "");
        tempDir.delete();
        tempDir.mkdirs();
        return tempDir;
    }

    private void indexPluginArtifact() throws IOException {
        this.dependencyZips = new ArrayList<ZipFile>();
        Enumeration<? extends ZipEntry> entries = this.pluginArtifactZip.entries();
        while (entries.hasMoreElements()) {
            ZipFile dependencyZipFile;
            ZipEntry zipEntry = entries.nextElement();
            if (!zipEntry.getName().startsWith("WEB-INF/lib/") || !zipEntry.getName().toLowerCase().endsWith(".jar") || (dependencyZipFile = this.extractDependency(zipEntry)) == null) continue;
            this.dependencyZips.add(dependencyZipFile);
        }
    }

    private ZipFile extractDependency(ZipEntry zipEntry) throws IOException {
        String depFileName;
        File depFile;
        File dependencyWorkDir = new File(this.workDir, "lib");
        if (!dependencyWorkDir.exists()) {
            dependencyWorkDir.mkdirs();
        }
        if (!(depFile = new File(dependencyWorkDir, depFileName = new File(zipEntry.getName()).getName())).isFile()) {
            InputStream input = null;
            FileOutputStream output = null;
            try {
                input = this.pluginArtifactZip.getInputStream(zipEntry);
                output = new FileOutputStream(depFile);
                IOUtils.copy((InputStream)input, (OutputStream)output);
                output.flush();
            }
            catch (IOException e) {
                try {
                    throw e;
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(input);
                    IOUtils.closeQuietly(output);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)input);
            IOUtils.closeQuietly((OutputStream)output);
        }
        return new ZipFile(depFile);
    }

    private URL extractResource(ZipEntry zipEntry) throws IOException {
        File resourceFile;
        File resourceWorkDir = new File(this.workDir, "resources");
        if (!resourceWorkDir.exists()) {
            resourceWorkDir.mkdirs();
        }
        if (!(resourceFile = new File(resourceWorkDir, zipEntry.getName())).isFile()) {
            resourceFile.getParentFile().mkdirs();
            InputStream input = null;
            FileOutputStream output = null;
            try {
                input = this.pluginArtifactZip.getInputStream(zipEntry);
                output = new FileOutputStream(resourceFile);
                IOUtils.copy((InputStream)input, (OutputStream)output);
                output.flush();
            }
            catch (IOException e) {
                try {
                    throw e;
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(input);
                    IOUtils.closeQuietly(output);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)input);
            IOUtils.closeQuietly((OutputStream)output);
        }
        return resourceFile.toURI().toURL();
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        InputStream inputStream = null;
        try {
            inputStream = this.findClassContent(name);
            if (inputStream == null) {
                Class<?> clazz = super.findClass(name);
                return clazz;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)inputStream, (OutputStream)baos);
            byte[] bytes = baos.toByteArray();
            Class<?> clazz = this.defineClass(name, bytes, 0, bytes.length);
            return clazz;
        }
        catch (IOException e) {
            throw new ClassNotFoundException(name, e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    protected InputStream findClassContent(String className) throws IOException {
        String primaryArtifactEntryName = "WEB-INF/classes/" + className.replace('.', '/') + ".class";
        String dependencyEntryName = className.replace('.', '/') + ".class";
        ZipEntry entry = this.pluginArtifactZip.getEntry(primaryArtifactEntryName);
        if (entry != null) {
            return this.pluginArtifactZip.getInputStream(entry);
        }
        for (ZipFile zipFile : this.dependencyZips) {
            entry = zipFile.getEntry(dependencyEntryName);
            if (entry == null) continue;
            return zipFile.getInputStream(entry);
        }
        return null;
    }

    @Override
    protected URL findResource(String name) {
        Enumeration<? extends ZipEntry> entries = this.pluginArtifactZip.entries();
        while (entries.hasMoreElements()) {
            ZipEntry zipEntry = entries.nextElement();
            if (!zipEntry.getName().equalsIgnoreCase(name)) continue;
            try {
                return this.extractResource(zipEntry);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return super.findResource(name);
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        ArrayList<URL> resources = new ArrayList<URL>();
        Enumeration<? extends ZipEntry> entries = this.pluginArtifactZip.entries();
        while (entries.hasMoreElements()) {
            ZipEntry zipEntry = entries.nextElement();
            if (!zipEntry.getName().equalsIgnoreCase(name)) continue;
            try {
                resources.add(this.extractResource(zipEntry));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        final Iterator iterator = resources.iterator();
        return new Enumeration<URL>(){

            @Override
            public boolean hasMoreElements() {
                return iterator.hasNext();
            }

            @Override
            public URL nextElement() {
                return (URL)iterator.next();
            }
        };
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }

    public void close() throws IOException {
        this.pluginArtifactZip.close();
        for (ZipFile zipFile : this.dependencyZips) {
            zipFile.close();
        }
    }

    public List<URL> getPolicyDefinitionResources() {
        ArrayList<URL> resources = new ArrayList<URL>();
        Enumeration<? extends ZipEntry> entries = this.pluginArtifactZip.entries();
        while (entries.hasMoreElements()) {
            ZipEntry zipEntry = entries.nextElement();
            if (!zipEntry.getName().toLowerCase().startsWith("meta-inf/apiman/policydefs/") || !zipEntry.getName().toLowerCase().endsWith(".json")) continue;
            try {
                resources.add(this.extractResource(zipEntry));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return resources;
    }
}

