/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.common.plugin;

import java.io.Serializable;

public class PluginCoordinates
implements Serializable {
    private static final long serialVersionUID = -1368521324833902631L;
    private String groupId;
    private String artifactId;
    private String version;
    private String classifier;
    private String type = "war";

    public PluginCoordinates() {
    }

    public PluginCoordinates(String groupId, String artifactId, String version) {
        this.setGroupId(groupId);
        this.setArtifactId(artifactId);
        this.setVersion(version);
    }

    public PluginCoordinates(String groupId, String artifactId, String version, String classifier, String type) {
        this.setGroupId(groupId);
        this.setArtifactId(artifactId);
        this.setVersion(version);
        this.setClassifier(classifier);
        if (type != null) {
            this.setType(type);
        }
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public void setClassifier(String classifier) {
        this.classifier = classifier;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.artifactId == null ? 0 : this.artifactId.hashCode());
        result = 31 * result + (this.classifier == null ? 0 : this.classifier.hashCode());
        result = 31 * result + (this.groupId == null ? 0 : this.groupId.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PluginCoordinates other = (PluginCoordinates)obj;
        if (this.artifactId == null ? other.artifactId != null : !this.artifactId.equals(other.artifactId)) {
            return false;
        }
        if (this.classifier == null ? other.classifier != null : !this.classifier.equals(other.classifier)) {
            return false;
        }
        if (this.groupId == null ? other.groupId != null : !this.groupId.equals(other.groupId)) {
            return false;
        }
        if (this.type == null ? other.type != null : !this.type.equals(other.type)) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getGroupId());
        builder.append(':');
        builder.append(this.getArtifactId());
        builder.append(':');
        builder.append(this.getVersion());
        if (this.getClassifier() != null) {
            builder.append('-').append(this.getClassifier());
        }
        builder.append(':');
        if (this.getType() == null) {
            builder.append("war");
        } else {
            builder.append(this.getType());
        }
        return builder.toString();
    }

    public static final PluginCoordinates fromPolicySpec(String pluginPolicySpec) {
        if (pluginPolicySpec == null) {
            return null;
        }
        int startIdx = 7;
        int endIdx = pluginPolicySpec.indexOf(47);
        String[] split = pluginPolicySpec.substring(startIdx, endIdx).split(":");
        String groupId = split[0];
        String artifactId = split[1];
        String version = split[2];
        String classifier = null;
        String type = null;
        if (split.length == 4) {
            type = split[3];
        }
        if (split.length == 5) {
            classifier = split[3];
            type = split[4];
        }
        PluginCoordinates rval = new PluginCoordinates(groupId, artifactId, version, classifier, type);
        return rval;
    }
}

