/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.gateway.engine.beans;

import java.util.HashMap;

public class HeaderHashMap
extends HashMap<String, String> {
    private static final long serialVersionUID = -8627183971399152775L;
    private HashMap<String, String> caseInsensitiveIndex = new HashMap();

    @Override
    public void clear() {
        super.clear();
        this.caseInsensitiveIndex.clear();
    }

    @Override
    public String get(Object key) {
        String rval = (String)super.get(key);
        if (rval == null) {
            String trimmedKey = HeaderHashMap.trim((String)key);
            rval = this.caseInsensitiveIndex.get(trimmedKey.toLowerCase());
        }
        return rval;
    }

    @Override
    public boolean containsKey(Object key) {
        boolean rval = super.containsKey(key);
        if (!rval) {
            String trimmedKey = HeaderHashMap.trim((String)key);
            rval = this.caseInsensitiveIndex.containsKey(trimmedKey.toLowerCase());
        }
        return rval;
    }

    @Override
    public String put(String key, String value) {
        String trimmedKey = HeaderHashMap.trim(key);
        String trimmedValue = HeaderHashMap.trim(value);
        String rval = super.put(trimmedKey, trimmedValue);
        this.caseInsensitiveIndex.put(trimmedKey.toLowerCase(), trimmedValue);
        return rval;
    }

    @Override
    public String remove(Object key) {
        String trimmedKey = HeaderHashMap.trim((String)key);
        this.caseInsensitiveIndex.remove(trimmedKey.toLowerCase());
        return (String)super.remove(trimmedKey);
    }

    private static String trim(String string) {
        return string == null ? null : string.trim();
    }
}

