/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.saml;

import java.io.IOException;
import java.net.URI;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.X509Certificate;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.keycloak.protocol.saml.SAML2LoginResponseBuilder;
import org.keycloak.protocol.saml.SamlProtocolUtils;
import org.keycloak.protocol.saml.SignatureAlgorithm;
import org.keycloak.saml.common.constants.JBossSAMLConstants;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;
import org.keycloak.saml.common.exceptions.ConfigurationException;
import org.keycloak.saml.common.exceptions.ProcessingException;
import org.keycloak.saml.common.util.DocumentUtil;
import org.keycloak.saml.common.util.StringUtil;
import org.keycloak.saml.processing.api.saml.v2.sig.SAML2Signature;
import org.keycloak.saml.processing.core.util.XMLEncryptionUtil;
import org.keycloak.saml.processing.web.util.PostBindingUtil;
import org.keycloak.saml.processing.web.util.RedirectBindingUtil;
import org.keycloak.util.HtmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SAML2BindingBuilder<T extends SAML2BindingBuilder> {
    protected static final Logger logger = Logger.getLogger(SAML2BindingBuilder.class);
    public static final String RELAY_STATE = "RelayState";
    protected KeyPair signingKeyPair;
    protected X509Certificate signingCertificate;
    protected boolean sign;
    protected boolean signAssertions;
    protected SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.RSA_SHA1;
    protected String relayState;
    protected String destination;
    protected String issuer;
    protected int encryptionKeySize = 128;
    protected PublicKey encryptionPublicKey;
    protected String encryptionAlgorithm = "AES";
    protected boolean encrypt;

    public T signDocument() {
        this.sign = true;
        return (T)this;
    }

    public T signAssertions() {
        this.signAssertions = true;
        return (T)this;
    }

    public T signWith(KeyPair keyPair) {
        this.signingKeyPair = keyPair;
        return (T)this;
    }

    public T signWith(PrivateKey privateKey, PublicKey publicKey) {
        this.signingKeyPair = new KeyPair(publicKey, privateKey);
        return (T)this;
    }

    public T signWith(KeyPair keyPair, X509Certificate cert) {
        this.signingKeyPair = keyPair;
        this.signingCertificate = cert;
        return (T)this;
    }

    public T signWith(PrivateKey privateKey, PublicKey publicKey, X509Certificate cert) {
        this.signingKeyPair = new KeyPair(publicKey, privateKey);
        this.signingCertificate = cert;
        return (T)this;
    }

    public T signatureAlgorithm(SignatureAlgorithm alg) {
        this.signatureAlgorithm = alg;
        return (T)this;
    }

    public T encrypt(PublicKey publicKey) {
        this.encrypt = true;
        this.encryptionPublicKey = publicKey;
        return (T)this;
    }

    public T encryptionAlgorithm(String alg) {
        this.encryptionAlgorithm = alg;
        return (T)this;
    }

    public T encryptionKeySize(int size) {
        this.encryptionKeySize = size;
        return (T)this;
    }

    public T destination(String destination) {
        this.destination = destination;
        return (T)this;
    }

    public T issuer(String issuer) {
        this.issuer = issuer;
        return (T)this;
    }

    public T relayState(String relayState) {
        this.relayState = relayState;
        return (T)this;
    }

    private String getSAMLNSPrefix(Document samlResponseDocument) {
        Node assertionElement = samlResponseDocument.getDocumentElement().getElementsByTagNameNS(JBossSAMLURIConstants.ASSERTION_NSURI.get(), JBossSAMLConstants.ASSERTION.get()).item(0);
        if (assertionElement == null) {
            throw new IllegalStateException("Unable to find assertion in saml response document");
        }
        return assertionElement.getPrefix();
    }

    protected void encryptDocument(Document samlDocument) throws ProcessingException {
        String samlNSPrefix = this.getSAMLNSPrefix(samlDocument);
        try {
            QName encryptedAssertionElementQName = new QName(JBossSAMLURIConstants.ASSERTION_NSURI.get(), JBossSAMLConstants.ENCRYPTED_ASSERTION.get(), samlNSPrefix);
            byte[] secret = SamlProtocolUtils.createRandomSecret(this.encryptionKeySize / 8);
            SecretKeySpec secretKey = new SecretKeySpec(secret, this.encryptionAlgorithm);
            XMLEncryptionUtil.encryptElement((QName)new QName(JBossSAMLURIConstants.ASSERTION_NSURI.get(), JBossSAMLConstants.ASSERTION.get(), samlNSPrefix), (Document)samlDocument, (PublicKey)this.encryptionPublicKey, (SecretKey)secretKey, (int)this.encryptionKeySize, (QName)encryptedAssertionElementQName, (boolean)true);
        }
        catch (Exception e) {
            throw new ProcessingException("failed to encrypt", (Throwable)e);
        }
    }

    protected void signDocument(Document samlDocument) throws ProcessingException {
        String signatureMethod = this.signatureAlgorithm.getXmlSignatureMethod();
        String signatureDigestMethod = this.signatureAlgorithm.getXmlSignatureDigestMethod();
        SAML2Signature samlSignature = new SAML2Signature();
        if (signatureMethod != null) {
            samlSignature.setSignatureMethod(signatureMethod);
        }
        if (signatureDigestMethod != null) {
            samlSignature.setDigestMethod(signatureDigestMethod);
        }
        Node nextSibling = samlSignature.getNextSiblingOfIssuer(samlDocument);
        samlSignature.setNextSibling(nextSibling);
        if (this.signingCertificate != null) {
            samlSignature.setX509Certificate(this.signingCertificate);
        }
        samlSignature.signSAMLDocument(samlDocument, this.signingKeyPair);
    }

    protected void signAssertion(Document samlDocument) throws ProcessingException {
        Document temporaryDocument;
        Element originalAssertionElement = DocumentUtil.getChildElement((Element)samlDocument.getDocumentElement(), (QName)new QName(JBossSAMLURIConstants.ASSERTION_NSURI.get(), JBossSAMLConstants.ASSERTION.get()));
        if (originalAssertionElement == null) {
            return;
        }
        Node clonedAssertionElement = originalAssertionElement.cloneNode(true);
        try {
            temporaryDocument = DocumentUtil.createDocument();
        }
        catch (ConfigurationException e) {
            throw new ProcessingException((Throwable)e);
        }
        temporaryDocument.adoptNode(clonedAssertionElement);
        temporaryDocument.appendChild(clonedAssertionElement);
        this.signDocument(temporaryDocument);
        samlDocument.adoptNode(clonedAssertionElement);
        Element parentNode = (Element)originalAssertionElement.getParentNode();
        parentNode.replaceChild(clonedAssertionElement, originalAssertionElement);
    }

    protected Response buildResponse(Document responseDoc, String actionUrl, boolean asRequest) throws ProcessingException, ConfigurationException, IOException {
        String str = this.buildHtmlPostResponse(responseDoc, actionUrl, asRequest);
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        return Response.ok((Object)str, (MediaType)MediaType.TEXT_HTML_TYPE).header("Pragma", (Object)"no-cache").header("Cache-Control", (Object)"no-cache, no-store").build();
    }

    protected String buildHtmlPostResponse(Document responseDoc, String actionUrl, boolean asRequest) throws ProcessingException, ConfigurationException, IOException {
        byte[] responseBytes = DocumentUtil.getDocumentAsString((Document)responseDoc).getBytes("UTF-8");
        String samlResponse = PostBindingUtil.base64Encode((String)new String(responseBytes));
        return this.buildHtml(samlResponse, actionUrl, asRequest);
    }

    protected String buildHtml(String samlResponse, String actionUrl, boolean asRequest) {
        if (this.destination == null) {
            throw SAML2LoginResponseBuilder.logger.nullValueError("Destination is null");
        }
        StringBuilder builder = new StringBuilder();
        String key = "SAMLResponse";
        if (asRequest) {
            key = "SAMLRequest";
        }
        builder.append("<HTML>");
        builder.append("<HEAD>");
        builder.append("<TITLE>HTTP Post Binding Response (Response)</TITLE>");
        builder.append("</HEAD>");
        builder.append("<BODY Onload=\"document.forms[0].submit()\">");
        builder.append("<FORM METHOD=\"POST\" ACTION=\"" + actionUrl + "\">");
        builder.append("<INPUT TYPE=\"HIDDEN\" NAME=\"" + key + "\"" + " VALUE=\"" + samlResponse + "\"/>");
        if (StringUtil.isNotNull((String)this.relayState)) {
            builder.append("<INPUT TYPE=\"HIDDEN\" NAME=\"RelayState\" VALUE=\"" + HtmlUtils.escapeAttribute((String)this.relayState) + "\"/>");
        }
        builder.append("<NOSCRIPT>");
        builder.append("<P>JavaScript is disabled. We strongly recommend to enable it. Click the button below to continue.</P>");
        builder.append("<INPUT TYPE=\"SUBMIT\" VALUE=\"CONTINUE\" />");
        builder.append("</NOSCRIPT>");
        builder.append("</FORM></BODY></HTML>");
        return builder.toString();
    }

    protected String base64Encoded(Document document) throws ConfigurationException, ProcessingException, IOException {
        String documentAsString = org.keycloak.saml.processing.core.saml.v2.util.DocumentUtil.getDocumentAsString((Document)document);
        logger.debugv("saml docment: {0}", (Object)documentAsString);
        byte[] responseBytes = documentAsString.getBytes("UTF-8");
        return RedirectBindingUtil.deflateBase64URLEncode((byte[])responseBytes);
    }

    protected URI generateRedirectUri(String samlParameterName, String redirectUri, Document document) throws ConfigurationException, ProcessingException, IOException {
        UriBuilder builder = UriBuilder.fromUri((String)redirectUri).replaceQuery(null).queryParam(samlParameterName, new Object[]{this.base64Encoded(document)});
        if (this.relayState != null) {
            builder.queryParam(RELAY_STATE, new Object[]{this.relayState});
        }
        if (this.sign) {
            builder.queryParam("SigAlg", new Object[]{this.signatureAlgorithm.getJavaSignatureAlgorithm()});
            URI uri = builder.build(new Object[0]);
            String rawQuery = uri.getRawQuery();
            Signature signature = this.signatureAlgorithm.createSignature();
            byte[] sig = new byte[]{};
            try {
                signature.initSign(this.signingKeyPair.getPrivate());
                signature.update(rawQuery.getBytes("UTF-8"));
                sig = signature.sign();
            }
            catch (Exception e) {
                throw new ProcessingException((Throwable)e);
            }
            String encodedSig = RedirectBindingUtil.base64URLEncode((byte[])sig);
            builder.queryParam("Signature", new Object[]{encodedSig});
        }
        return builder.build(new Object[0]);
    }

    public class RedirectBindingBuilder {
        protected Document document;

        public RedirectBindingBuilder(Document document) throws ProcessingException {
            this.document = document;
            if (SAML2BindingBuilder.this.signAssertions) {
                SAML2BindingBuilder.this.signAssertion(document);
            }
        }

        public Document getDocument() {
            return this.document;
        }

        public URI responseUri(String redirectUri, boolean asRequest) throws ConfigurationException, ProcessingException, IOException {
            String samlParameterName = "SAMLResponse";
            if (asRequest) {
                samlParameterName = "SAMLRequest";
            }
            return SAML2BindingBuilder.this.generateRedirectUri(samlParameterName, redirectUri, this.document);
        }

        public Response response() throws ProcessingException, ConfigurationException, IOException {
            return this.response(SAML2BindingBuilder.this.destination, false);
        }

        public Response response(String redirectUri) throws ProcessingException, ConfigurationException, IOException {
            return this.response(redirectUri, false);
        }

        public Response request(String redirect) throws ProcessingException, ConfigurationException, IOException {
            return this.response(redirect, true);
        }

        public Response request() throws ProcessingException, ConfigurationException, IOException {
            return this.response(SAML2BindingBuilder.this.destination, true);
        }

        private Response response(String redirectUri, boolean asRequest) throws ProcessingException, ConfigurationException, IOException {
            URI uri = this.responseUri(redirectUri, asRequest);
            if (logger.isDebugEnabled()) {
                logger.trace((Object)("redirect-binding uri: " + uri.toString()));
            }
            CacheControl cacheControl = new CacheControl();
            cacheControl.setNoCache(true);
            return Response.status((int)302).location(uri).header("Pragma", (Object)"no-cache").header("Cache-Control", (Object)"no-cache, no-store").build();
        }
    }

    public class PostBindingBuilder {
        protected Document document;

        public PostBindingBuilder(Document document) throws ProcessingException {
            this.document = document;
            if (SAML2BindingBuilder.this.signAssertions) {
                SAML2BindingBuilder.this.signAssertion(document);
            }
            if (SAML2BindingBuilder.this.sign) {
                SAML2BindingBuilder.this.signDocument(document);
            }
        }

        public String encoded() throws ProcessingException, ConfigurationException, IOException {
            byte[] responseBytes = org.keycloak.saml.processing.core.saml.v2.util.DocumentUtil.getDocumentAsString((Document)this.document).getBytes("UTF-8");
            return PostBindingUtil.base64Encode((String)new String(responseBytes));
        }

        public Document getDocument() {
            return this.document;
        }

        public Response request() throws ConfigurationException, ProcessingException, IOException {
            return SAML2BindingBuilder.this.buildResponse(this.document, SAML2BindingBuilder.this.destination, true);
        }

        public Response request(String actionUrl) throws ConfigurationException, ProcessingException, IOException {
            return SAML2BindingBuilder.this.buildResponse(this.document, actionUrl, true);
        }

        public Response response() throws ConfigurationException, ProcessingException, IOException {
            return SAML2BindingBuilder.this.buildResponse(this.document, SAML2BindingBuilder.this.destination, false);
        }

        public Response response(String actionUrl) throws ConfigurationException, ProcessingException, IOException {
            return SAML2BindingBuilder.this.buildResponse(this.document, actionUrl, false);
        }
    }
}

