/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.parsing.operation;

import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.parsing.CharacterHandler;
import org.jboss.as.cli.parsing.DefaultParsingState;
import org.jboss.as.cli.parsing.GlobalCharacterHandlers;
import org.jboss.as.cli.parsing.LineBreakHandler;
import org.jboss.as.cli.parsing.ParsingContext;
import org.jboss.as.cli.parsing.operation.PropertyState;

public class PropertyListState
extends DefaultParsingState {
    public static final PropertyListState INSTANCE = new PropertyListState();
    public static final String ID = "PROP_LIST";

    PropertyListState() {
        this(PropertyState.INSTANCE);
    }

    PropertyListState(PropertyState propState) {
        this('(', ',', propState, ')');
    }

    public PropertyListState(char listStart, char propSeparator, char ... listEnd) {
        this(listStart, propSeparator, new PropertyState(propSeparator, listEnd), listEnd);
    }

    PropertyListState(final char listStart, char propSeparator, final PropertyState propState, char ... listEnd) {
        super(ID);
        for (int i = 0; i < listEnd.length; ++i) {
            this.putHandler(listEnd[i], GlobalCharacterHandlers.LEAVE_STATE_HANDLER);
        }
        this.setEnterHandler(new CharacterHandler(){

            @Override
            public void handle(ParsingContext ctx) throws CommandFormatException {
                if (ctx.getCharacter() != listStart) {
                    ctx.enterState(propState);
                }
            }
        });
        this.setDefaultHandler(new LineBreakHandler(false, false){

            @Override
            protected void doHandle(ParsingContext ctx) throws CommandFormatException {
                ctx.enterState(propState);
            }
        });
        this.putHandler(propSeparator, GlobalCharacterHandlers.NOOP_CHARACTER_HANDLER);
        this.setReturnHandler(new CharacterHandler(){

            @Override
            public void handle(ParsingContext ctx) throws CommandFormatException {
                if (ctx.isEndOfContent()) {
                    return;
                }
                PropertyListState.this.getHandler(ctx.getCharacter()).handle(ctx);
            }
        });
        this.setIgnoreWhitespaces(true);
    }
}

