/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.jpa;

import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import org.keycloak.enums.SslRequired;
import org.keycloak.models.ApplicationModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.OAuthClientModel;
import org.keycloak.models.PasswordPolicy;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RequiredCredentialModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserFederationProviderModel;
import org.keycloak.models.jpa.ApplicationAdapter;
import org.keycloak.models.jpa.OAuthClientAdapter;
import org.keycloak.models.jpa.RoleAdapter;
import org.keycloak.models.jpa.entities.ApplicationEntity;
import org.keycloak.models.jpa.entities.OAuthClientEntity;
import org.keycloak.models.jpa.entities.RealmAttributeEntity;
import org.keycloak.models.jpa.entities.RealmEntity;
import org.keycloak.models.jpa.entities.RequiredCredentialEntity;
import org.keycloak.models.jpa.entities.RoleEntity;
import org.keycloak.models.jpa.entities.UserFederationProviderEntity;
import org.keycloak.models.utils.KeycloakModelUtils;

public class RealmAdapter
implements RealmModel {
    protected RealmEntity realm;
    protected EntityManager em;
    protected volatile transient PublicKey publicKey;
    protected volatile transient PrivateKey privateKey;
    protected volatile transient X509Certificate certificate;
    protected volatile transient Key codeSecretKey;
    protected KeycloakSession session;
    private PasswordPolicy passwordPolicy;
    private static final String BROWSER_HEADER_PREFIX = "_browser_header.";

    public RealmAdapter(KeycloakSession session, EntityManager em, RealmEntity realm) {
        this.session = session;
        this.em = em;
        this.realm = realm;
    }

    public RealmEntity getEntity() {
        return this.realm;
    }

    public String getId() {
        return this.realm.getId();
    }

    public String getName() {
        return this.realm.getName();
    }

    public void setName(String name) {
        this.realm.setName(name);
        this.em.flush();
    }

    public boolean isEnabled() {
        return this.realm.isEnabled();
    }

    public void setEnabled(boolean enabled) {
        this.realm.setEnabled(enabled);
        this.em.flush();
    }

    public SslRequired getSslRequired() {
        return this.realm.getSslRequired() != null ? SslRequired.valueOf((String)this.realm.getSslRequired()) : null;
    }

    public void setSslRequired(SslRequired sslRequired) {
        this.realm.setSslRequired(sslRequired.name());
        this.em.flush();
    }

    public boolean isPasswordCredentialGrantAllowed() {
        return this.realm.isPasswordCredentialGrantAllowed();
    }

    public void setPasswordCredentialGrantAllowed(boolean passwordCredentialGrantAllowed) {
        this.realm.setPasswordCredentialGrantAllowed(passwordCredentialGrantAllowed);
        this.em.flush();
    }

    public boolean isRegistrationAllowed() {
        return this.realm.isRegistrationAllowed();
    }

    public void setRegistrationAllowed(boolean registrationAllowed) {
        this.realm.setRegistrationAllowed(registrationAllowed);
        this.em.flush();
    }

    public boolean isRememberMe() {
        return this.realm.isRememberMe();
    }

    public void setRememberMe(boolean rememberMe) {
        this.realm.setRememberMe(rememberMe);
        this.em.flush();
    }

    public void setAttribute(String name, String value) {
        for (RealmAttributeEntity attr : this.realm.getAttributes()) {
            if (!attr.getName().equals(name)) continue;
            attr.setValue(value);
            return;
        }
        RealmAttributeEntity attr = new RealmAttributeEntity();
        attr.setName(name);
        attr.setValue(value);
        attr.setRealm(this.realm);
        this.em.persist((Object)attr);
        this.realm.getAttributes().add(attr);
    }

    public void setAttribute(String name, Boolean value) {
        this.setAttribute(name, value.toString());
    }

    public void setAttribute(String name, Integer value) {
        this.setAttribute(name, value.toString());
    }

    public void setAttribute(String name, Long value) {
        this.setAttribute(name, value.toString());
    }

    public void removeAttribute(String name) {
        Iterator<RealmAttributeEntity> it = this.realm.getAttributes().iterator();
        while (it.hasNext()) {
            RealmAttributeEntity attr = it.next();
            if (!attr.getName().equals(name)) continue;
            it.remove();
            this.em.remove((Object)attr);
        }
    }

    public String getAttribute(String name) {
        for (RealmAttributeEntity attr : this.realm.getAttributes()) {
            if (!attr.getName().equals(name)) continue;
            return attr.getValue();
        }
        return null;
    }

    public Integer getAttribute(String name, Integer defaultValue) {
        String v = this.getAttribute(name);
        return v != null ? Integer.parseInt(v) : defaultValue;
    }

    public Long getAttribute(String name, Long defaultValue) {
        String v = this.getAttribute(name);
        return v != null ? Long.parseLong(v) : defaultValue;
    }

    public Boolean getAttribute(String name, Boolean defaultValue) {
        String v = this.getAttribute(name);
        return v != null ? Boolean.parseBoolean(v) : defaultValue;
    }

    public Map<String, String> getAttributes() {
        HashMap<String, String> result = new HashMap<String, String>();
        for (RealmAttributeEntity attr : this.realm.getAttributes()) {
            result.put(attr.getName(), attr.getValue());
        }
        return result;
    }

    public boolean isBruteForceProtected() {
        return this.getAttribute("bruteForceProtected", false);
    }

    public void setBruteForceProtected(boolean value) {
        this.setAttribute("bruteForceProtected", value);
    }

    public int getMaxFailureWaitSeconds() {
        return this.getAttribute("maxFailureWaitSeconds", 0);
    }

    public void setMaxFailureWaitSeconds(int val) {
        this.setAttribute("maxFailureWaitSeconds", val);
    }

    public int getWaitIncrementSeconds() {
        return this.getAttribute("waitIncrementSeconds", 0);
    }

    public void setWaitIncrementSeconds(int val) {
        this.setAttribute("waitIncrementSeconds", val);
    }

    public long getQuickLoginCheckMilliSeconds() {
        return this.getAttribute("quickLoginCheckMilliSeconds", 0L);
    }

    public void setQuickLoginCheckMilliSeconds(long val) {
        this.setAttribute("quickLoginCheckMilliSeconds", val);
    }

    public int getMinimumQuickLoginWaitSeconds() {
        return this.getAttribute("minimumQuickLoginWaitSeconds", 0);
    }

    public void setMinimumQuickLoginWaitSeconds(int val) {
        this.setAttribute("minimumQuickLoginWaitSeconds", val);
    }

    public int getMaxDeltaTimeSeconds() {
        return this.getAttribute("maxDeltaTimeSeconds", 0);
    }

    public void setMaxDeltaTimeSeconds(int val) {
        this.setAttribute("maxDeltaTimeSeconds", val);
    }

    public int getFailureFactor() {
        return this.getAttribute("failureFactor", 0);
    }

    public void setFailureFactor(int failureFactor) {
        this.setAttribute("failureFactor", failureFactor);
    }

    public boolean isVerifyEmail() {
        return this.realm.isVerifyEmail();
    }

    public void setVerifyEmail(boolean verifyEmail) {
        this.realm.setVerifyEmail(verifyEmail);
        this.em.flush();
    }

    public boolean isResetPasswordAllowed() {
        return this.realm.isResetPasswordAllowed();
    }

    public void setResetPasswordAllowed(boolean resetPasswordAllowed) {
        this.realm.setResetPasswordAllowed(resetPasswordAllowed);
        this.em.flush();
    }

    public int getNotBefore() {
        return this.realm.getNotBefore();
    }

    public void setNotBefore(int notBefore) {
        this.realm.setNotBefore(notBefore);
    }

    public int getAccessTokenLifespan() {
        return this.realm.getAccessTokenLifespan();
    }

    public void setAccessTokenLifespan(int tokenLifespan) {
        this.realm.setAccessTokenLifespan(tokenLifespan);
        this.em.flush();
    }

    public int getSsoSessionIdleTimeout() {
        return this.realm.getSsoSessionIdleTimeout();
    }

    public void setSsoSessionIdleTimeout(int seconds) {
        this.realm.setSsoSessionIdleTimeout(seconds);
    }

    public int getSsoSessionMaxLifespan() {
        return this.realm.getSsoSessionMaxLifespan();
    }

    public void setSsoSessionMaxLifespan(int seconds) {
        this.realm.setSsoSessionMaxLifespan(seconds);
    }

    public int getAccessCodeLifespan() {
        return this.realm.getAccessCodeLifespan();
    }

    public void setAccessCodeLifespan(int accessCodeLifespan) {
        this.realm.setAccessCodeLifespan(accessCodeLifespan);
        this.em.flush();
    }

    public int getAccessCodeLifespanUserAction() {
        return this.realm.getAccessCodeLifespanUserAction();
    }

    public void setAccessCodeLifespanUserAction(int accessCodeLifespanUserAction) {
        this.realm.setAccessCodeLifespanUserAction(accessCodeLifespanUserAction);
        this.em.flush();
    }

    public String getPublicKeyPem() {
        return this.realm.getPublicKeyPem();
    }

    public void setPublicKeyPem(String publicKeyPem) {
        this.realm.setPublicKeyPem(publicKeyPem);
        this.em.flush();
    }

    public X509Certificate getCertificate() {
        if (this.certificate != null) {
            return this.certificate;
        }
        this.certificate = KeycloakModelUtils.getCertificate((String)this.getCertificatePem());
        return this.certificate;
    }

    public void setCertificate(X509Certificate certificate) {
        this.certificate = certificate;
        String certificatePem = KeycloakModelUtils.getPemFromCertificate((X509Certificate)certificate);
        this.setCertificatePem(certificatePem);
    }

    public String getCertificatePem() {
        return this.realm.getCertificatePem();
    }

    public void setCertificatePem(String certificate) {
        this.realm.setCertificatePem(certificate);
    }

    public String getPrivateKeyPem() {
        return this.realm.getPrivateKeyPem();
    }

    public void setPrivateKeyPem(String privateKeyPem) {
        this.realm.setPrivateKeyPem(privateKeyPem);
        this.em.flush();
    }

    public PublicKey getPublicKey() {
        if (this.publicKey != null) {
            return this.publicKey;
        }
        this.publicKey = KeycloakModelUtils.getPublicKey((String)this.getPublicKeyPem());
        return this.publicKey;
    }

    public void setPublicKey(PublicKey publicKey) {
        this.publicKey = publicKey;
        String publicKeyPem = KeycloakModelUtils.getPemFromKey((Key)publicKey);
        this.setPublicKeyPem(publicKeyPem);
    }

    public PrivateKey getPrivateKey() {
        if (this.privateKey != null) {
            return this.privateKey;
        }
        this.privateKey = KeycloakModelUtils.getPrivateKey((String)this.getPrivateKeyPem());
        return this.privateKey;
    }

    public void setPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
        String privateKeyPem = KeycloakModelUtils.getPemFromKey((Key)privateKey);
        this.setPrivateKeyPem(privateKeyPem);
    }

    public String getCodeSecret() {
        return this.realm.getCodeSecret();
    }

    public Key getCodeSecretKey() {
        if (this.codeSecretKey == null) {
            this.codeSecretKey = KeycloakModelUtils.getSecretKey((String)this.getCodeSecret());
        }
        return this.codeSecretKey;
    }

    public void setCodeSecret(String codeSecret) {
        this.realm.setCodeSecret(codeSecret);
    }

    protected RequiredCredentialModel initRequiredCredentialModel(String type) {
        RequiredCredentialModel model = (RequiredCredentialModel)RequiredCredentialModel.BUILT_IN.get(type);
        if (model == null) {
            throw new RuntimeException("Unknown credential type " + type);
        }
        return model;
    }

    public void addRequiredCredential(String type) {
        RequiredCredentialModel model = this.initRequiredCredentialModel(type);
        this.addRequiredCredential(model);
        this.em.flush();
    }

    public void addRequiredCredential(RequiredCredentialModel model) {
        RequiredCredentialEntity entity = new RequiredCredentialEntity();
        entity.setRealm(this.realm);
        entity.setInput(model.isInput());
        entity.setSecret(model.isSecret());
        entity.setType(model.getType());
        entity.setFormLabel(model.getFormLabel());
        this.em.persist((Object)entity);
        this.realm.getRequiredCredentials().add(entity);
        this.em.flush();
    }

    public void updateRequiredCredentials(Set<String> creds) {
        Collection<RequiredCredentialEntity> relationships = this.realm.getRequiredCredentials();
        if (relationships == null) {
            relationships = new ArrayList<RequiredCredentialEntity>();
        }
        HashSet<String> already = new HashSet<String>();
        ArrayList<RequiredCredentialEntity> remove = new ArrayList<RequiredCredentialEntity>();
        for (RequiredCredentialEntity rel : relationships) {
            if (!creds.contains(rel.getType())) {
                remove.add(rel);
                continue;
            }
            already.add(rel.getType());
        }
        for (RequiredCredentialEntity entity : remove) {
            relationships.remove(entity);
            this.em.remove((Object)entity);
        }
        for (String cred : creds) {
            if (already.contains(cred)) continue;
            this.addRequiredCredential(cred);
        }
        this.em.flush();
    }

    public List<RequiredCredentialModel> getRequiredCredentials() {
        ArrayList<RequiredCredentialModel> requiredCredentialModels = new ArrayList<RequiredCredentialModel>();
        Collection<RequiredCredentialEntity> entities = this.realm.getRequiredCredentials();
        if (entities == null) {
            return requiredCredentialModels;
        }
        for (RequiredCredentialEntity entity : entities) {
            RequiredCredentialModel model = new RequiredCredentialModel();
            model.setFormLabel(entity.getFormLabel());
            model.setType(entity.getType());
            model.setSecret(entity.isSecret());
            model.setInput(entity.isInput());
            requiredCredentialModels.add(model);
        }
        return requiredCredentialModels;
    }

    public List<String> getDefaultRoles() {
        Collection<RoleEntity> entities = this.realm.getDefaultRoles();
        ArrayList<String> roles = new ArrayList<String>();
        if (entities == null) {
            return roles;
        }
        for (RoleEntity entity : entities) {
            roles.add(entity.getName());
        }
        return roles;
    }

    public void addDefaultRole(String name) {
        RoleModel role = this.getRole(name);
        if (role == null) {
            role = this.addRole(name);
        }
        Collection<RoleEntity> entities = this.realm.getDefaultRoles();
        for (RoleEntity entity : entities) {
            if (!entity.getId().equals(role.getId())) continue;
            return;
        }
        RoleEntity roleEntity = RoleAdapter.toRoleEntity(role, this.em);
        entities.add(roleEntity);
        this.em.flush();
    }

    public static boolean contains(String str, String[] array) {
        for (String s : array) {
            if (!str.equals(s)) continue;
            return true;
        }
        return false;
    }

    public void updateDefaultRoles(String[] defaultRoles) {
        Collection<RoleEntity> entities = this.realm.getDefaultRoles();
        HashSet<String> already = new HashSet<String>();
        ArrayList<RoleEntity> remove = new ArrayList<RoleEntity>();
        for (RoleEntity rel : entities) {
            if (!RealmAdapter.contains(rel.getName(), defaultRoles)) {
                remove.add(rel);
                continue;
            }
            already.add(rel.getName());
        }
        for (RoleEntity entity : remove) {
            entities.remove(entity);
        }
        this.em.flush();
        for (String roleName : defaultRoles) {
            if (already.contains(roleName)) continue;
            this.addDefaultRole(roleName);
        }
        this.em.flush();
    }

    public ClientModel findClient(String clientId) {
        ApplicationModel model = this.getApplicationByName(clientId);
        if (model != null) {
            return model;
        }
        return this.getOAuthClient(clientId);
    }

    public ClientModel findClientById(String id) {
        ApplicationModel model = this.getApplicationById(id);
        if (model != null) {
            return model;
        }
        return this.getOAuthClientById(id);
    }

    public Map<String, ApplicationModel> getApplicationNameMap() {
        HashMap<String, ApplicationModel> map = new HashMap<String, ApplicationModel>();
        for (ApplicationModel app : this.getApplications()) {
            map.put(app.getName(), app);
        }
        return map;
    }

    public List<ApplicationModel> getApplications() {
        ArrayList<ApplicationModel> list = new ArrayList<ApplicationModel>();
        if (this.realm.getApplications() == null) {
            return list;
        }
        for (ApplicationEntity entity : this.realm.getApplications()) {
            list.add(new ApplicationAdapter(this, this.em, this.session, entity));
        }
        return list;
    }

    public ApplicationModel addApplication(String name) {
        return this.addApplication(KeycloakModelUtils.generateId(), name);
    }

    public ApplicationModel addApplication(String id, String name) {
        ApplicationEntity applicationData = new ApplicationEntity();
        applicationData.setId(id);
        applicationData.setName(name);
        applicationData.setEnabled(true);
        applicationData.setRealm(this.realm);
        this.realm.getApplications().add(applicationData);
        this.em.persist((Object)applicationData);
        this.em.flush();
        ApplicationAdapter resource = new ApplicationAdapter(this, this.em, this.session, applicationData);
        this.em.flush();
        return resource;
    }

    public boolean removeApplication(String id) {
        if (id == null) {
            return false;
        }
        ApplicationModel application = this.getApplicationById(id);
        if (application == null) {
            return false;
        }
        for (RoleModel role : application.getRoles()) {
            application.removeRole(role);
        }
        ApplicationEntity applicationEntity = null;
        Iterator<ApplicationEntity> it = this.realm.getApplications().iterator();
        while (it.hasNext()) {
            ApplicationEntity ae = it.next();
            if (!ae.getId().equals(id)) continue;
            applicationEntity = ae;
            it.remove();
            break;
        }
        for (ApplicationEntity a : this.realm.getApplications()) {
            if (!a.getId().equals(id)) continue;
            applicationEntity = a;
        }
        if (application == null) {
            return false;
        }
        this.em.remove((Object)applicationEntity);
        this.em.createNamedQuery("deleteScopeMappingByClient").setParameter("client", (Object)applicationEntity).executeUpdate();
        this.em.flush();
        return true;
    }

    public ApplicationModel getApplicationById(String id) {
        return this.session.realms().getApplicationById(id, (RealmModel)this);
    }

    public ApplicationModel getApplicationByName(String name) {
        return this.getApplicationNameMap().get(name);
    }

    public boolean isSocial() {
        return this.realm.isSocial();
    }

    public void setSocial(boolean social) {
        this.realm.setSocial(social);
        this.em.flush();
    }

    public boolean isUpdateProfileOnInitialSocialLogin() {
        return this.realm.isUpdateProfileOnInitialSocialLogin();
    }

    public void setUpdateProfileOnInitialSocialLogin(boolean updateProfileOnInitialSocialLogin) {
        this.realm.setUpdateProfileOnInitialSocialLogin(updateProfileOnInitialSocialLogin);
        this.em.flush();
    }

    public OAuthClientModel addOAuthClient(String name) {
        return this.addOAuthClient(KeycloakModelUtils.generateId(), name);
    }

    public OAuthClientModel addOAuthClient(String id, String name) {
        OAuthClientEntity data = new OAuthClientEntity();
        data.setId(id);
        data.setEnabled(true);
        data.setName(name);
        data.setRealm(this.realm);
        this.em.persist((Object)data);
        this.em.flush();
        return new OAuthClientAdapter((RealmModel)this, data, this.em);
    }

    public boolean removeOAuthClient(String id) {
        OAuthClientModel oauth = this.getOAuthClientById(id);
        if (oauth == null) {
            return false;
        }
        OAuthClientEntity client = (OAuthClientEntity)this.em.getReference(OAuthClientEntity.class, (Object)oauth.getId());
        this.em.createNamedQuery("deleteScopeMappingByClient").setParameter("client", (Object)client).executeUpdate();
        this.em.remove((Object)client);
        return true;
    }

    public OAuthClientModel getOAuthClient(String name) {
        TypedQuery query = this.em.createNamedQuery("findOAuthClientByName", OAuthClientEntity.class);
        query.setParameter("name", (Object)name);
        query.setParameter("realm", (Object)this.realm);
        List entities = query.getResultList();
        if (entities.size() == 0) {
            return null;
        }
        return new OAuthClientAdapter((RealmModel)this, (OAuthClientEntity)entities.get(0), this.em);
    }

    public OAuthClientModel getOAuthClientById(String id) {
        return this.session.realms().getOAuthClientById(id, (RealmModel)this);
    }

    public List<OAuthClientModel> getOAuthClients() {
        TypedQuery query = this.em.createNamedQuery("findOAuthClientByRealm", OAuthClientEntity.class);
        query.setParameter("realm", (Object)this.realm);
        List entities = query.getResultList();
        ArrayList<OAuthClientModel> list = new ArrayList<OAuthClientModel>();
        for (OAuthClientEntity entity : entities) {
            list.add(new OAuthClientAdapter((RealmModel)this, entity, this.em));
        }
        return list;
    }

    public Map<String, String> getBrowserSecurityHeaders() {
        Map<String, String> attributes = this.getAttributes();
        HashMap<String, String> headers = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            if (!entry.getKey().startsWith(BROWSER_HEADER_PREFIX)) continue;
            headers.put(entry.getKey().substring(BROWSER_HEADER_PREFIX.length()), entry.getValue());
        }
        return headers;
    }

    public void setBrowserSecurityHeaders(Map<String, String> headers) {
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            this.setAttribute(BROWSER_HEADER_PREFIX + entry.getKey(), entry.getValue());
        }
    }

    public Map<String, String> getSmtpConfig() {
        return this.realm.getSmtpConfig();
    }

    public void setSmtpConfig(Map<String, String> smtpConfig) {
        this.realm.setSmtpConfig(smtpConfig);
        this.em.flush();
    }

    public Map<String, String> getSocialConfig() {
        return this.realm.getSocialConfig();
    }

    public void setSocialConfig(Map<String, String> socialConfig) {
        this.realm.setSocialConfig(socialConfig);
        this.em.flush();
    }

    public List<UserFederationProviderModel> getUserFederationProviders() {
        List<UserFederationProviderEntity> entities = this.realm.getUserFederationProviders();
        ArrayList<UserFederationProviderEntity> copy = new ArrayList<UserFederationProviderEntity>();
        for (UserFederationProviderEntity entity : entities) {
            copy.add(entity);
        }
        Collections.sort(copy, new Comparator<UserFederationProviderEntity>(){

            @Override
            public int compare(UserFederationProviderEntity o1, UserFederationProviderEntity o2) {
                return o1.getPriority() - o2.getPriority();
            }
        });
        ArrayList<UserFederationProviderModel> result = new ArrayList<UserFederationProviderModel>();
        for (UserFederationProviderEntity entity : copy) {
            result.add(new UserFederationProviderModel(entity.getId(), entity.getProviderName(), entity.getConfig(), entity.getPriority(), entity.getDisplayName(), entity.getFullSyncPeriod(), entity.getChangedSyncPeriod(), entity.getLastSync()));
        }
        return result;
    }

    public UserFederationProviderModel addUserFederationProvider(String providerName, Map<String, String> config, int priority, String displayName, int fullSyncPeriod, int changedSyncPeriod, int lastSync) {
        String id = KeycloakModelUtils.generateId();
        UserFederationProviderEntity entity = new UserFederationProviderEntity();
        entity.setId(id);
        entity.setRealm(this.realm);
        entity.setProviderName(providerName);
        entity.setConfig(config);
        entity.setPriority(priority);
        if (displayName == null) {
            displayName = id;
        }
        entity.setDisplayName(displayName);
        entity.setFullSyncPeriod(fullSyncPeriod);
        entity.setChangedSyncPeriod(changedSyncPeriod);
        entity.setLastSync(lastSync);
        this.em.persist((Object)entity);
        this.realm.getUserFederationProviders().add(entity);
        this.em.flush();
        return new UserFederationProviderModel(entity.getId(), providerName, config, priority, displayName, fullSyncPeriod, changedSyncPeriod, lastSync);
    }

    public void removeUserFederationProvider(UserFederationProviderModel provider) {
        Iterator<UserFederationProviderEntity> it = this.realm.getUserFederationProviders().iterator();
        while (it.hasNext()) {
            UserFederationProviderEntity entity = it.next();
            if (!entity.getId().equals(provider.getId())) continue;
            this.session.users().preRemove((RealmModel)this, provider);
            it.remove();
            this.em.remove((Object)entity);
            return;
        }
    }

    public void updateUserFederationProvider(UserFederationProviderModel model) {
        for (UserFederationProviderEntity entity : this.realm.getUserFederationProviders()) {
            if (!entity.getId().equals(model.getId())) continue;
            String displayName = model.getDisplayName();
            if (displayName != null) {
                entity.setDisplayName(model.getDisplayName());
            }
            entity.setConfig(model.getConfig());
            entity.setPriority(model.getPriority());
            entity.setProviderName(model.getProviderName());
            entity.setPriority(model.getPriority());
            entity.setFullSyncPeriod(model.getFullSyncPeriod());
            entity.setChangedSyncPeriod(model.getChangedSyncPeriod());
            entity.setLastSync(model.getLastSync());
            break;
        }
    }

    public void setUserFederationProviders(List<UserFederationProviderModel> providers) {
        String displayName;
        Iterator<UserFederationProviderEntity> it = this.realm.getUserFederationProviders().iterator();
        while (it.hasNext()) {
            UserFederationProviderEntity entity = it.next();
            boolean found = false;
            for (UserFederationProviderModel model : providers) {
                if (!entity.getId().equals(model.getId())) continue;
                entity.setConfig(model.getConfig());
                entity.setPriority(model.getPriority());
                entity.setProviderName(model.getProviderName());
                entity.setPriority(model.getPriority());
                displayName = model.getDisplayName();
                if (displayName != null) {
                    entity.setDisplayName(model.getDisplayName());
                }
                entity.setFullSyncPeriod(model.getFullSyncPeriod());
                entity.setChangedSyncPeriod(model.getChangedSyncPeriod());
                entity.setLastSync(model.getLastSync());
                found = true;
                break;
            }
            if (found) continue;
            this.session.users().preRemove((RealmModel)this, new UserFederationProviderModel(entity.getId(), entity.getProviderName(), entity.getConfig(), entity.getPriority(), entity.getDisplayName(), entity.getFullSyncPeriod(), entity.getChangedSyncPeriod(), entity.getLastSync()));
            it.remove();
            this.em.remove((Object)entity);
        }
        LinkedList<UserFederationProviderModel> add = new LinkedList<UserFederationProviderModel>();
        for (UserFederationProviderModel model : providers) {
            boolean found = false;
            for (UserFederationProviderEntity entity : this.realm.getUserFederationProviders()) {
                if (!entity.getId().equals(model.getId())) continue;
                found = true;
                break;
            }
            if (found) continue;
            add.add(model);
        }
        for (UserFederationProviderModel model : add) {
            UserFederationProviderEntity entity = new UserFederationProviderEntity();
            if (model.getId() != null) {
                entity.setId(model.getId());
            } else {
                entity.setId(KeycloakModelUtils.generateId());
            }
            entity.setConfig(model.getConfig());
            entity.setPriority(model.getPriority());
            entity.setProviderName(model.getProviderName());
            entity.setPriority(model.getPriority());
            displayName = model.getDisplayName();
            if (displayName == null) {
                displayName = entity.getId();
            }
            entity.setDisplayName(displayName);
            entity.setFullSyncPeriod(model.getFullSyncPeriod());
            entity.setChangedSyncPeriod(model.getChangedSyncPeriod());
            entity.setLastSync(model.getLastSync());
            this.em.persist((Object)entity);
            this.realm.getUserFederationProviders().add(entity);
        }
    }

    public RoleModel getRole(String name) {
        TypedQuery query = this.em.createNamedQuery("getRealmRoleByName", RoleEntity.class);
        query.setParameter("name", (Object)name);
        query.setParameter("realm", (Object)this.realm);
        List roles = query.getResultList();
        if (roles.size() == 0) {
            return null;
        }
        return new RoleAdapter(this, this.em, (RoleEntity)roles.get(0));
    }

    public RoleModel addRole(String name) {
        return this.addRole(KeycloakModelUtils.generateId(), name);
    }

    public RoleModel addRole(String id, String name) {
        RoleEntity entity = new RoleEntity();
        entity.setId(id);
        entity.setName(name);
        entity.setRealm(this.realm);
        entity.setRealmId(this.realm.getId());
        this.realm.getRoles().add(entity);
        this.em.persist((Object)entity);
        this.em.flush();
        return new RoleAdapter(this, this.em, entity);
    }

    public boolean removeRole(RoleModel role) {
        if (role == null) {
            return false;
        }
        if (!role.getContainer().equals(this)) {
            return false;
        }
        this.session.users().preRemove((RealmModel)this, role);
        RoleEntity roleEntity = RoleAdapter.toRoleEntity(role, this.em);
        this.realm.getRoles().remove(role);
        this.realm.getDefaultRoles().remove(role);
        this.em.createNativeQuery("delete from COMPOSITE_ROLE where CHILD_ROLE = :role").setParameter("role", (Object)roleEntity).executeUpdate();
        this.em.createNamedQuery("deleteScopeMappingByRole").setParameter("role", (Object)roleEntity).executeUpdate();
        this.em.remove((Object)roleEntity);
        return true;
    }

    public Set<RoleModel> getRoles() {
        HashSet<RoleModel> list = new HashSet<RoleModel>();
        Collection<RoleEntity> roles = this.realm.getRoles();
        if (roles == null) {
            return list;
        }
        for (RoleEntity entity : roles) {
            list.add(new RoleAdapter(this, this.em, entity));
        }
        return list;
    }

    public RoleModel getRoleById(String id) {
        return this.session.realms().getRoleById(id, (RealmModel)this);
    }

    public boolean removeRoleById(String id) {
        RoleModel role = this.getRoleById(id);
        if (role == null) {
            return false;
        }
        return role.getContainer().removeRole(role);
    }

    public PasswordPolicy getPasswordPolicy() {
        if (this.passwordPolicy == null) {
            this.passwordPolicy = new PasswordPolicy(this.realm.getPasswordPolicy());
        }
        return this.passwordPolicy;
    }

    public void setPasswordPolicy(PasswordPolicy policy) {
        this.passwordPolicy = policy;
        this.realm.setPasswordPolicy(policy.toString());
        this.em.flush();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof RealmModel)) {
            return false;
        }
        RealmModel that = (RealmModel)o;
        return that.getId().equals(this.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public String getLoginTheme() {
        return this.realm.getLoginTheme();
    }

    public void setLoginTheme(String name) {
        this.realm.setLoginTheme(name);
        this.em.flush();
    }

    public String getAccountTheme() {
        return this.realm.getAccountTheme();
    }

    public void setAccountTheme(String name) {
        this.realm.setAccountTheme(name);
        this.em.flush();
    }

    public String getAdminTheme() {
        return this.realm.getAdminTheme();
    }

    public void setAdminTheme(String name) {
        this.realm.setAdminTheme(name);
        this.em.flush();
    }

    public String getEmailTheme() {
        return this.realm.getEmailTheme();
    }

    public void setEmailTheme(String name) {
        this.realm.setEmailTheme(name);
        this.em.flush();
    }

    public boolean isEventsEnabled() {
        return this.realm.isEventsEnabled();
    }

    public void setEventsEnabled(boolean enabled) {
        this.realm.setEventsEnabled(enabled);
        this.em.flush();
    }

    public long getEventsExpiration() {
        return this.realm.getEventsExpiration();
    }

    public void setEventsExpiration(long expiration) {
        this.realm.setEventsExpiration(expiration);
        this.em.flush();
    }

    public Set<String> getEventsListeners() {
        return this.realm.getEventsListeners();
    }

    public void setEventsListeners(Set<String> listeners) {
        this.realm.setEventsListeners(listeners);
        this.em.flush();
    }

    public ApplicationModel getMasterAdminApp() {
        return new ApplicationAdapter(this, this.em, this.session, this.realm.getMasterAdminApp());
    }

    public void setMasterAdminApp(ApplicationModel app) {
        ApplicationEntity appEntity = app != null ? (ApplicationEntity)this.em.getReference(ApplicationEntity.class, (Object)app.getId()) : null;
        this.realm.setMasterAdminApp(appEntity);
        this.em.flush();
    }
}

