/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.undertow;

import io.undertow.security.api.SecurityContext;
import io.undertow.security.idm.Account;
import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.handlers.ServletRequestContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.jboss.logging.Logger;
import org.keycloak.KeycloakSecurityContext;
import org.keycloak.adapters.AdapterTokenStore;
import org.keycloak.adapters.KeycloakAccount;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.RefreshableKeycloakSecurityContext;
import org.keycloak.adapters.RequestAuthenticator;
import org.keycloak.adapters.undertow.AbstractUndertowRequestAuthenticator;
import org.keycloak.adapters.undertow.KeycloakUndertowAccount;
import org.keycloak.adapters.undertow.UndertowUserSessionManagement;

public class ServletSessionTokenStore
implements AdapterTokenStore {
    protected static Logger log = Logger.getLogger(ServletSessionTokenStore.class);
    private final HttpServerExchange exchange;
    private final KeycloakDeployment deployment;
    private final UndertowUserSessionManagement sessionManagement;
    private final SecurityContext securityContext;

    public ServletSessionTokenStore(HttpServerExchange exchange, KeycloakDeployment deployment, UndertowUserSessionManagement sessionManagement, SecurityContext securityContext) {
        this.exchange = exchange;
        this.deployment = deployment;
        this.sessionManagement = sessionManagement;
        this.securityContext = securityContext;
    }

    public void checkCurrentToken() {
    }

    public boolean isCached(RequestAuthenticator authenticator) {
        HttpSession session = this.getSession(false);
        if (session == null) {
            log.debug((Object)"session was null, returning null");
            return false;
        }
        KeycloakUndertowAccount account = (KeycloakUndertowAccount)session.getAttribute(KeycloakUndertowAccount.class.getName());
        if (account == null) {
            log.debug((Object)"Account was not in session, returning null");
            return false;
        }
        if (!this.deployment.getRealm().equals(account.getKeycloakSecurityContext().getRealm())) {
            log.debug((Object)"Account in session belongs to a different realm than for this request.");
            return false;
        }
        account.setCurrentRequestInfo(this.deployment, this);
        if (account.checkActive()) {
            log.debug((Object)"Cached account found");
            this.securityContext.authenticationComplete((Account)account, "KEYCLOAK", false);
            ((AbstractUndertowRequestAuthenticator)authenticator).propagateKeycloakContext(account);
            return true;
        }
        log.debug((Object)"Refresh failed. Account was not active. Returning null and invalidating Http session");
        session.setAttribute(KeycloakUndertowAccount.class.getName(), null);
        session.invalidate();
        return false;
    }

    public void saveAccountInfo(KeycloakAccount account) {
        ServletRequestContext servletRequestContext = (ServletRequestContext)this.exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        HttpSession session = this.getSession(true);
        session.setAttribute(KeycloakUndertowAccount.class.getName(), (Object)account);
        this.sessionManagement.login(servletRequestContext.getDeployment().getSessionManager());
    }

    public void logout() {
        ServletRequestContext servletRequestContext = (ServletRequestContext)this.exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        HttpServletRequest req = (HttpServletRequest)servletRequestContext.getServletRequest();
        req.removeAttribute(KeycloakUndertowAccount.class.getName());
        req.removeAttribute(KeycloakSecurityContext.class.getName());
        HttpSession session = req.getSession(false);
        if (session == null) {
            return;
        }
        try {
            KeycloakUndertowAccount account = (KeycloakUndertowAccount)session.getAttribute(KeycloakUndertowAccount.class.getName());
            if (account == null) {
                return;
            }
            session.removeAttribute(KeycloakSecurityContext.class.getName());
            session.removeAttribute(KeycloakUndertowAccount.class.getName());
        }
        catch (IllegalStateException ise) {
            log.debugf("Session %s logged-out already", (Object)session.getId());
        }
    }

    public void refreshCallback(RefreshableKeycloakSecurityContext securityContext) {
    }

    protected HttpSession getSession(boolean create) {
        ServletRequestContext servletRequestContext = (ServletRequestContext)this.exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        HttpServletRequest req = (HttpServletRequest)servletRequestContext.getServletRequest();
        return req.getSession(create);
    }
}

