/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.mongo.updater.updates;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import java.util.Arrays;
import org.jboss.logging.Logger;

public abstract class Update {
    protected DB db;
    protected Logger log;

    public abstract String getId();

    public abstract void update() throws ClassNotFoundException;

    protected DBCollection createCollection(String name) {
        if (this.db.collectionExists(name)) {
            throw new RuntimeException("Failed to create collection {0}: collection already exists");
        }
        DBCollection col = this.db.getCollection(name);
        this.log.debugv("Created collection {0}", (Object)name);
        return col;
    }

    protected void ensureIndex(String name, String field, boolean unique, boolean sparse) {
        this.ensureIndex(name, new String[]{field}, unique, sparse);
    }

    protected void ensureIndex(String name, String[] fields, boolean unique, boolean sparse) {
        DBCollection col = this.db.getCollection(name);
        BasicDBObject o = new BasicDBObject();
        for (String f : fields) {
            o.append(f, (Object)1);
        }
        col.ensureIndex((DBObject)o, (DBObject)new BasicDBObject("unique", (Object)unique).append("sparse", (Object)sparse));
        this.log.debugv("Created index {0}, fields={1}, unique={2}, sparse={3}", new Object[]{name, Arrays.toString(fields), unique, sparse});
    }

    protected void deleteEntries(String collection) {
        this.db.getCollection(collection).remove((DBObject)new BasicDBObject());
        this.log.debugv("Deleted entries from {0}", (Object)collection);
    }

    public void setLog(Logger log) {
        this.log = log;
    }

    public void setDb(DB db) {
        this.db = db;
    }
}

