/*
 * Decompiled with CFR 0.152.
 */
package liquibase.diff.output.changelog.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import liquibase.change.AddColumnConfig;
import liquibase.change.Change;
import liquibase.change.core.CreateIndexChange;
import liquibase.change.core.DropIndexChange;
import liquibase.database.Database;
import liquibase.diff.Difference;
import liquibase.diff.ObjectDifferences;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.changelog.ChangeGeneratorChain;
import liquibase.diff.output.changelog.ChangedObjectChangeGenerator;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Index;
import liquibase.structure.core.UniqueConstraint;
import liquibase.util.StringUtils;

public class ChangedIndexChangeGenerator
implements ChangedObjectChangeGenerator {
    @Override
    public int getPriority(Class<? extends DatabaseObject> objectType, Database database) {
        if (Index.class.isAssignableFrom(objectType)) {
            return 1;
        }
        return -1;
    }

    @Override
    public Class<? extends DatabaseObject>[] runBeforeTypes() {
        return null;
    }

    @Override
    public Class<? extends DatabaseObject>[] runAfterTypes() {
        return null;
    }

    @Override
    public Change[] fixChanged(DatabaseObject changedObject, ObjectDifferences differences, DiffOutputControl control, Database referenceDatabase, Database comparisonDatabase, ChangeGeneratorChain chain) {
        Difference columnNames;
        Index index = (Index)changedObject;
        DropIndexChange dropIndexChange = new DropIndexChange();
        dropIndexChange.setTableName(index.getTable().getName());
        dropIndexChange.setIndexName(index.getName());
        CreateIndexChange addIndexChange = new CreateIndexChange();
        addIndexChange.setTableName(index.getTable().getName());
        ArrayList<AddColumnConfig> columns = new ArrayList<AddColumnConfig>();
        for (String col : index.getColumns()) {
            columns.add((AddColumnConfig)new AddColumnConfig().setName(col));
        }
        addIndexChange.setColumns((List<AddColumnConfig>)columns);
        addIndexChange.setIndexName(index.getName());
        if (control.getIncludeCatalog()) {
            dropIndexChange.setCatalogName(index.getSchema().getCatalogName());
            addIndexChange.setCatalogName(index.getSchema().getCatalogName());
        }
        if (control.getIncludeSchema()) {
            dropIndexChange.setSchemaName(index.getSchema().getName());
            addIndexChange.setSchemaName(index.getSchema().getName());
        }
        if ((columnNames = differences.getDifference("columnNames")) != null) {
            String referenceColumns = StringUtils.join((Collection)columnNames.getReferenceValue(), ",");
            String comparedColumns = StringUtils.join((Collection)columnNames.getComparedValue(), ",");
            control.setAlreadyHandledChanged(new Index().setTable(index.getTable()).setColumns(referenceColumns));
            if (!referenceColumns.equalsIgnoreCase(comparedColumns)) {
                control.setAlreadyHandledChanged(new Index().setTable(index.getTable()).setColumns(comparedColumns));
            }
            if (index.isUnique() != null && index.isUnique().booleanValue()) {
                control.setAlreadyHandledChanged(new UniqueConstraint().setTable(index.getTable()).setColumns(referenceColumns));
                if (!referenceColumns.equalsIgnoreCase(comparedColumns)) {
                    control.setAlreadyHandledChanged(new UniqueConstraint().setTable(index.getTable()).setColumns(comparedColumns));
                }
            }
        }
        return new Change[]{dropIndexChange, addIndexChange};
    }
}

