/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.jpa;

import java.util.LinkedList;
import java.util.List;
import javax.persistence.EntityManager;
import org.keycloak.models.ClientSessionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.sessions.jpa.ClientSessionAdapter;
import org.keycloak.models.sessions.jpa.entities.ClientSessionEntity;
import org.keycloak.models.sessions.jpa.entities.UserSessionEntity;

public class UserSessionAdapter
implements UserSessionModel {
    private KeycloakSession session;
    private RealmModel realm;
    private UserSessionEntity entity;
    private EntityManager em;

    public UserSessionAdapter(KeycloakSession session, EntityManager em, RealmModel realm, UserSessionEntity entity) {
        this.session = session;
        this.realm = realm;
        this.entity = entity;
        this.em = em;
    }

    public UserSessionEntity getEntity() {
        return this.entity;
    }

    public String getId() {
        return this.entity.getId();
    }

    public UserModel getUser() {
        return this.session.users().getUserById(this.entity.getUserId(), this.realm);
    }

    public String getLoginUsername() {
        return this.entity.getLoginUsername();
    }

    public String getIpAddress() {
        return this.entity.getIpAddress();
    }

    public String getAuthMethod() {
        return this.entity.getAuthMethod();
    }

    public boolean isRememberMe() {
        return this.entity.isRememberMe();
    }

    public int getStarted() {
        return this.entity.getStarted();
    }

    public int getLastSessionRefresh() {
        return this.entity.getLastSessionRefresh();
    }

    public void setLastSessionRefresh(int seconds) {
        this.entity.setLastSessionRefresh(seconds);
    }

    public List<ClientSessionModel> getClientSessions() {
        LinkedList<ClientSessionModel> clientSessions = new LinkedList<ClientSessionModel>();
        for (ClientSessionEntity e : this.entity.getClientSessions()) {
            clientSessions.add(new ClientSessionAdapter(this.session, this.em, this.realm, e));
        }
        return clientSessions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof UserSessionModel)) {
            return false;
        }
        UserSessionModel that = (UserSessionModel)o;
        return that.getId().equals(this.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }
}

