/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.jboss.resteasy.specimpl.MultivaluedMapImpl;
import org.jboss.resteasy.spi.HttpRequest;
import org.keycloak.ClientConnection;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientSessionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.SocialLinkModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.protocol.oidc.TokenManager;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.managers.ClientSessionCode;
import org.keycloak.services.managers.EventsManager;
import org.keycloak.services.managers.RealmManager;
import org.keycloak.services.resources.flows.Flows;
import org.keycloak.services.resources.flows.Urls;
import org.keycloak.social.AuthCallback;
import org.keycloak.social.SocialAccessDeniedException;
import org.keycloak.social.SocialLoader;
import org.keycloak.social.SocialProvider;
import org.keycloak.social.SocialProviderConfig;
import org.keycloak.social.SocialProviderException;
import org.keycloak.social.SocialUser;

@Path(value="/social")
public class SocialResource {
    protected static Logger logger = Logger.getLogger(SocialResource.class);
    @Context
    protected UriInfo uriInfo;
    @Context
    protected HttpHeaders headers;
    @Context
    private HttpRequest request;
    @Context
    protected KeycloakSession session;
    @Context
    protected ClientConnection clientConnection;

    @GET
    @Path(value="callback")
    public Response callback(@QueryParam(value="state") String encodedState) throws URISyntaxException, IOException {
        SocialUser socialUser;
        ClientSessionCode clientCode = null;
        ClientSessionModel clientSession = null;
        try {
            clientCode = ClientSessionCode.parse(encodedState, this.session);
            if (clientCode == null) {
                return Flows.forms(this.session, null, null, this.uriInfo).setError("Unexpected callback").createErrorPage();
            }
            clientSession = clientCode.getClientSession();
            if (!clientCode.isValid(ClientSessionModel.Action.SOCIAL_CALLBACK)) {
                return Flows.forwardToSecurityFailurePage(this.session, clientSession.getRealm(), this.uriInfo, "Invalid code, please login again through your application.");
            }
        }
        catch (Throwable t) {
            logger.error((Object)"Invalid social callback", t);
            return Flows.forms(this.session, null, null, this.uriInfo).setError("Unexpected callback").createErrorPage();
        }
        String providerId = clientSession.getNote("social_provider");
        SocialProvider provider = SocialLoader.load((String)providerId);
        String authMethod = "social@" + provider.getId();
        RealmModel realm = clientSession.getRealm();
        EventBuilder event = new EventsManager(realm, this.session, this.clientConnection).createEventBuilder().event(EventType.LOGIN).client(clientSession.getClient()).detail("redirect_uri", clientSession.getRedirectUri()).detail("auth_method", authMethod);
        if (!realm.isEnabled()) {
            event.error("realm_disabled");
            return Flows.forwardToSecurityFailurePage(this.session, realm, this.uriInfo, "Realm not enabled.");
        }
        String key = (String)realm.getSocialConfig().get(provider.getId() + ".key");
        String secret = (String)realm.getSocialConfig().get(provider.getId() + ".secret");
        String callbackUri = Urls.socialCallback(this.uriInfo.getBaseUri()).toString();
        SocialProviderConfig config = new SocialProviderConfig(key, secret, callbackUri);
        Map<String, String[]> queryParams = this.getQueryParams();
        AuthCallback callback = new AuthCallback(queryParams);
        try {
            socialUser = provider.processCallback(clientSession, config, callback);
        }
        catch (SocialAccessDeniedException e) {
            event.error("rejected_by_user");
            clientSession.setAction(ClientSessionModel.Action.AUTHENTICATE);
            return Flows.forms(this.session, realm, clientSession.getClient(), this.uriInfo).setClientSessionCode(clientCode.getCode()).setWarning("Access denied").createLogin();
        }
        catch (SocialProviderException e) {
            logger.error((Object)"Failed to process social callback", (Throwable)e);
            return Flows.forwardToSecurityFailurePage(this.session, realm, this.uriInfo, "Failed to process social callback");
        }
        event.detail("username", socialUser.getId() + "@" + provider.getId());
        try {
            SocialLinkModel socialLink = new SocialLinkModel(provider.getId(), socialUser.getId(), socialUser.getUsername());
            UserModel user = this.session.users().getUserBySocialLink(socialLink, realm);
            if (clientSession.getUserSession() != null) {
                UserModel authenticatedUser = clientSession.getUserSession().getUser();
                event.event(EventType.SOCIAL_LINK).user(authenticatedUser.getId());
                if (user != null) {
                    event.error("social_id_in_use");
                    return Flows.forwardToSecurityFailurePage(this.session, realm, this.uriInfo, "This social account is already linked to other user");
                }
                if (!authenticatedUser.isEnabled()) {
                    event.error("user_disabled");
                    return Flows.forwardToSecurityFailurePage(this.session, realm, this.uriInfo, "User is disabled");
                }
                if (!authenticatedUser.hasRole(realm.getApplicationByName("account").getRole("manage-account"))) {
                    event.error("not_allowed");
                    return Flows.forwardToSecurityFailurePage(this.session, realm, this.uriInfo, "Insufficient permissions to link social account");
                }
                this.session.users().addSocialLink(realm, authenticatedUser, socialLink);
                logger.debugv("Social provider {0} linked with user {1}", (Object)provider.getId(), (Object)authenticatedUser.getUsername());
                event.success();
                return Response.status((int)302).location(UriBuilder.fromUri((String)clientSession.getRedirectUri()).build(new Object[0])).build();
            }
            if (user == null) {
                user = this.session.users().addUser(realm, KeycloakModelUtils.generateId());
                user.setEnabled(true);
                user.setFirstName(socialUser.getFirstName());
                user.setLastName(socialUser.getLastName());
                user.setEmail(socialUser.getEmail());
                if (realm.isUpdateProfileOnInitialSocialLogin()) {
                    user.addRequiredAction(UserModel.RequiredAction.UPDATE_PROFILE);
                }
                this.session.users().addSocialLink(realm, user, socialLink);
                event.clone().user(user).event(EventType.REGISTER).detail("register_method", "social@" + provider.getId()).detail("email", socialUser.getEmail()).removeDetail("auth_method").success();
            }
            event.user(user);
            if (!user.isEnabled()) {
                event.error("user_disabled");
                return Flows.forwardToSecurityFailurePage(this.session, realm, this.uriInfo, "Your account is not enabled.");
            }
            String username = socialLink.getSocialUserId() + "@" + socialLink.getSocialProvider();
            UserSessionModel userSession = this.session.sessions().createUserSession(realm, user, username, this.clientConnection.getRemoteAddr(), authMethod, false);
            event.session(userSession);
            TokenManager.attachClientSession(userSession, clientSession);
            AuthenticationManager authManager = new AuthenticationManager();
            Response response = AuthenticationManager.nextActionAfterAuthentication(this.session, userSession, clientSession, this.clientConnection, this.request, this.uriInfo, event);
            if (this.session.getTransaction().isActive()) {
                this.session.getTransaction().commit();
            }
            return response;
        }
        catch (ModelDuplicateException e) {
            return Flows.forms(this.session, realm, clientSession.getClient(), this.uriInfo).setClientSessionCode(clientCode.getCode()).setError("socialEmailExists").createLogin();
        }
    }

    @GET
    @Path(value="{realm}/login")
    public Response redirectToProviderAuth(@PathParam(value="realm") String realmName, @QueryParam(value="provider_id") String providerId, @QueryParam(value="code") String code) {
        RealmManager realmManager = new RealmManager(this.session);
        RealmModel realm = realmManager.getRealmByName(realmName);
        EventBuilder event = new EventsManager(realm, this.session, this.clientConnection).createEventBuilder().event(EventType.LOGIN).detail("auth_method", "social@" + providerId);
        SocialProvider provider = SocialLoader.load((String)providerId);
        if (provider == null) {
            event.error("social_provider_not_found");
            return Flows.forms(this.session, realm, null, this.uriInfo).setError("Social provider not found").createErrorPage();
        }
        Checks checks = new Checks();
        if (!checks.check(event, realm, code, ClientSessionModel.Action.AUTHENTICATE)) {
            return checks.response;
        }
        ClientSessionCode clientSessionCode = checks.clientCode;
        try {
            return Flows.social(realm, this.uriInfo, this.clientConnection, provider).redirectToSocialProvider(clientSessionCode);
        }
        catch (Throwable t) {
            logger.error((Object)"Failed to redirect to social auth", t);
            return Flows.forms(this.session, realm, null, this.uriInfo).setError("Failed to redirect to social auth").createErrorPage();
        }
    }

    private Response returnToLogin(RealmModel realm, ClientModel client, Map<String, String> attributes, String error) {
        MultivaluedMapImpl q = new MultivaluedMapImpl();
        for (Map.Entry<String, String> e : attributes.entrySet()) {
            q.add((Object)e.getKey(), (Object)e.getValue());
        }
        return Flows.forms(this.session, realm, client, this.uriInfo).setQueryParams((MultivaluedMap)q).setError(error).createLogin();
    }

    private Map<String, String[]> getQueryParams() {
        HashMap<String, String[]> queryParams = new HashMap<String, String[]>();
        for (Map.Entry e : this.uriInfo.getQueryParameters().entrySet()) {
            queryParams.put((String)e.getKey(), ((List)e.getValue()).toArray(new String[((List)e.getValue()).size()]));
        }
        return queryParams;
    }

    private class Checks {
        ClientSessionCode clientCode;
        Response response;

        private Checks() {
        }

        private boolean checkSsl(RealmModel realm) {
            if (SocialResource.this.uriInfo.getBaseUri().getScheme().equals("https")) {
                return true;
            }
            return !realm.getSslRequired().isRequired(SocialResource.this.clientConnection);
        }

        boolean check(EventBuilder event, RealmModel realm, String code, ClientSessionModel.Action requiredAction) {
            if (!this.checkSsl(realm)) {
                event.error("ssl_required");
                this.response = Flows.forwardToSecurityFailurePage(SocialResource.this.session, realm, SocialResource.this.uriInfo, "HTTPS required");
                return false;
            }
            if (!realm.isEnabled()) {
                event.error("realm_disabled");
                this.response = Flows.forwardToSecurityFailurePage(SocialResource.this.session, realm, SocialResource.this.uriInfo, "Realm not enabled.");
                return false;
            }
            this.clientCode = ClientSessionCode.parse(code, SocialResource.this.session, realm);
            if (this.clientCode == null) {
                event.error("invalid_code");
                this.response = Flows.forwardToSecurityFailurePage(SocialResource.this.session, realm, SocialResource.this.uriInfo, "Unknown code, please login again through your application.");
                return false;
            }
            if (!this.clientCode.isValid(requiredAction)) {
                event.error("invalid_code");
                this.response = Flows.forwardToSecurityFailurePage(SocialResource.this.session, realm, SocialResource.this.uriInfo, "Invalid code, please login again through your application.");
            }
            return true;
        }
    }
}

