/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.ServletContext;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.jboss.logging.Logger;
import org.jboss.resteasy.core.Dispatcher;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.keycloak.Config;
import org.keycloak.SkeletonKeyContextResolver;
import org.keycloak.exportimport.ExportImportManager;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.services.DefaultKeycloakSessionFactory;
import org.keycloak.services.managers.ApplianceBootstrap;
import org.keycloak.services.managers.BruteForceProtector;
import org.keycloak.services.managers.RealmManager;
import org.keycloak.services.managers.UsersSyncManager;
import org.keycloak.services.resources.JsResource;
import org.keycloak.services.resources.QRCodeResource;
import org.keycloak.services.resources.RealmsResource;
import org.keycloak.services.resources.ServerVersionResource;
import org.keycloak.services.resources.SocialResource;
import org.keycloak.services.resources.ThemeResource;
import org.keycloak.services.resources.WelcomeResource;
import org.keycloak.services.resources.admin.AdminRoot;
import org.keycloak.services.scheduled.ClearExpiredEvents;
import org.keycloak.services.scheduled.ClearExpiredUserSessions;
import org.keycloak.services.scheduled.ScheduledTaskRunner;
import org.keycloak.services.util.JsonConfigProvider;
import org.keycloak.timer.TimerProvider;
import org.keycloak.util.JsonSerialization;

public class KeycloakApplication
extends Application {
    private static final Logger log = Logger.getLogger(KeycloakApplication.class);
    protected Set<Object> singletons = new HashSet<Object>();
    protected Set<Class<?>> classes = new HashSet();
    protected KeycloakSessionFactory sessionFactory;
    protected String contextPath;

    public KeycloakApplication(@Context ServletContext context, @Context Dispatcher dispatcher) {
        KeycloakApplication.loadConfig();
        this.sessionFactory = KeycloakApplication.createSessionFactory();
        dispatcher.getDefaultContextObjects().put(KeycloakApplication.class, this);
        this.contextPath = context.getContextPath();
        BruteForceProtector protector = new BruteForceProtector(this.sessionFactory);
        dispatcher.getDefaultContextObjects().put(BruteForceProtector.class, protector);
        ResteasyProviderFactory.pushContext(BruteForceProtector.class, (Object)protector);
        protector.start();
        context.setAttribute(BruteForceProtector.class.getName(), (Object)protector);
        context.setAttribute(KeycloakSessionFactory.class.getName(), (Object)this.sessionFactory);
        this.singletons.add(new ServerVersionResource());
        this.singletons.add(new RealmsResource());
        this.singletons.add(new SocialResource());
        this.singletons.add(new AdminRoot());
        this.classes.add(SkeletonKeyContextResolver.class);
        this.classes.add(QRCodeResource.class);
        this.classes.add(ThemeResource.class);
        this.classes.add(JsResource.class);
        this.classes.add(WelcomeResource.class);
        new ExportImportManager().checkExportImport(this.sessionFactory);
        this.setupDefaultRealm(context.getContextPath());
        this.importRealms(context);
        KeycloakApplication.setupScheduledTasks(this.sessionFactory);
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public URI getBaseUri(UriInfo uriInfo) {
        return uriInfo.getBaseUriBuilder().replacePath(this.getContextPath()).build(new Object[0]);
    }

    public static void loadConfig() {
        try {
            File f;
            URL config = null;
            String configDir = System.getProperty("jboss.server.config.dir");
            if (configDir != null && (f = new File(configDir + File.separator + "keycloak-server.json")).isFile()) {
                config = f.toURI().toURL();
            }
            if (config == null) {
                config = Thread.currentThread().getContextClassLoader().getResource("META-INF/keycloak-server.json");
            }
            if (config != null) {
                JsonNode node = new ObjectMapper().readTree(config);
                Properties properties = new Properties();
                properties.putAll((Map<?, ?>)System.getProperties());
                for (Map.Entry<String, String> e : System.getenv().entrySet()) {
                    properties.put("env." + e.getKey(), e.getValue());
                }
                Config.init((Config.ConfigProvider)new JsonConfigProvider(node, properties));
                log.info((Object)("Loaded config from " + config));
                return;
            }
            log.warn((Object)"Config 'keycloak-server.json' not found");
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load config", e);
        }
    }

    protected void setupDefaultRealm(String contextPath) {
        new ApplianceBootstrap().bootstrap(this.sessionFactory, contextPath);
    }

    public static KeycloakSessionFactory createSessionFactory() {
        DefaultKeycloakSessionFactory factory = new DefaultKeycloakSessionFactory();
        factory.init();
        return factory;
    }

    public static void setupScheduledTasks(KeycloakSessionFactory sessionFactory) {
        long interval = Config.scope((String[])new String[]{"scheduled"}).getLong("interval", Long.valueOf(60L)) * 1000L;
        TimerProvider timer = (TimerProvider)sessionFactory.create().getProvider(TimerProvider.class);
        timer.schedule((Runnable)new ScheduledTaskRunner(sessionFactory, new ClearExpiredEvents()), interval, "ClearExpiredEvents");
        timer.schedule((Runnable)new ScheduledTaskRunner(sessionFactory, new ClearExpiredUserSessions()), interval, "ClearExpiredUserSessions");
        new UsersSyncManager().bootstrapPeriodic(sessionFactory, timer);
    }

    public KeycloakSessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public Set<Class<?>> getClasses() {
        return this.classes;
    }

    public Set<Object> getSingletons() {
        return this.singletons;
    }

    public void importRealms(ServletContext context) {
        this.importRealmFile();
        this.importRealmResources(context);
    }

    public void importRealmResources(ServletContext context) {
        String resources = context.getInitParameter("keycloak.import.realm.resources");
        if (resources != null) {
            StringTokenizer tokenizer = new StringTokenizer(resources, ",");
            while (tokenizer.hasMoreTokens()) {
                String resource = tokenizer.nextToken().trim();
                InputStream is = context.getResourceAsStream(resource);
                if (is == null) {
                    log.warn((Object)("Could not find realm resource to import: " + resource));
                }
                RealmRepresentation rep = KeycloakApplication.loadJson(is, RealmRepresentation.class);
                this.importRealm(rep, "resource " + resource);
            }
        }
    }

    public void importRealmFile() {
        String files = System.getProperty("keycloak.import");
        if (files != null) {
            StringTokenizer tokenizer = new StringTokenizer(files, ",");
            while (tokenizer.hasMoreTokens()) {
                String file = tokenizer.nextToken().trim();
                RealmRepresentation rep = null;
                try {
                    rep = KeycloakApplication.loadJson(new FileInputStream(file), RealmRepresentation.class);
                }
                catch (FileNotFoundException e) {
                    throw new RuntimeException(e);
                }
                this.importRealm(rep, "file " + file);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importRealm(RealmRepresentation rep, String from) {
        KeycloakSession session = this.sessionFactory.create();
        try {
            session.getTransaction().begin();
            RealmManager manager = new RealmManager(session);
            manager.setContextPath(this.getContextPath());
            if (rep.getId() != null && manager.getRealm(rep.getId()) != null) {
                log.info((Object)("Not importing realm " + rep.getRealm() + " from " + from + ".  It already exists."));
                return;
            }
            if (manager.getRealmByName(rep.getRealm()) != null) {
                log.info((Object)("Not importing realm " + rep.getRealm() + " from " + from + ".  It already exists."));
                return;
            }
            try {
                RealmModel realm = manager.importRealm(rep);
                session.getTransaction().commit();
                log.info((Object)("Imported realm " + realm.getName() + " from " + from));
            }
            catch (Throwable t) {
                session.getTransaction().rollback();
                log.warn((Object)("Unable to import realm " + rep.getRealm() + " from " + from + ". Cause: " + t.getMessage()));
            }
        }
        finally {
            session.close();
        }
    }

    private static <T> T loadJson(InputStream is, Class<T> type) {
        try {
            return (T)JsonSerialization.readValue((InputStream)is, type);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to parse json", e);
        }
    }
}

