/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.spi.NotFoundException;
import org.keycloak.models.ApplicationModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.representations.idm.ApplicationMappingsRepresentation;
import org.keycloak.representations.idm.MappingsRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.services.resources.admin.RealmAuth;
import org.keycloak.services.resources.admin.ScopeMappedApplicationResource;

public class ScopeMappedResource {
    protected RealmModel realm;
    private RealmAuth auth;
    protected ClientModel client;
    protected KeycloakSession session;

    public ScopeMappedResource(RealmModel realm, RealmAuth auth, ClientModel client, KeycloakSession session) {
        this.realm = realm;
        this.auth = auth;
        this.client = client;
        this.session = session;
    }

    @GET
    @Produces(value={"application/json"})
    @NoCache
    public MappingsRepresentation getScopeMappings() {
        List applications;
        this.auth.requireView();
        MappingsRepresentation all = new MappingsRepresentation();
        Set realmMappings = this.client.getRealmScopeMappings();
        if (realmMappings.size() > 0) {
            ArrayList<RoleRepresentation> realmRep = new ArrayList<RoleRepresentation>();
            for (RoleModel roleModel : realmMappings) {
                realmRep.add(ModelToRepresentation.toRepresentation((RoleModel)roleModel));
            }
            all.setRealmMappings(realmRep);
        }
        if ((applications = this.realm.getApplications()).size() > 0) {
            HashMap<String, ApplicationMappingsRepresentation> appMappings = new HashMap<String, ApplicationMappingsRepresentation>();
            for (ApplicationModel app : applications) {
                Set roleMappings = app.getApplicationScopeMappings(this.client);
                if (roleMappings.size() <= 0) continue;
                ApplicationMappingsRepresentation mappings = new ApplicationMappingsRepresentation();
                mappings.setApplicationId(app.getId());
                mappings.setApplication(app.getName());
                ArrayList<RoleRepresentation> roles = new ArrayList<RoleRepresentation>();
                mappings.setMappings(roles);
                for (RoleModel role : roleMappings) {
                    roles.add(ModelToRepresentation.toRepresentation((RoleModel)role));
                }
                appMappings.put(app.getName(), mappings);
                all.setApplicationMappings(appMappings);
            }
        }
        return all;
    }

    @Path(value="realm")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    public List<RoleRepresentation> getRealmScopeMappings() {
        this.auth.requireView();
        Set realmMappings = this.client.getRealmScopeMappings();
        ArrayList<RoleRepresentation> realmMappingsRep = new ArrayList<RoleRepresentation>();
        for (RoleModel roleModel : realmMappings) {
            realmMappingsRep.add(ModelToRepresentation.toRepresentation((RoleModel)roleModel));
        }
        return realmMappingsRep;
    }

    @Path(value="realm/available")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    public List<RoleRepresentation> getAvailableRealmScopeMappings() {
        this.auth.requireView();
        Set roles = this.realm.getRoles();
        return ScopeMappedResource.getAvailable(this.client, roles);
    }

    public static List<RoleRepresentation> getAvailable(ClientModel client, Set<RoleModel> roles) {
        ArrayList<RoleRepresentation> available = new ArrayList<RoleRepresentation>();
        for (RoleModel roleModel : roles) {
            if (client.hasScope(roleModel)) continue;
            available.add(ModelToRepresentation.toRepresentation((RoleModel)roleModel));
        }
        return available;
    }

    @Path(value="realm/composite")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    public List<RoleRepresentation> getCompositeRealmScopeMappings() {
        this.auth.requireView();
        Set roles = this.realm.getRoles();
        return ScopeMappedResource.getComposite(this.client, roles);
    }

    public static List<RoleRepresentation> getComposite(ClientModel client, Set<RoleModel> roles) {
        ArrayList<RoleRepresentation> composite = new ArrayList<RoleRepresentation>();
        for (RoleModel roleModel : roles) {
            if (!client.hasScope(roleModel)) continue;
            composite.add(ModelToRepresentation.toRepresentation((RoleModel)roleModel));
        }
        return composite;
    }

    @Path(value="realm")
    @POST
    @Consumes(value={"application/json"})
    public void addRealmScopeMappings(List<RoleRepresentation> roles) {
        this.auth.requireManage();
        for (RoleRepresentation role : roles) {
            RoleModel roleModel = this.realm.getRoleById(role.getId());
            if (roleModel == null) {
                throw new NotFoundException("Role not found");
            }
            this.client.addScopeMapping(roleModel);
        }
    }

    @Path(value="realm")
    @DELETE
    @Consumes(value={"application/json"})
    public void deleteRealmScopeMappings(List<RoleRepresentation> roles) {
        this.auth.requireManage();
        if (roles == null) {
            Set roleModels = this.client.getRealmScopeMappings();
            for (RoleModel roleModel : roleModels) {
                this.client.deleteScopeMapping(roleModel);
            }
        } else {
            for (RoleRepresentation role : roles) {
                RoleModel roleModel = this.realm.getRoleById(role.getId());
                if (roleModel == null) {
                    throw new NotFoundException("Application not found");
                }
                this.client.deleteScopeMapping(roleModel);
            }
        }
    }

    @Path(value="applications/{app}")
    public ScopeMappedApplicationResource getApplicationScopeMappings(@PathParam(value="app") String appName) {
        ApplicationModel app = this.realm.getApplicationByName(appName);
        if (app == null) {
            throw new NotFoundException("Role not found");
        }
        return new ScopeMappedApplicationResource(this.realm, this.auth, this.client, this.session, app);
    }

    @Path(value="applications-by-id/{appId}")
    public ScopeMappedApplicationResource getApplicationByIdScopeMappings(@PathParam(value="appId") String appId) {
        ApplicationModel app = this.realm.getApplicationById(appId);
        if (app == null) {
            throw new NotFoundException("Application not found");
        }
        return new ScopeMappedApplicationResource(this.realm, this.auth, this.client, this.session, app);
    }
}

