/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.web.handlers.saml2;

import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpSession;
import org.picketlink.common.exceptions.ConfigurationException;
import org.picketlink.common.exceptions.ProcessingException;
import org.picketlink.common.util.StringUtil;
import org.picketlink.config.federation.IDPType;
import org.picketlink.identity.federation.core.impl.DelegatedAttributeManager;
import org.picketlink.identity.federation.core.impl.EmptyAttributeManager;
import org.picketlink.identity.federation.core.interfaces.AttributeManager;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2AttributeManager;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2Handler;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerChainConfig;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerConfig;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerRequest;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerResponse;
import org.picketlink.identity.federation.core.saml.v2.util.StatementUtil;
import org.picketlink.identity.federation.saml.v2.SAML2Object;
import org.picketlink.identity.federation.saml.v2.assertion.AssertionType;
import org.picketlink.identity.federation.saml.v2.assertion.AttributeStatementType;
import org.picketlink.identity.federation.saml.v2.assertion.AttributeType;
import org.picketlink.identity.federation.saml.v2.assertion.StatementAbstractType;
import org.picketlink.identity.federation.saml.v2.protocol.AuthnRequestType;
import org.picketlink.identity.federation.saml.v2.protocol.LogoutRequestType;
import org.picketlink.identity.federation.saml.v2.protocol.ResponseType;
import org.picketlink.identity.federation.web.core.HTTPContext;
import org.picketlink.identity.federation.web.handlers.saml2.BaseSAML2Handler;
import org.picketlink.identity.federation.web.handlers.saml2.SecurityActions;

public class SAML2AttributeHandler
extends BaseSAML2Handler {
    protected SAML2AttributeManager attribManager = new DelegatedAttributeManager(new EmptyAttributeManager(), null);
    protected List<String> attributeKeys = new ArrayList<String>();
    protected boolean chooseFriendlyName = false;

    @Override
    public void initChainConfig(SAML2HandlerChainConfig handlerChainConfig) throws ConfigurationException {
        super.initChainConfig(handlerChainConfig);
        Object config = this.handlerChainConfig.getParameter("CONFIGURATION");
        if (config instanceof IDPType && this.getAttributeManager() == null) {
            IDPType idpType = (IDPType)config;
            String attribStr = idpType.getAttributeManager();
            this.insantiateAttributeManager(attribStr);
        }
    }

    private Object getAttributeManager() {
        if (this.handlerConfig == null) {
            return null;
        }
        return this.handlerConfig.getParameter("ATTRIBUTE_MANAGER");
    }

    @Override
    public void initHandlerConfig(SAML2HandlerConfig handlerConfig) throws ConfigurationException {
        String chooseFriendlyNameStr;
        super.initHandlerConfig(handlerConfig);
        String attribStr = (String)this.getAttributeManager();
        this.insantiateAttributeManager(attribStr);
        String attribList = (String)this.handlerConfig.getParameter("ATTRIBUTE_KEYS");
        if (StringUtil.isNotNull((String)attribList)) {
            this.attributeKeys.addAll(StringUtil.tokenize((String)attribList));
        }
        if (StringUtil.isNotNull((String)(chooseFriendlyNameStr = (String)handlerConfig.getParameter("ATTRIBUTE_CHOOSE_FRIENDLY_NAME")))) {
            this.chooseFriendlyName = Boolean.parseBoolean(chooseFriendlyNameStr);
        }
    }

    @Override
    public void handleRequestType(SAML2HandlerRequest request, SAML2HandlerResponse response) throws ProcessingException {
        Map sessionAttributes;
        SAML2Object saml2Object = request.getSAML2Object();
        if (saml2Object instanceof LogoutRequestType) {
            return;
        }
        if (this.getType() == SAML2Handler.HANDLER_TYPE.SP) {
            return;
        }
        HTTPContext httpContext = (HTTPContext)request.getContext();
        HttpSession session = httpContext.getRequest().getSession(false);
        Principal userPrincipal = (Principal)session.getAttribute("picketlink.principal");
        AuthnRequestType authnRequestType = (AuthnRequestType)saml2Object;
        if (userPrincipal == null) {
            userPrincipal = httpContext.getRequest().getUserPrincipal();
        }
        if ((sessionAttributes = (Map)session.getAttribute("ATTRIBUTES")) == null) {
            Set<AttributeStatementType> attributes = this.attribManager.getAttributes(authnRequestType, userPrincipal);
            request.addOption("ATTRIBUTES", attributes);
            session.setAttribute("ATTRIBUTES", StatementUtil.asMap(attributes));
        }
    }

    @Override
    public void handleStatusResponseType(SAML2HandlerRequest request, SAML2HandlerResponse response) throws ProcessingException {
        if (this.getType() == SAML2Handler.HANDLER_TYPE.IDP) {
            return;
        }
        this.handleIDPResponse(request);
    }

    private void insantiateAttributeManager(String attribStr) throws ConfigurationException {
        if (attribStr != null && !"".equals(attribStr)) {
            try {
                this.attribManager = new DelegatedAttributeManager((AttributeManager)SecurityActions.loadClass(this.getClass(), attribStr).newInstance(), null);
                logger.trace("AttributeManager set to " + attribStr);
            }
            catch (Exception e) {
                logger.attributeProviderInstationError((Throwable)e);
                throw logger.configurationError((Throwable)e);
            }
        }
    }

    protected void handleIDPResponse(SAML2HandlerRequest request) {
        if (!(request.getSAML2Object() instanceof ResponseType)) {
            return;
        }
        HTTPContext httpContext = (HTTPContext)request.getContext();
        HttpSession session = httpContext.getRequest().getSession(false);
        AssertionType assertion = (AssertionType)request.getOptions().get("ASSERTION");
        if (assertion == null) {
            throw logger.samlHandlerAssertionNotFound();
        }
        Set<StatementAbstractType> statements = assertion.getStatements();
        for (StatementAbstractType statement : statements) {
            if (!(statement instanceof AttributeStatementType)) continue;
            AttributeStatementType attrStat = (AttributeStatementType)statement;
            List<AttributeStatementType.ASTChoiceType> attrs = attrStat.getAttributes();
            for (AttributeStatementType.ASTChoiceType attrChoice : attrs) {
                HashMap<String, ArrayList<Object>> attrMap = (HashMap<String, ArrayList<Object>>)session.getAttribute("SESSION_ATTRIBUTE_MAP");
                if (attrMap == null) {
                    attrMap = new HashMap<String, ArrayList<Object>>();
                    session.setAttribute("SESSION_ATTRIBUTE_MAP", attrMap);
                }
                AttributeType attr = attrChoice.getAttribute();
                String attributeName = this.chooseFriendlyName ? attr.getFriendlyName() : attr.getName();
                ArrayList<Object> values = (ArrayList<Object>)attrMap.get(attributeName);
                if (values == null) {
                    values = new ArrayList<Object>();
                    attrMap.put(attributeName, values);
                }
                values.addAll(attr.getAttributeValue());
            }
        }
    }
}

