/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.web.handlers.saml2;

import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.security.Principal;
import java.security.PrivateKey;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.xml.namespace.QName;
import org.picketlink.common.constants.JBossSAMLConstants;
import org.picketlink.common.constants.JBossSAMLURIConstants;
import org.picketlink.common.constants.SAMLAuthenticationContextClass;
import org.picketlink.common.exceptions.ConfigurationException;
import org.picketlink.common.exceptions.ProcessingException;
import org.picketlink.common.exceptions.fed.AssertionExpiredException;
import org.picketlink.common.util.DocumentUtil;
import org.picketlink.common.util.StaxParserUtil;
import org.picketlink.common.util.StringUtil;
import org.picketlink.config.federation.SPType;
import org.picketlink.identity.federation.api.saml.v2.request.SAML2Request;
import org.picketlink.identity.federation.api.saml.v2.response.SAML2Response;
import org.picketlink.identity.federation.core.SerializablePrincipal;
import org.picketlink.identity.federation.core.audit.PicketLinkAuditEvent;
import org.picketlink.identity.federation.core.audit.PicketLinkAuditEventType;
import org.picketlink.identity.federation.core.audit.PicketLinkAuditHelper;
import org.picketlink.identity.federation.core.parsers.saml.SAMLParser;
import org.picketlink.identity.federation.core.saml.v2.common.IDGenerator;
import org.picketlink.identity.federation.core.saml.v2.holders.IDPInfoHolder;
import org.picketlink.identity.federation.core.saml.v2.holders.IssuerInfoHolder;
import org.picketlink.identity.federation.core.saml.v2.holders.SPInfoHolder;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2Handler;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerRequest;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerResponse;
import org.picketlink.identity.federation.core.saml.v2.util.AssertionUtil;
import org.picketlink.identity.federation.core.saml.v2.util.StatementUtil;
import org.picketlink.identity.federation.core.saml.v2.util.XMLTimeUtil;
import org.picketlink.identity.federation.core.util.JAXPValidationUtil;
import org.picketlink.identity.federation.core.util.XMLEncryptionUtil;
import org.picketlink.identity.federation.saml.v2.assertion.AssertionType;
import org.picketlink.identity.federation.saml.v2.assertion.AttributeStatementType;
import org.picketlink.identity.federation.saml.v2.assertion.AttributeType;
import org.picketlink.identity.federation.saml.v2.assertion.AuthnStatementType;
import org.picketlink.identity.federation.saml.v2.assertion.EncryptedAssertionType;
import org.picketlink.identity.federation.saml.v2.assertion.NameIDType;
import org.picketlink.identity.federation.saml.v2.assertion.StatementAbstractType;
import org.picketlink.identity.federation.saml.v2.assertion.SubjectType;
import org.picketlink.identity.federation.saml.v2.metadata.EndpointType;
import org.picketlink.identity.federation.saml.v2.metadata.SPSSODescriptorType;
import org.picketlink.identity.federation.saml.v2.protocol.AuthnContextComparisonType;
import org.picketlink.identity.federation.saml.v2.protocol.AuthnRequestType;
import org.picketlink.identity.federation.saml.v2.protocol.RequestedAuthnContextType;
import org.picketlink.identity.federation.saml.v2.protocol.ResponseType;
import org.picketlink.identity.federation.saml.v2.protocol.StatusType;
import org.picketlink.identity.federation.web.core.HTTPContext;
import org.picketlink.identity.federation.web.core.IdentityServer;
import org.picketlink.identity.federation.web.core.SessionManager;
import org.picketlink.identity.federation.web.handlers.saml2.BaseSAML2Handler;
import org.picketlink.identity.federation.web.interfaces.IRoleValidator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SAML2AuthenticationHandler
extends BaseSAML2Handler {
    public static final String SINGLE_ATTRIBUTE_STATEMENT = "SINGLE_ATTRIBUTE_STATEMENT";
    private final IDPAuthenticationHandler idp = new IDPAuthenticationHandler();
    private final SPAuthenticationHandler sp = new SPAuthenticationHandler();

    @Override
    public void handleRequestType(SAML2HandlerRequest request, SAML2HandlerResponse response) throws ProcessingException {
        if (!(request.getSAML2Object() instanceof AuthnRequestType)) {
            return;
        }
        if (this.getType() == SAML2Handler.HANDLER_TYPE.IDP) {
            this.idp.handleRequestType(request, response);
        } else {
            this.sp.handleRequestType(request, response);
        }
    }

    @Override
    public void handleStatusResponseType(SAML2HandlerRequest request, SAML2HandlerResponse response) throws ProcessingException {
        if (!(request.getSAML2Object() instanceof ResponseType)) {
            return;
        }
        if (this.getType() == SAML2Handler.HANDLER_TYPE.IDP) {
            this.idp.handleStatusResponseType(request, response);
        } else {
            this.sp.handleStatusResponseType(request, response);
        }
    }

    @Override
    public void generateSAMLRequest(SAML2HandlerRequest request, SAML2HandlerResponse response) throws ProcessingException {
        if (SAML2HandlerRequest.GENERATE_REQUEST_TYPE.AUTH != request.getTypeOfRequestToBeGenerated()) {
            return;
        }
        if (this.getType() == SAML2Handler.HANDLER_TYPE.IDP) {
            this.idp.generateSAMLRequest(request, response);
            response.setSendRequest(true);
        } else {
            this.sp.generateSAMLRequest(request, response);
            response.setSendRequest(true);
        }
    }

    protected void onAssertionCreated(SAML2HandlerRequest request, AssertionType assertion) {
    }

    protected List<AttributeStatementType> getAttributeStatements(SAML2HandlerRequest request) {
        Set attribs;
        ArrayList<AttributeStatementType> attributeStatementTypes = new ArrayList<AttributeStatementType>();
        HttpSession session = BaseSAML2Handler.getHttpSession(request);
        List roles = (List)session.getAttribute("picketlink.roles");
        if (this.handlerConfig.getParameter("DISABLE_SENDING_ROLES") == null && roles != null && !roles.isEmpty()) {
            AttributeStatementType attrStatement = null;
            attrStatement = this.handlerConfig.getParameter("USE_MULTI_VALUED_ROLES") != null ? StatementUtil.createAttributeStatementForRoles(roles, true) : StatementUtil.createAttributeStatement(roles);
            if (attrStatement != null) {
                attributeStatementTypes.add(attrStatement);
            }
        }
        if ((attribs = (Set)request.getOptions().get("ATTRIBUTES")) != null && attribs.size() > 0) {
            attributeStatementTypes.addAll(attribs);
        }
        return attributeStatementTypes;
    }

    private void createRequestedAuthnContext(AuthnRequestType authn) {
        String authnContextClasses = (String)this.handlerConfig.getParameter("AUTHN_CONTEXT_CLASSES");
        if (StringUtil.isNotNull((String)authnContextClasses)) {
            RequestedAuthnContextType requestAuthnContext = new RequestedAuthnContextType();
            for (String classFqn : authnContextClasses.split(",")) {
                SAMLAuthenticationContextClass standardClass = SAMLAuthenticationContextClass.forAlias((String)classFqn);
                if (standardClass != null) {
                    classFqn = standardClass.getFqn();
                }
                requestAuthnContext.addAuthnContextClassRef(classFqn);
            }
            if (!requestAuthnContext.getAuthnContextClassRef().isEmpty()) {
                String comparison = (String)this.handlerConfig.getParameter("REQUESTED_AUTHN_CONTEXT_COMPARISON");
                if (StringUtil.isNotNull((String)comparison)) {
                    requestAuthnContext.setComparison(AuthnContextComparisonType.fromValue(comparison));
                }
                authn.setRequestedAuthnContext(requestAuthnContext);
            } else {
                logger.debug("RequestedAuthnContext not set for AuthnRequest. No class was provided.");
            }
        }
    }

    private class SPAuthenticationHandler {
        private SPAuthenticationHandler() {
        }

        public void generateSAMLRequest(SAML2HandlerRequest request, SAML2HandlerResponse response) throws ProcessingException {
            String nameIDFormat;
            String issuerValue = request.getIssuer().getValue();
            SAML2Request samlRequest = new SAML2Request();
            String id = IDGenerator.create("ID_");
            String assertionConsumerURL = (String)SAML2AuthenticationHandler.this.handlerConfig.getParameter("ASSERTION_CONSUMER_URL");
            if (StringUtil.isNullOrEmpty((String)assertionConsumerURL)) {
                assertionConsumerURL = issuerValue;
            }
            if (StringUtil.isNotNull((String)(nameIDFormat = (String)SAML2AuthenticationHandler.this.handlerConfig.getParameter("NAMEID_FORMAT")))) {
                samlRequest.setNameIDFormat(nameIDFormat);
            }
            try {
                AuthnRequestType authn = samlRequest.createAuthnRequestType(id, assertionConsumerURL, response.getDestination(), issuerValue);
                SAML2AuthenticationHandler.this.createRequestedAuthnContext(authn);
                String bindingType = this.getSPConfiguration().getBindingType();
                boolean isIdpUsesPostBinding = this.getSPConfiguration().isIdpUsesPostBinding();
                if (bindingType != null) {
                    if (bindingType.equals("POST") || isIdpUsesPostBinding) {
                        authn.setProtocolBinding(URI.create(JBossSAMLURIConstants.SAML_HTTP_POST_BINDING.get()));
                    } else if (bindingType.equals("REDIRECT")) {
                        authn.setProtocolBinding(URI.create(JBossSAMLURIConstants.SAML_HTTP_REDIRECT_BINDING.get()));
                    } else {
                        throw BaseSAML2Handler.logger.samlInvalidProtocolBinding();
                    }
                }
                response.setResultingDocument(samlRequest.convert(authn));
                response.setSendRequest(true);
                Map<String, Object> requestOptions = request.getOptions();
                PicketLinkAuditHelper auditHelper = (PicketLinkAuditHelper)requestOptions.get("AUDIT_HELPER");
                if (auditHelper != null) {
                    PicketLinkAuditEvent auditEvent = new PicketLinkAuditEvent("Info");
                    auditEvent.setWhoIsAuditing((String)requestOptions.get("CONTEXT_PATH"));
                    auditEvent.setType(PicketLinkAuditEventType.CREATED_ASSERTION);
                    auditEvent.setAssertionID(id);
                    auditHelper.audit(auditEvent);
                }
                request.addOption("AUTH_REQUEST_ID", id);
            }
            catch (Exception e) {
                throw BaseSAML2Handler.logger.processingError((Throwable)e);
            }
        }

        public void handleStatusResponseType(SAML2HandlerRequest request, SAML2HandlerResponse response) throws ProcessingException {
            HTTPContext httpContext = (HTTPContext)request.getContext();
            ResponseType responseType = (ResponseType)request.getSAML2Object();
            List<ResponseType.RTChoiceType> assertions = responseType.getAssertions();
            if (assertions.size() == 0) {
                throw BaseSAML2Handler.logger.samlHandlerNoAssertionFromIDP();
            }
            PrivateKey privateKey = (PrivateKey)request.getOptions().get("DECRYPTING_KEY");
            Serializable assertion = assertions.get(0).getEncryptedAssertion();
            if (assertion instanceof EncryptedAssertionType) {
                responseType = this.decryptAssertion(responseType, privateKey);
                assertion = responseType.getAssertions().get(0).getAssertion();
            }
            if (assertion == null) {
                assertion = assertions.get(0).getAssertion();
            }
            request.addOption("ASSERTION", assertion);
            Principal userPrincipal = this.handleSAMLResponse(responseType, response);
            if (userPrincipal == null) {
                response.setError(403, "User Principal not determined: Forbidden");
            } else {
                HttpSession session = httpContext.getRequest().getSession(false);
                session.setAttribute("picketlink.principal", (Object)userPrincipal);
                Document assertionDocument = AssertionUtil.asDocument((AssertionType)assertion);
                String assertionAttributeName = (String)SAML2AuthenticationHandler.this.handlerConfig.getParameter("ASSERTION_SESSION_ATTRIBUTE_NAME");
                if (assertionAttributeName != null) {
                    session.setAttribute(assertionAttributeName, (Object)assertionDocument);
                }
                session.setAttribute("ASSERTION_SESSION_ATTRIBUTE_NAME", (Object)assertionDocument);
                SessionManager sessionManager = SessionManager.get(session.getServletContext());
                sessionManager.add(userPrincipal, session);
            }
        }

        public void handleRequestType(SAML2HandlerRequest request, SAML2HandlerResponse response) throws ProcessingException {
        }

        private ResponseType decryptAssertion(ResponseType responseType, PrivateKey privateKey) throws ProcessingException {
            if (privateKey == null) {
                throw BaseSAML2Handler.logger.nullArgumentError("privateKey");
            }
            SAML2Response saml2Response = new SAML2Response();
            try {
                Document doc = saml2Response.convert(responseType);
                Element enc = DocumentUtil.getElement((Document)doc, (QName)new QName(JBossSAMLConstants.ENCRYPTED_ASSERTION.get()));
                if (enc == null) {
                    throw BaseSAML2Handler.logger.samlHandlerNullEncryptedAssertion();
                }
                String oldID = enc.getAttribute(JBossSAMLConstants.ID.get());
                Document newDoc = DocumentUtil.createDocument();
                Node importedNode = newDoc.importNode(enc, true);
                newDoc.appendChild(importedNode);
                Element decryptedDocumentElement = XMLEncryptionUtil.decryptElementInDocument(newDoc, privateKey);
                SAMLParser parser = new SAMLParser();
                JAXPValidationUtil.checkSchemaValidation(decryptedDocumentElement);
                AssertionType assertion = (AssertionType)parser.parse(StaxParserUtil.getXMLEventReader((InputStream)DocumentUtil.getNodeAsStream((Node)decryptedDocumentElement)));
                responseType.replaceAssertion(oldID, new ResponseType.RTChoiceType(assertion));
                return responseType;
            }
            catch (Exception e) {
                throw BaseSAML2Handler.logger.processingError((Throwable)e);
            }
        }

        private Principal handleSAMLResponse(ResponseType responseType, SAML2HandlerResponse response) throws ProcessingException {
            boolean expiredAssertion;
            if (responseType == null) {
                throw BaseSAML2Handler.logger.nullArgumentError("response type");
            }
            StatusType statusType = responseType.getStatus();
            if (statusType == null) {
                throw BaseSAML2Handler.logger.nullArgumentError("Status Type from the IDP");
            }
            String statusValue = statusType.getStatusCode().getValue().toASCIIString();
            if (!JBossSAMLURIConstants.STATUS_SUCCESS.get().equals(statusValue)) {
                throw BaseSAML2Handler.logger.samlHandlerIDPAuthenticationFailedError();
            }
            List<ResponseType.RTChoiceType> assertions = responseType.getAssertions();
            if (assertions.size() == 0) {
                throw BaseSAML2Handler.logger.samlHandlerNoAssertionFromIDP();
            }
            AssertionType assertion = assertions.get(0).getAssertion();
            try {
                String skew = (String)SAML2AuthenticationHandler.this.handlerConfig.getParameter("CLOCK_SKEW_MILIS");
                if (StringUtil.isNotNull((String)skew)) {
                    long skewMilis = Long.parseLong(skew);
                    expiredAssertion = AssertionUtil.hasExpired(assertion, skewMilis);
                } else {
                    expiredAssertion = AssertionUtil.hasExpired(assertion);
                }
            }
            catch (ConfigurationException e) {
                throw new ProcessingException((Throwable)e);
            }
            if (expiredAssertion) {
                AssertionExpiredException aee = new AssertionExpiredException();
                aee.setId(assertion.getID());
                throw BaseSAML2Handler.logger.assertionExpiredError(aee);
            }
            SubjectType subject = assertion.getSubject();
            if (subject == null) {
                throw BaseSAML2Handler.logger.nullValueError("Subject in the assertion");
            }
            SubjectType.STSubType subType = subject.getSubType();
            if (subType == null) {
                throw BaseSAML2Handler.logger.nullValueError("Unable to find subtype via subject");
            }
            NameIDType nameID = (NameIDType)subType.getBaseID();
            if (nameID == null) {
                throw BaseSAML2Handler.logger.nullValueError("Unable to find username via subject");
            }
            String userName = nameID.getValue();
            ArrayList<String> roles = new ArrayList<String>();
            Set<StatementAbstractType> statements = assertion.getStatements();
            for (StatementAbstractType statement : statements) {
                if (!(statement instanceof AttributeStatementType)) continue;
                AttributeStatementType attributeStatement = (AttributeStatementType)statement;
                roles.addAll(this.getRoles(attributeStatement));
            }
            response.setRoles(roles);
            SerializablePrincipal principal = new SerializablePrincipal(userName);
            if (SAML2AuthenticationHandler.this.handlerChainConfig.getParameter("ROLE_VALIDATOR_IGNORE") == null) {
                IRoleValidator roleValidator = (IRoleValidator)SAML2AuthenticationHandler.this.handlerChainConfig.getParameter("ROLE_VALIDATOR");
                if (roleValidator == null) {
                    throw BaseSAML2Handler.logger.nullValueError("Role Validator");
                }
                boolean validRole = roleValidator.userInRole(principal, roles);
                if (!validRole) {
                    BaseSAML2Handler.logger.trace("Invalid role: " + roles);
                    principal = null;
                }
            }
            return principal;
        }

        private List<String> getRoles(AttributeStatementType attributeStatement) {
            String roleKey;
            String val;
            ArrayList<String> roles = new ArrayList<String>();
            if (SAML2AuthenticationHandler.this.handlerConfig.containsKey("DISABLE_ROLE_PICKING") && StringUtil.isNotNull((String)(val = (String)SAML2AuthenticationHandler.this.handlerConfig.getParameter("DISABLE_ROLE_PICKING"))) && "true".equalsIgnoreCase(val)) {
                return roles;
            }
            ArrayList roleKeys = new ArrayList();
            if (SAML2AuthenticationHandler.this.handlerConfig.containsKey("ROLE_KEY") && StringUtil.isNotNull((String)(roleKey = (String)SAML2AuthenticationHandler.this.handlerConfig.getParameter("ROLE_KEY")))) {
                roleKeys.addAll(StringUtil.tokenize((String)roleKey));
            }
            List<AttributeStatementType.ASTChoiceType> attList = attributeStatement.getAttributes();
            for (AttributeStatementType.ASTChoiceType obj : attList) {
                List<Object> attributeValues;
                AttributeType attr = obj.getAttribute();
                if (roleKeys.size() > 0 && !roleKeys.contains(attr.getName()) || (attributeValues = attr.getAttributeValue()) == null) continue;
                for (Object attrValue : attributeValues) {
                    if (attrValue instanceof String) {
                        roles.add((String)attrValue);
                        continue;
                    }
                    if (attrValue instanceof Node) {
                        Node roleNode = (Node)attrValue;
                        roles.add(roleNode.getFirstChild().getNodeValue());
                        continue;
                    }
                    throw BaseSAML2Handler.logger.unsupportedRoleType(attrValue);
                }
            }
            return roles;
        }

        private SPType getSPConfiguration() {
            SPType spConfiguration = (SPType)SAML2AuthenticationHandler.this.handlerChainConfig.getParameter("CONFIGURATION");
            if (spConfiguration == null) {
                throw BaseSAML2Handler.logger.samlHandlerServiceProviderConfigNotFound();
            }
            return spConfiguration;
        }
    }

    private class IDPAuthenticationHandler {
        private IDPAuthenticationHandler() {
        }

        public void generateSAMLRequest(SAML2HandlerRequest request, SAML2HandlerResponse response) throws ProcessingException {
        }

        public void handleStatusResponseType(SAML2HandlerRequest request, SAML2HandlerResponse response) throws ProcessingException {
        }

        public void handleRequestType(SAML2HandlerRequest request, SAML2HandlerResponse response) throws ProcessingException {
            HTTPContext httpContext = (HTTPContext)request.getContext();
            ServletContext servletContext = httpContext.getServletContext();
            AuthnRequestType art = (AuthnRequestType)request.getSAML2Object();
            if (art == null) {
                throw BaseSAML2Handler.logger.samlHandlerAuthnRequestIsNull();
            }
            String destination = art.getSenderURL().toASCIIString();
            BaseSAML2Handler.logger.trace("Destination = " + destination);
            response.setDestination(destination);
            HttpSession session = BaseSAML2Handler.getHttpSession(request);
            Principal userPrincipal = (Principal)session.getAttribute("picketlink.principal");
            if (userPrincipal == null) {
                userPrincipal = httpContext.getRequest().getUserPrincipal();
            }
            try {
                Document samlResponse = this.getResponse(request);
                boolean isPost = httpContext.getRequest().getMethod().equalsIgnoreCase("POST");
                IdentityServer identityServer = (IdentityServer)servletContext.getAttribute("IDENTITY_SERVER");
                String participantLogoutURL = this.getParticipantURL(destination, request);
                BaseSAML2Handler.logger.trace("Participant " + destination + " will be registered to IdentityServer with logout URL " + participantLogoutURL);
                if (participantLogoutURL != null) {
                    identityServer.stack().register(session.getId(), participantLogoutURL, isPost);
                }
                boolean strictPostBinding = request.getOptions().get("SAML_IDP_STRICT_POST_BINDING") != null && (Boolean)request.getOptions().get("SAML_IDP_STRICT_POST_BINDING") != false;
                boolean postBindingForResponse = isPost || strictPostBinding;
                response.setResultingDocument(samlResponse);
                response.setRelayState(request.getRelayState());
                response.setPostBindingForResponse(postBindingForResponse);
            }
            catch (Exception e) {
                BaseSAML2Handler.logger.samlHandlerAuthenticationError((Throwable)e);
                throw BaseSAML2Handler.logger.processingError((Throwable)e);
            }
        }

        public Document getResponse(SAML2HandlerRequest request) throws ConfigurationException, ProcessingException {
            List<AttributeStatementType> attributeStatements;
            AssertionType latestAssertion;
            HTTPContext httpContext = (HTTPContext)request.getContext();
            AuthnRequestType art = (AuthnRequestType)request.getSAML2Object();
            HttpSession session = BaseSAML2Handler.getHttpSession(request);
            Principal userPrincipal = (Principal)session.getAttribute("picketlink.principal");
            if (userPrincipal == null) {
                userPrincipal = httpContext.getRequest().getUserPrincipal();
            }
            String assertionConsumerURL = art.getSenderURL().toASCIIString();
            String identityURL = request.getIssuer().getValue();
            String requestID = art.getID();
            Document samlResponseDocument = null;
            String authMethod = (String)request.getOptions().get("LOGIN_TYPE");
            BaseSAML2Handler.logger.trace("AssertionConsumerURL=" + assertionConsumerURL);
            ResponseType responseType = null;
            SAML2Response saml2Response = new SAML2Response();
            String id = IDGenerator.create("ID_");
            IssuerInfoHolder issuerHolder = new IssuerInfoHolder(identityURL);
            issuerHolder.setStatusCode(JBossSAMLURIConstants.STATUS_SUCCESS.get());
            IDPInfoHolder idp = new IDPInfoHolder();
            idp.setNameIDFormatValue(userPrincipal.getName());
            idp.setNameIDFormat(JBossSAMLURIConstants.NAMEID_FORMAT_PERSISTENT.get());
            String assertionID = (String)session.getAttribute("ASSERTION_ID");
            if (assertionID != null && (latestAssertion = (AssertionType)session.getAttribute("ASSERTION")) != null) {
                idp.setAssertion(latestAssertion);
            }
            SPInfoHolder sp = new SPInfoHolder();
            sp.setResponseDestinationURI(assertionConsumerURL);
            sp.setRequestID(requestID);
            sp.setIssuer(art.getIssuer().getValue());
            responseType = saml2Response.createResponseType(id, sp, idp, issuerHolder);
            AssertionType assertion = responseType.getAssertions().get(0).getAssertion();
            SAML2AuthenticationHandler.this.onAssertionCreated(request, assertion);
            if (SAML2AuthenticationHandler.this.handlerConfig.getParameter("DISABLE_AUTHN_STATEMENT") == null) {
                String authContextRef = JBossSAMLURIConstants.AC_PASSWORD.get();
                if (StringUtil.isNotNull((String)authMethod)) {
                    authContextRef = authMethod;
                }
                AuthnStatementType authnStatement = StatementUtil.createAuthnStatement(XMLTimeUtil.getIssueInstant(), authContextRef);
                authnStatement.setSessionIndex(assertion.getID());
                assertion.addStatement(authnStatement);
            }
            if ((attributeStatements = SAML2AuthenticationHandler.this.getAttributeStatements(request)) != null) {
                if (this.isSingleAttributeStatement()) {
                    AttributeStatementType singleStatement = new AttributeStatementType();
                    for (AttributeStatementType statement : attributeStatements) {
                        singleStatement.addAttributes(statement.getAttributes());
                    }
                    assertion.addStatement(singleStatement);
                } else {
                    for (AttributeStatementType attributeStatementType : attributeStatements) {
                        assertion.addStatement(attributeStatementType);
                    }
                }
            }
            session.setAttribute("ASSERTION", (Object)assertion);
            Map<String, Object> requestOptions = request.getOptions();
            PicketLinkAuditHelper auditHelper = (PicketLinkAuditHelper)requestOptions.get("AUDIT_HELPER");
            if (auditHelper != null) {
                PicketLinkAuditEvent auditEvent = new PicketLinkAuditEvent("Info");
                auditEvent.setWhoIsAuditing((String)requestOptions.get("CONTEXT_PATH"));
                auditEvent.setType(PicketLinkAuditEventType.CREATED_ASSERTION);
                auditEvent.setAssertionID(id);
                auditHelper.audit(auditEvent);
            }
            try {
                samlResponseDocument = saml2Response.convert(responseType);
                if (BaseSAML2Handler.logger.isTraceEnabled()) {
                    BaseSAML2Handler.logger.trace("SAML Response Document: " + DocumentUtil.asString((Document)samlResponseDocument));
                }
            }
            catch (Exception e) {
                throw BaseSAML2Handler.logger.samlAssertionMarshallError((Throwable)e);
            }
            return samlResponseDocument;
        }

        private String getParticipantURL(String destination, SAML2HandlerRequest request) {
            SPSSODescriptorType spMetadata = (SPSSODescriptorType)request.getOptions().get("SP_SSO_METADATA_DESCRIPTOR");
            if (spMetadata == null) {
                return destination;
            }
            List<EndpointType> logoutEndpoints = spMetadata.getSingleLogoutService();
            if (logoutEndpoints == null || logoutEndpoints.size() == 0) {
                return null;
            }
            EndpointType logoutEndpoint = logoutEndpoints.get(0);
            return logoutEndpoint.getLocation().toASCIIString();
        }

        private boolean isSingleAttributeStatement() {
            return SAML2AuthenticationHandler.this.handlerConfig.getParameter(SAML2AuthenticationHandler.SINGLE_ATTRIBUTE_STATEMENT) != null ? Boolean.valueOf(SAML2AuthenticationHandler.this.handlerConfig.getParameter(SAML2AuthenticationHandler.SINGLE_ATTRIBUTE_STATEMENT).toString()) : false;
        }
    }
}

