/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.account.freemarker.model;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.keycloak.models.ApplicationModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientSessionModel;
import org.keycloak.models.OAuthClientModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.util.Time;

public class SessionsBean {
    private List<UserSessionBean> events = new LinkedList<UserSessionBean>();
    private RealmModel realm;

    public SessionsBean(RealmModel realm, List<UserSessionModel> sessions) {
        for (UserSessionModel session : sessions) {
            this.events.add(new UserSessionBean(realm, session));
        }
    }

    public List<UserSessionBean> getSessions() {
        return this.events;
    }

    public static class UserSessionBean {
        private UserSessionModel session;
        private RealmModel realm;

        public UserSessionBean(RealmModel realm, UserSessionModel session) {
            this.realm = realm;
            this.session = session;
        }

        public String getId() {
            return this.session.getId();
        }

        public String getIpAddress() {
            return this.session.getIpAddress();
        }

        public Date getStarted() {
            return Time.toDate((int)this.session.getStarted());
        }

        public Date getLastAccess() {
            return Time.toDate((int)this.session.getLastSessionRefresh());
        }

        public Date getExpires() {
            int max = this.session.getStarted() + this.realm.getSsoSessionMaxLifespan();
            return Time.toDate((int)max);
        }

        public Set<String> getApplications() {
            HashSet<String> apps = new HashSet<String>();
            for (ClientSessionModel clientSession : this.session.getClientSessions()) {
                ClientModel client = clientSession.getClient();
                if (!(client instanceof ApplicationModel)) continue;
                apps.add(client.getClientId());
            }
            return apps;
        }

        public List<String> getClients() {
            ArrayList<String> apps = new ArrayList<String>();
            for (ClientSessionModel clientSession : this.session.getClientSessions()) {
                ClientModel client = clientSession.getClient();
                if (!(client instanceof OAuthClientModel)) continue;
                apps.add(client.getClientId());
            }
            return apps;
        }
    }
}

