/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.provider;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.jboss.logging.Logger;
import org.keycloak.provider.DefaultProviderLoader;
import org.keycloak.provider.ProviderFactory;
import org.keycloak.provider.ProviderLoader;
import org.keycloak.provider.ProviderLoaderFactory;
import org.keycloak.provider.Spi;

public class ProviderManager {
    private static final Logger log = Logger.getLogger(ProviderManager.class);
    private List<ProviderLoader> loaders = new LinkedList<ProviderLoader>();
    private Map<String, List<ProviderFactory>> cache = new HashMap<String, List<ProviderFactory>>();

    public ProviderManager(ClassLoader baseClassLoader, String ... resources) {
        LinkedList<ProviderLoaderFactory> factories = new LinkedList<ProviderLoaderFactory>();
        for (ProviderLoaderFactory f : ServiceLoader.load(ProviderLoaderFactory.class)) {
            factories.add(f);
        }
        log.debugv("Provider loaders {0}", factories);
        this.loaders.add(new DefaultProviderLoader(baseClassLoader));
        if (resources != null) {
            for (String r : resources) {
                String type = r.substring(0, r.indexOf(58));
                String resource = r.substring(r.indexOf(58) + 1, r.length());
                boolean found = false;
                for (ProviderLoaderFactory f : factories) {
                    if (!f.supports(type)) continue;
                    this.loaders.add(f.create(baseClassLoader, resource));
                    found = true;
                    break;
                }
                if (found) continue;
                throw new RuntimeException("Provider loader for " + r + " not found");
            }
        }
    }

    public synchronized List<ProviderFactory> load(Spi spi) {
        List<ProviderFactory> factories = this.cache.get(spi.getName());
        if (factories == null) {
            factories = new LinkedList<ProviderFactory>();
            for (ProviderLoader loader : this.loaders) {
                List f = loader.load(spi);
                if (f == null) continue;
                factories.addAll(f);
            }
        }
        return factories;
    }

    public synchronized ProviderFactory load(Spi spi, String providerId) {
        for (ProviderFactory f : this.load(spi)) {
            if (!f.getId().equals(providerId)) continue;
            return f;
        }
        return null;
    }
}

