/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.saml;

import org.keycloak.Config;
import org.keycloak.events.EventBuilder;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.protocol.LoginProtocol;
import org.keycloak.protocol.LoginProtocolFactory;
import org.keycloak.protocol.saml.SamlProtocol;
import org.keycloak.protocol.saml.SamlService;
import org.keycloak.services.managers.AuthenticationManager;
import org.picketlink.identity.federation.core.sts.PicketLinkCoreSTS;

public class SamlProtocolFactory
implements LoginProtocolFactory {
    public Object createProtocolEndpoint(RealmModel realm, EventBuilder event, AuthenticationManager authManager) {
        return new SamlService(realm, event, authManager);
    }

    public LoginProtocol create(KeycloakSession session) {
        return new SamlProtocol().setSession(session);
    }

    public void init(Config.Scope config) {
        PicketLinkCoreSTS sts = PicketLinkCoreSTS.instance();
        sts.installDefaultConfiguration(new String[0]);
    }

    public void close() {
    }

    public String getId() {
        return "saml";
    }
}

