/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.config;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import org.picketlink.common.exceptions.ParsingException;
import org.picketlink.common.parsers.AbstractParser;
import org.picketlink.common.util.StaxParserUtil;
import org.picketlink.config.federation.PicketLinkType;
import org.picketlink.config.federation.ProviderType;
import org.picketlink.config.federation.STSType;
import org.picketlink.config.federation.handler.Handlers;
import org.picketlink.config.federation.parsers.SAMLConfigParser;
import org.picketlink.config.federation.parsers.STSConfigParser;
import org.picketlink.config.idm.IDMType;
import org.picketlink.config.idm.parsers.IDMConfigParser;

public class PicketLinkConfigParser
extends AbstractParser {
    public static final String PICKETLINK = "PicketLink";
    public static final String ENABLE_AUDIT = "EnableAudit";

    public Object parse(XMLEventReader xmlEventReader) throws ParsingException {
        PicketLinkType picketLinkType = new PicketLinkType();
        StartElement startElement = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
        StaxParserUtil.validate((StartElement)startElement, (String)PICKETLINK);
        QName attributeQName = new QName("", ENABLE_AUDIT);
        Attribute attribute = startElement.getAttributeByName(attributeQName);
        if (attribute != null) {
            picketLinkType.setEnableAudit(Boolean.parseBoolean(StaxParserUtil.getAttributeValue((Attribute)attribute)));
        }
        startElement = StaxParserUtil.peekNextStartElement((XMLEventReader)xmlEventReader);
        String tag = StaxParserUtil.getStartElementName((StartElement)startElement);
        while (xmlEventReader.hasNext()) {
            AbstractParser samlConfigParser;
            if ("PicketLinkIDP".equals(tag)) {
                samlConfigParser = new SAMLConfigParser();
                ProviderType idp = (ProviderType)samlConfigParser.parse(xmlEventReader);
                picketLinkType.setIdpOrSP(idp);
            } else if ("PicketLinkSP".equals(tag)) {
                samlConfigParser = new SAMLConfigParser();
                ProviderType sp = (ProviderType)samlConfigParser.parse(xmlEventReader);
                picketLinkType.setIdpOrSP(sp);
            } else if ("Handlers".equals(tag)) {
                samlConfigParser = new SAMLConfigParser();
                Handlers handlers = (Handlers)samlConfigParser.parse(xmlEventReader);
                picketLinkType.setHandlers(handlers);
            } else if ("PicketLinkSTS".equals(tag)) {
                samlConfigParser = new STSConfigParser();
                STSType sts = (STSType)samlConfigParser.parse(xmlEventReader);
                picketLinkType.setStsType(sts);
            } else if ("PicketLinkIDM".equals(tag)) {
                IDMConfigParser parser = new IDMConfigParser();
                IDMType idmType = (IDMType)parser.parse(xmlEventReader);
                picketLinkType.setIdmType(idmType);
            } else {
                throw logger.parserUnknownStartElement(tag, startElement.getLocation());
            }
            startElement = StaxParserUtil.peekNextStartElement((XMLEventReader)xmlEventReader);
            if (startElement == null) break;
            tag = StaxParserUtil.getStartElementName((StartElement)startElement);
        }
        return picketLinkType;
    }

    public boolean supports(QName qname) {
        return false;
    }
}

