/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change;

import java.math.BigInteger;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import liquibase.change.ConstraintsConfig;
import liquibase.parser.core.ParsedNode;
import liquibase.parser.core.ParsedNodeException;
import liquibase.resource.ResourceAccessor;
import liquibase.serializer.AbstractLiquibaseSerializable;
import liquibase.serializer.LiquibaseSerializable;
import liquibase.statement.DatabaseFunction;
import liquibase.statement.SequenceCurrentValueFunction;
import liquibase.statement.SequenceNextValueFunction;
import liquibase.structure.core.Column;
import liquibase.structure.core.ForeignKey;
import liquibase.structure.core.PrimaryKey;
import liquibase.structure.core.Table;
import liquibase.structure.core.UniqueConstraint;
import liquibase.util.ISODateFormat;
import liquibase.util.StringUtils;

public class ColumnConfig
extends AbstractLiquibaseSerializable {
    private String name;
    private String type;
    private String value;
    private Number valueNumeric;
    private Date valueDate;
    private Boolean valueBoolean;
    private String valueBlobFile;
    private String valueClobFile;
    private String encoding;
    private DatabaseFunction valueComputed;
    private SequenceNextValueFunction valueSequenceNext;
    private SequenceCurrentValueFunction valueSequenceCurrent;
    private String defaultValue;
    private Number defaultValueNumeric;
    private Date defaultValueDate;
    private Boolean defaultValueBoolean;
    private DatabaseFunction defaultValueComputed;
    private SequenceNextValueFunction defaultValueSequenceNext;
    private ConstraintsConfig constraints;
    private Boolean autoIncrement;
    private BigInteger startWith;
    private BigInteger incrementBy;
    private String remarks;

    public ColumnConfig(Column columnSnapshot) {
        this.setName(columnSnapshot.getName());
        this.setType(columnSnapshot.getType().toString());
        if (columnSnapshot.getRelation() != null && columnSnapshot.getRelation() instanceof Table) {
            List<ForeignKey> fks;
            List<UniqueConstraint> uniqueConstraints;
            if (columnSnapshot.getDefaultValue() != null) {
                this.setDefaultValue(columnSnapshot.getDefaultValue().toString());
            }
            ConstraintsConfig constraints = new ConstraintsConfig();
            constraints.setNullable(columnSnapshot.isNullable());
            if (columnSnapshot.isAutoIncrement()) {
                this.setAutoIncrement(true);
                this.setStartWith(columnSnapshot.getAutoIncrementInformation().getStartWith());
                this.setIncrementBy(columnSnapshot.getAutoIncrementInformation().getIncrementBy());
            } else {
                this.setAutoIncrement(false);
            }
            Table table = (Table)columnSnapshot.getRelation();
            PrimaryKey primaryKey = table.getPrimaryKey();
            if (primaryKey != null && primaryKey.getColumnNamesAsList().contains(columnSnapshot.getName())) {
                constraints.setPrimaryKey(true);
                constraints.setPrimaryKeyName(primaryKey.getName());
                constraints.setPrimaryKeyTablespace(primaryKey.getTablespace());
            }
            if ((uniqueConstraints = table.getUniqueConstraints()) != null) {
                for (UniqueConstraint constraint : uniqueConstraints) {
                    if (!constraint.getColumnNames().contains(this.getName())) continue;
                    constraints.setUnique(true);
                    constraints.setUniqueConstraintName(constraint.getName());
                }
            }
            if ((fks = table.getOutgoingForeignKeys()) != null) {
                for (ForeignKey fk : fks) {
                    if (!fk.getForeignKeyColumns().equals(this.getName())) continue;
                    constraints.setForeignKeyName(fk.getName());
                    constraints.setReferences(fk.getPrimaryKeyTable().getName() + "(" + fk.getPrimaryKeyColumns() + ")");
                }
            }
            if (constraints.isPrimaryKey() == null) {
                constraints.setPrimaryKey(false);
            }
            if (constraints.isUnique() == null) {
                constraints.setUnique(false);
            }
            this.setConstraints(constraints);
        }
        this.setRemarks(columnSnapshot.getRemarks());
    }

    public ColumnConfig() {
    }

    public String getName() {
        return this.name;
    }

    public ColumnConfig setName(String name) {
        this.name = name;
        return this;
    }

    public String getType() {
        return this.type;
    }

    public ColumnConfig setType(String type) {
        this.type = type;
        return this;
    }

    public String getValue() {
        return this.value;
    }

    public ColumnConfig setValue(String value) {
        this.value = value;
        return this;
    }

    public Number getValueNumeric() {
        return this.valueNumeric;
    }

    public ColumnConfig setValueNumeric(String valueNumeric) {
        if (valueNumeric == null || valueNumeric.equalsIgnoreCase("null")) {
            this.valueNumeric = null;
        } else {
            if (valueNumeric.startsWith("(")) {
                valueNumeric = valueNumeric.replaceFirst("^\\(", "");
                valueNumeric = valueNumeric.replaceFirst("\\)$", "");
            }
            try {
                this.valueNumeric = NumberFormat.getInstance(Locale.US).parse(valueNumeric);
            }
            catch (ParseException e) {
                this.valueComputed = new DatabaseFunction(valueNumeric);
            }
        }
        return this;
    }

    public ColumnConfig setValueNumeric(Number valueNumeric) {
        this.valueNumeric = valueNumeric;
        return this;
    }

    public Boolean getValueBoolean() {
        return this.valueBoolean;
    }

    public ColumnConfig setValueBoolean(Boolean valueBoolean) {
        this.valueBoolean = valueBoolean;
        return this;
    }

    public ColumnConfig setValueBoolean(String valueBoolean) {
        if ((valueBoolean = StringUtils.trimToNull(valueBoolean)) == null || valueBoolean.equalsIgnoreCase("null")) {
            this.valueBoolean = null;
        } else if (valueBoolean.equalsIgnoreCase("true") || valueBoolean.equals("1")) {
            this.valueBoolean = true;
        } else if (valueBoolean.equalsIgnoreCase("false") || valueBoolean.equals("0")) {
            this.valueBoolean = false;
        } else {
            this.valueComputed = new DatabaseFunction(valueBoolean);
        }
        return this;
    }

    public DatabaseFunction getValueComputed() {
        return this.valueComputed;
    }

    public ColumnConfig setValueComputed(DatabaseFunction valueComputed) {
        this.valueComputed = valueComputed;
        return this;
    }

    public ColumnConfig setValueSequenceNext(SequenceNextValueFunction valueSequenceNext) {
        this.valueSequenceNext = valueSequenceNext;
        return this;
    }

    public SequenceNextValueFunction getValueSequenceNext() {
        return this.valueSequenceNext;
    }

    public ColumnConfig setValueSequenceCurrent(SequenceCurrentValueFunction valueSequenceCurrent) {
        this.valueSequenceCurrent = valueSequenceCurrent;
        return this;
    }

    public SequenceCurrentValueFunction getValueSequenceCurrent() {
        return this.valueSequenceCurrent;
    }

    public Date getValueDate() {
        return this.valueDate;
    }

    public ColumnConfig setValueDate(Date valueDate) {
        this.valueDate = valueDate;
        return this;
    }

    public ColumnConfig setValueDate(String valueDate) {
        if (valueDate == null || valueDate.equalsIgnoreCase("null")) {
            this.valueDate = null;
        } else {
            try {
                this.valueDate = new ISODateFormat().parse(valueDate);
            }
            catch (ParseException e) {
                this.valueComputed = new DatabaseFunction(valueDate);
            }
        }
        return this;
    }

    public String getValueBlobFile() {
        return this.valueBlobFile;
    }

    public ColumnConfig setValueBlobFile(String valueBlobFile) {
        this.valueBlobFile = valueBlobFile;
        return this;
    }

    public String getValueClobFile() {
        return this.valueClobFile;
    }

    public ColumnConfig setValueClobFile(String valueClobFile) {
        this.valueClobFile = valueClobFile;
        return this;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public ColumnConfig setEncoding(String encoding) {
        this.encoding = encoding;
        return this;
    }

    public Object getValueObject() {
        if (this.getValue() != null) {
            return this.getValue();
        }
        if (this.getValueBoolean() != null) {
            return this.getValueBoolean();
        }
        if (this.getValueNumeric() != null) {
            return this.getValueNumeric();
        }
        if (this.getValueDate() != null) {
            return this.getValueDate();
        }
        if (this.getValueComputed() != null) {
            return this.getValueComputed();
        }
        if (this.getValueClobFile() != null) {
            return this.getValueClobFile();
        }
        if (this.getValueBlobFile() != null) {
            return this.getValueBlobFile();
        }
        if (this.getValueSequenceNext() != null) {
            return this.getValueSequenceNext();
        }
        if (this.getValueSequenceCurrent() != null) {
            return this.getValueSequenceCurrent();
        }
        return null;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public ColumnConfig setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public Number getDefaultValueNumeric() {
        return this.defaultValueNumeric;
    }

    public ColumnConfig setDefaultValueNumeric(Number defaultValueNumeric) {
        this.defaultValueNumeric = defaultValueNumeric;
        return this;
    }

    public ColumnConfig setDefaultValueNumeric(String defaultValueNumeric) {
        if (defaultValueNumeric == null || defaultValueNumeric.equalsIgnoreCase("null")) {
            this.defaultValueNumeric = null;
        } else if ("GENERATED_BY_DEFAULT".equals(defaultValueNumeric)) {
            this.setAutoIncrement(true);
        } else {
            if (defaultValueNumeric.startsWith("(")) {
                defaultValueNumeric = defaultValueNumeric.replaceFirst("^\\(", "");
                defaultValueNumeric = defaultValueNumeric.replaceFirst("\\)$", "");
            }
            try {
                this.defaultValueNumeric = NumberFormat.getInstance(Locale.US).parse(defaultValueNumeric);
            }
            catch (ParseException e) {
                this.defaultValueComputed = new DatabaseFunction(defaultValueNumeric);
            }
        }
        return this;
    }

    public Date getDefaultValueDate() {
        return this.defaultValueDate;
    }

    public ColumnConfig setDefaultValueDate(String defaultValueDate) {
        if ((defaultValueDate = StringUtils.trimToNull(defaultValueDate)) == null || defaultValueDate.equalsIgnoreCase("null")) {
            this.defaultValueDate = null;
        } else {
            try {
                this.defaultValueDate = new ISODateFormat().parse(defaultValueDate);
            }
            catch (ParseException e) {
                this.defaultValueComputed = new DatabaseFunction(defaultValueDate);
            }
        }
        return this;
    }

    public ColumnConfig setDefaultValueDate(Date defaultValueDate) {
        this.defaultValueDate = defaultValueDate;
        return this;
    }

    public Boolean getDefaultValueBoolean() {
        return this.defaultValueBoolean;
    }

    public ColumnConfig setDefaultValueBoolean(Boolean defaultValueBoolean) {
        this.defaultValueBoolean = defaultValueBoolean;
        return this;
    }

    public ColumnConfig setDefaultValueBoolean(String defaultValueBoolean) {
        if ((defaultValueBoolean = StringUtils.trimToNull(defaultValueBoolean)) == null || defaultValueBoolean.equalsIgnoreCase("null")) {
            this.defaultValueBoolean = null;
        } else if (defaultValueBoolean.equalsIgnoreCase("true") || defaultValueBoolean.equals("1")) {
            this.defaultValueBoolean = true;
        } else if (defaultValueBoolean.equalsIgnoreCase("false") || defaultValueBoolean.equals("0")) {
            this.defaultValueBoolean = false;
        } else {
            this.defaultValueComputed = new DatabaseFunction(defaultValueBoolean);
        }
        return this;
    }

    public DatabaseFunction getDefaultValueComputed() {
        return this.defaultValueComputed;
    }

    public ColumnConfig setDefaultValueComputed(DatabaseFunction defaultValueComputed) {
        this.defaultValueComputed = defaultValueComputed;
        return this;
    }

    public Object getDefaultValueObject() {
        if (this.getDefaultValue() != null) {
            return this.getDefaultValue();
        }
        if (this.getDefaultValueBoolean() != null) {
            return this.getDefaultValueBoolean();
        }
        if (this.getDefaultValueNumeric() != null) {
            return this.getDefaultValueNumeric();
        }
        if (this.getDefaultValueDate() != null) {
            return this.getDefaultValueDate();
        }
        if (this.getDefaultValueComputed() != null) {
            return this.getDefaultValueComputed();
        }
        if (this.getDefaultValueSequenceNext() != null) {
            return this.getDefaultValueSequenceNext();
        }
        return null;
    }

    public ConstraintsConfig getConstraints() {
        return this.constraints;
    }

    public ColumnConfig setConstraints(ConstraintsConfig constraints) {
        this.constraints = constraints;
        return this;
    }

    public Boolean isAutoIncrement() {
        return this.autoIncrement;
    }

    public ColumnConfig setAutoIncrement(Boolean autoIncrement) {
        this.autoIncrement = autoIncrement;
        return this;
    }

    public BigInteger getStartWith() {
        return this.startWith;
    }

    public ColumnConfig setStartWith(BigInteger startWith) {
        this.startWith = startWith;
        return this;
    }

    public BigInteger getIncrementBy() {
        return this.incrementBy;
    }

    public ColumnConfig setIncrementBy(BigInteger incrementBy) {
        this.incrementBy = incrementBy;
        return this;
    }

    public boolean hasDefaultValue() {
        return this.getDefaultValue() != null || this.getDefaultValueBoolean() != null || this.getDefaultValueDate() != null || this.getDefaultValueNumeric() != null || this.getDefaultValueComputed() != null || this.getDefaultValueSequenceNext() != null;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public ColumnConfig setRemarks(String remarks) {
        this.remarks = remarks;
        return this;
    }

    @Override
    public String getSerializedObjectName() {
        return "column";
    }

    public SequenceNextValueFunction getDefaultValueSequenceNext() {
        return this.defaultValueSequenceNext;
    }

    public ColumnConfig setDefaultValueSequenceNext(SequenceNextValueFunction defaultValueSequenceNext) {
        this.defaultValueSequenceNext = defaultValueSequenceNext;
        return this;
    }

    @Override
    public LiquibaseSerializable.SerializationType getSerializableFieldType(String field) {
        return LiquibaseSerializable.SerializationType.NAMED_FIELD;
    }

    @Override
    public String getSerializedObjectNamespace() {
        return "http://www.liquibase.org/xml/ns/dbchangelog";
    }

    @Override
    public void load(ParsedNode parsedNode, ResourceAccessor resourceAccessor) throws ParsedNodeException {
        String defaultValueSequenceNextString;
        String valueSequenceCurrentString;
        String valueSequenceNextString;
        this.name = parsedNode.getChildValue((String)null, "name", String.class);
        this.type = parsedNode.getChildValue((String)null, "type", String.class);
        this.encoding = parsedNode.getChildValue((String)null, "encoding", String.class);
        this.autoIncrement = parsedNode.getChildValue((String)null, "autoIncrement", Boolean.class);
        this.startWith = parsedNode.getChildValue((String)null, "startWith", BigInteger.class);
        this.incrementBy = parsedNode.getChildValue((String)null, "incrementBy", BigInteger.class);
        this.remarks = parsedNode.getChildValue((String)null, "remarks", String.class);
        this.value = parsedNode.getChildValue((String)null, "value", String.class);
        if (this.value == null) {
            this.value = StringUtils.trimToNull((String)parsedNode.getValue());
        }
        try {
            this.valueNumeric = parsedNode.getChildValue((String)null, "valueNumeric", Double.class);
        }
        catch (ParsedNodeException e) {
            this.valueComputed = new DatabaseFunction(parsedNode.getChildValue((String)null, "valueNumeric", String.class));
        }
        try {
            this.valueDate = parsedNode.getChildValue((String)null, "valueDate", Date.class);
        }
        catch (ParsedNodeException e) {
            this.valueComputed = new DatabaseFunction(parsedNode.getChildValue((String)null, "valueDate", String.class));
        }
        this.valueBoolean = parsedNode.getChildValue((String)null, "valueBoolean", Boolean.class);
        this.valueBlobFile = parsedNode.getChildValue((String)null, "valueBlobFile", String.class);
        this.valueClobFile = parsedNode.getChildValue((String)null, "valueClobFile", String.class);
        String valueComputedString = parsedNode.getChildValue((String)null, "valueComputed", String.class);
        if (valueComputedString != null) {
            this.valueComputed = new DatabaseFunction(valueComputedString);
        }
        if ((valueSequenceNextString = parsedNode.getChildValue((String)null, "valueSequenceNext", String.class)) != null) {
            this.valueSequenceNext = new SequenceNextValueFunction(valueSequenceNextString);
        }
        if ((valueSequenceCurrentString = parsedNode.getChildValue((String)null, "valueSequenceCurrent", String.class)) != null) {
            this.valueSequenceCurrent = new SequenceCurrentValueFunction(valueSequenceCurrentString);
        }
        this.defaultValue = parsedNode.getChildValue((String)null, "defaultValue", String.class);
        try {
            this.defaultValueNumeric = parsedNode.getChildValue((String)null, "defaultValueNumeric", Double.class);
        }
        catch (ParsedNodeException e) {
            this.defaultValueComputed = new DatabaseFunction(parsedNode.getChildValue((String)null, "defaultValueNumeric", String.class));
        }
        try {
            this.defaultValueDate = parsedNode.getChildValue((String)null, "defaultValueDate", Date.class);
        }
        catch (ParsedNodeException e) {
            this.defaultValueComputed = new DatabaseFunction(parsedNode.getChildValue((String)null, "defaultValueDate", String.class));
        }
        this.defaultValueBoolean = parsedNode.getChildValue((String)null, "defaultValueBoolean", Boolean.class);
        String defaultValueComputedString = parsedNode.getChildValue((String)null, "defaultValueComputed", String.class);
        if (defaultValueComputedString != null) {
            this.defaultValueComputed = new DatabaseFunction(defaultValueComputedString);
        }
        if ((defaultValueSequenceNextString = parsedNode.getChildValue((String)null, "defaultValueSequenceNext", String.class)) != null) {
            this.defaultValueSequenceNext = new SequenceNextValueFunction(defaultValueSequenceNextString);
        }
        this.loadConstraints(parsedNode.getChild(null, "constraints"));
    }

    protected void loadConstraints(ParsedNode constraintsNode) throws ParsedNodeException {
        if (constraintsNode == null) {
            return;
        }
        ConstraintsConfig constraints = new ConstraintsConfig();
        constraints.setNullable(constraintsNode.getChildValue((String)null, "nullable", Boolean.class));
        constraints.setPrimaryKey(constraintsNode.getChildValue((String)null, "primaryKey", Boolean.class));
        constraints.setPrimaryKeyName(constraintsNode.getChildValue((String)null, "primaryKeyName", String.class));
        constraints.setPrimaryKeyTablespace(constraintsNode.getChildValue((String)null, "primaryKeyTablespace", String.class));
        constraints.setReferences(constraintsNode.getChildValue((String)null, "references", String.class));
        constraints.setReferencedTableName(constraintsNode.getChildValue((String)null, "referencedTableName", String.class));
        constraints.setReferencedColumnNames(constraintsNode.getChildValue((String)null, "referencedColumnNames", String.class));
        constraints.setUnique(constraintsNode.getChildValue((String)null, "unique", Boolean.class));
        constraints.setUniqueConstraintName(constraintsNode.getChildValue((String)null, "uniqueConstraintName", String.class));
        constraints.setCheckConstraint(constraintsNode.getChildValue((String)null, "checkConstraint", String.class));
        constraints.setDeleteCascade(constraintsNode.getChildValue((String)null, "deleteCascade", Boolean.class));
        constraints.setForeignKeyName(constraintsNode.getChildValue((String)null, "foreignKeyName", String.class));
        constraints.setInitiallyDeferred(constraintsNode.getChildValue((String)null, "initiallyDeferred", Boolean.class));
        constraints.setDeferrable(constraintsNode.getChildValue((String)null, "deferrable", Boolean.class));
        this.setConstraints(constraints);
    }
}

