/*
 * Decompiled with CFR 0.152.
 */
package liquibase.datatype.core;

import java.sql.Time;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import liquibase.database.Database;
import liquibase.database.core.DB2Database;
import liquibase.database.core.DerbyDatabase;
import liquibase.database.core.InformixDatabase;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.MySQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.database.core.PostgresDatabase;
import liquibase.datatype.DataTypeInfo;
import liquibase.datatype.DatabaseDataType;
import liquibase.datatype.LiquibaseDataType;
import liquibase.exception.DatabaseException;
import liquibase.statement.DatabaseFunction;

@DataTypeInfo(name="time", aliases={"java.sql.Types.TIME", "java.sql.Time", "timetz"}, minParameters=0, maxParameters=0, priority=1)
public class TimeType
extends LiquibaseDataType {
    @Override
    public DatabaseDataType toDatabaseDataType(Database database) {
        if (database instanceof InformixDatabase) {
            return new DatabaseDataType("INTERVAL HOUR TO FRACTION", 5);
        }
        if (database instanceof MSSQLDatabase) {
            try {
                if (database.getDatabaseMajorVersion() <= 9) {
                    return new DatabaseDataType("DATETIME");
                }
            }
            catch (DatabaseException e) {
                // empty catch block
            }
        }
        if (database instanceof MySQLDatabase) {
            boolean supportsParameters = true;
            try {
                supportsParameters = database.getDatabaseMajorVersion() >= 5 && database.getDatabaseMinorVersion() >= 6 && ((MySQLDatabase)database).getDatabasePatchVersion() >= 4;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (supportsParameters) {
                return new DatabaseDataType(this.getName(), this.getParameters());
            }
            return new DatabaseDataType(this.getName());
        }
        if (database instanceof OracleDatabase) {
            return new DatabaseDataType("DATE");
        }
        if (database instanceof PostgresDatabase) {
            String rawDefinition = this.getRawDefinition().toLowerCase();
            if (rawDefinition.contains("tz") || rawDefinition.contains("with time zone")) {
                return new DatabaseDataType("TIME WITH TIME ZONE");
            }
            return new DatabaseDataType("TIME WITHOUT TIME ZONE");
        }
        return new DatabaseDataType(this.getName());
    }

    @Override
    public String objectToSql(Object value, Database database) {
        if (value == null || value.toString().equalsIgnoreCase("null")) {
            return null;
        }
        if (value instanceof DatabaseFunction) {
            return database.generateDatabaseFunctionValue((DatabaseFunction)value);
        }
        if (value instanceof Time) {
            return database.getTimeLiteral((Time)value);
        }
        return "'" + ((String)value).replaceAll("'", "''") + "'";
    }

    @Override
    public Object sqlToObject(String value, Database database) {
        if (this.zeroTime(value)) {
            return value;
        }
        if (database instanceof DB2Database) {
            return value.replaceFirst("^\"SYSIBM\".\"TIME\"\\('", "").replaceFirst("'\\)", "");
        }
        if (database instanceof DerbyDatabase) {
            return value.replaceFirst("^TIME\\('", "").replaceFirst("'\\)", "");
        }
        try {
            DateFormat timeFormat = this.getTimeFormat(database);
            if (database instanceof OracleDatabase && value.matches("to_date\\('\\d+:\\d+:\\d+', 'HH24:MI:SS'\\)")) {
                timeFormat = new SimpleDateFormat("HH:mm:s");
                value = value.replaceFirst(".*?'", "").replaceFirst("',.*", "");
            }
            return new Time(timeFormat.parse(value).getTime());
        }
        catch (ParseException e) {
            return new DatabaseFunction(value);
        }
    }

    private boolean zeroTime(String stringVal) {
        return stringVal.replace("-", "").replace(":", "").replace(" ", "").replace("0", "").equals("");
    }

    protected DateFormat getTimeFormat(Database database) {
        if (database instanceof DB2Database) {
            return new SimpleDateFormat("HH.mm.ss");
        }
        return new SimpleDateFormat("HH:mm:ss");
    }
}

