/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.managers;

import java.security.Key;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import javax.crypto.Mac;
import org.keycloak.models.ClientSessionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.util.Base64Url;
import org.keycloak.util.Time;

public class ClientSessionCode {
    public static final String ACTION_KEY = "action_key";
    private static final byte[] HASH_SEPERATOR = "//".getBytes();
    private final RealmModel realm;
    private final ClientSessionModel clientSession;

    public ClientSessionCode(RealmModel realm, ClientSessionModel clientSession) {
        this.realm = realm;
        this.clientSession = clientSession;
    }

    public static ClientSessionCode parse(String code, KeycloakSession session) {
        try {
            String[] parts = code.split("\\.");
            String id = parts[1];
            ClientSessionModel clientSession = session.sessions().getClientSession(id);
            if (clientSession == null) {
                return null;
            }
            String hash = ClientSessionCode.createHash(clientSession.getRealm(), clientSession);
            if (!hash.equals(parts[0])) {
                return null;
            }
            return new ClientSessionCode(clientSession.getRealm(), clientSession);
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    public static ClientSessionCode parse(String code, KeycloakSession session, RealmModel realm) {
        try {
            String[] parts = code.split("\\.");
            String id = parts[1];
            ClientSessionModel clientSession = session.sessions().getClientSession(realm, id);
            if (clientSession == null) {
                return null;
            }
            String hash = ClientSessionCode.createHash(realm, clientSession);
            if (!hash.equals(parts[0])) {
                return null;
            }
            return new ClientSessionCode(realm, clientSession);
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    public ClientSessionModel getClientSession() {
        return this.clientSession;
    }

    public boolean isValid(ClientSessionModel.Action requestedAction) {
        ClientSessionModel.Action action = this.clientSession.getAction();
        if (action == null) {
            return false;
        }
        int timestamp = this.clientSession.getTimestamp();
        if (!action.equals((Object)requestedAction)) {
            return false;
        }
        int lifespan = action.equals((Object)ClientSessionModel.Action.CODE_TO_TOKEN) ? this.realm.getAccessCodeLifespan() : this.realm.getAccessCodeLifespanUserAction();
        return timestamp + lifespan > Time.currentTime();
    }

    public Set<RoleModel> getRequestedRoles() {
        HashSet<RoleModel> requestedRoles = new HashSet<RoleModel>();
        for (String roleId : this.clientSession.getRoles()) {
            RoleModel role = this.realm.getRoleById(roleId);
            if (role == null) continue;
            requestedRoles.add(this.realm.getRoleById(roleId));
        }
        return requestedRoles;
    }

    public void setAction(ClientSessionModel.Action action) {
        this.clientSession.setAction(action);
        this.clientSession.setNote(ACTION_KEY, UUID.randomUUID().toString());
        this.clientSession.setTimestamp(Time.currentTime());
    }

    public void setRequiredAction(UserModel.RequiredAction requiredAction) {
        this.setAction(this.convertToAction(requiredAction));
    }

    private ClientSessionModel.Action convertToAction(UserModel.RequiredAction requiredAction) {
        switch (requiredAction) {
            case CONFIGURE_TOTP: {
                return ClientSessionModel.Action.CONFIGURE_TOTP;
            }
            case UPDATE_PASSWORD: {
                return ClientSessionModel.Action.UPDATE_PASSWORD;
            }
            case UPDATE_PROFILE: {
                return ClientSessionModel.Action.UPDATE_PROFILE;
            }
            case VERIFY_EMAIL: {
                return ClientSessionModel.Action.VERIFY_EMAIL;
            }
        }
        throw new IllegalArgumentException("Unknown required action " + requiredAction);
    }

    public String getCode() {
        return ClientSessionCode.generateCode(this.realm, this.clientSession);
    }

    private static String generateCode(RealmModel realm, ClientSessionModel clientSession) {
        String hash = ClientSessionCode.createHash(realm, clientSession);
        StringBuilder sb = new StringBuilder();
        sb.append(hash);
        sb.append(".");
        sb.append(clientSession.getId());
        return sb.toString();
    }

    private static String createHash(RealmModel realm, ClientSessionModel clientSession) {
        try {
            Key codeSecretKey = realm.getCodeSecretKey();
            Mac mac = Mac.getInstance(codeSecretKey.getAlgorithm());
            mac.init(codeSecretKey);
            mac.update(clientSession.getId().getBytes());
            mac.update(HASH_SEPERATOR);
            mac.update(clientSession.getNote(ACTION_KEY).getBytes());
            return Base64Url.encode((byte[])mac.doFinal());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

