/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.managers;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.UriBuilder;
import org.apache.http.client.HttpClient;
import org.jboss.logging.Logger;
import org.jboss.resteasy.client.ClientRequest;
import org.jboss.resteasy.client.ClientResponse;
import org.jboss.resteasy.client.core.executors.ApacheHttpClient4Executor;
import org.keycloak.TokenIdGenerator;
import org.keycloak.models.ApplicationModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientSessionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.oidc.TokenManager;
import org.keycloak.representations.adapters.action.GlobalRequestResult;
import org.keycloak.representations.adapters.action.LogoutAction;
import org.keycloak.representations.adapters.action.PushNotBeforeAction;
import org.keycloak.representations.adapters.action.TestAvailabilityAction;
import org.keycloak.services.managers.ApplicationManager;
import org.keycloak.services.util.HttpClientBuilder;
import org.keycloak.services.util.ResolveRelative;
import org.keycloak.util.KeycloakUriBuilder;
import org.keycloak.util.MultivaluedHashMap;
import org.keycloak.util.StringPropertyReplacer;
import org.keycloak.util.Time;

public class ResourceAdminManager {
    protected static Logger logger = Logger.getLogger(ResourceAdminManager.class);
    private static final String APPLICATION_SESSION_HOST_PROPERTY = "${application.session.host}";

    public static ApacheHttpClient4Executor createExecutor() {
        HttpClient client = new HttpClientBuilder().disableTrustManager().build();
        return new ApacheHttpClient4Executor(client);
    }

    public static String getManagementUrl(URI requestUri, ApplicationModel application) {
        String mgmtUrl = application.getManagementUrl();
        if (mgmtUrl == null || mgmtUrl.equals("")) {
            return null;
        }
        String absoluteURI = ResolveRelative.resolveRelativeUri(requestUri, mgmtUrl);
        return StringPropertyReplacer.replaceProperties((String)absoluteURI);
    }

    private List<String> getAllManagementUrls(URI requestUri, ApplicationModel application) {
        String baseMgmtUrl = ResourceAdminManager.getManagementUrl(requestUri, application);
        if (baseMgmtUrl == null) {
            return Collections.emptyList();
        }
        Set<String> registeredNodesHosts = new ApplicationManager().validateRegisteredNodes(application);
        if (registeredNodesHosts.isEmpty()) {
            return Arrays.asList(baseMgmtUrl);
        }
        LinkedList<String> result = new LinkedList<String>();
        KeycloakUriBuilder uriBuilder = KeycloakUriBuilder.fromUri((String)baseMgmtUrl);
        for (String nodeHost : registeredNodesHosts) {
            String currentNodeUri = uriBuilder.clone().host(nodeHost).build(new Object[0]).toString();
            result.add(currentNodeUri);
        }
        return result;
    }

    public void logoutUser(URI requestUri, RealmModel realm, UserModel user, KeycloakSession keycloakSession) {
        List userSessions = keycloakSession.sessions().getUserSessions(realm, user);
        this.logoutUserSessions(requestUri, realm, userSessions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void logoutUserSessions(URI requestUri, RealmModel realm, List<UserSessionModel> userSessions) {
        ApacheHttpClient4Executor executor = ResourceAdminManager.createExecutor();
        try {
            MultivaluedHashMap clientSessions = new MultivaluedHashMap();
            for (UserSessionModel userSession : userSessions) {
                this.putClientSessions((MultivaluedHashMap<ApplicationModel, ClientSessionModel>)clientSessions, userSession);
            }
            logger.debugv("logging out {0} resources ", (Object)clientSessions.size());
            for (Map.Entry entry : clientSessions.entrySet()) {
                this.logoutClientSessions(requestUri, realm, (ApplicationModel)entry.getKey(), (List)entry.getValue(), executor);
            }
        }
        finally {
            executor.getHttpClient().getConnectionManager().shutdown();
        }
    }

    private void putClientSessions(MultivaluedHashMap<ApplicationModel, ClientSessionModel> clientSessions, UserSessionModel userSession) {
        for (ClientSessionModel clientSession : userSession.getClientSessions()) {
            ClientModel client = clientSession.getClient();
            if (!(client instanceof ApplicationModel)) continue;
            clientSessions.add((Object)((ApplicationModel)client), (Object)clientSession);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logoutSession(URI requestUri, RealmModel realm, UserSessionModel session) {
        ApacheHttpClient4Executor executor = ResourceAdminManager.createExecutor();
        try {
            MultivaluedHashMap clientSessions = new MultivaluedHashMap();
            this.putClientSessions((MultivaluedHashMap<ApplicationModel, ClientSessionModel>)clientSessions, session);
            logger.debugv("logging out {0} resources ", (Object)clientSessions.size());
            for (Map.Entry entry : clientSessions.entrySet()) {
                this.logoutClientSessions(requestUri, realm, (ApplicationModel)entry.getKey(), (List)entry.getValue(), executor);
            }
        }
        finally {
            executor.getHttpClient().getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logoutUserFromApplication(URI requestUri, RealmModel realm, ApplicationModel resource, UserModel user, KeycloakSession session) {
        ApacheHttpClient4Executor executor = ResourceAdminManager.createExecutor();
        try {
            List userSessions = session.sessions().getUserSessions(realm, user);
            List ourAppClientSessions = null;
            if (userSessions != null) {
                MultivaluedHashMap clientSessions = new MultivaluedHashMap();
                for (UserSessionModel userSession : userSessions) {
                    this.putClientSessions((MultivaluedHashMap<ApplicationModel, ClientSessionModel>)clientSessions, userSession);
                }
                ourAppClientSessions = (List)clientSessions.get((Object)resource);
            }
            this.logoutClientSessions(requestUri, realm, resource, ourAppClientSessions, executor);
        }
        finally {
            executor.getHttpClient().getConnectionManager().shutdown();
        }
    }

    public boolean logoutClientSession(URI requestUri, RealmModel realm, ApplicationModel resource, ClientSessionModel clientSession, ApacheHttpClient4Executor client) {
        return this.logoutClientSessions(requestUri, realm, resource, Arrays.asList(clientSession), client);
    }

    protected boolean logoutClientSessions(URI requestUri, RealmModel realm, ApplicationModel resource, List<ClientSessionModel> clientSessions, ApacheHttpClient4Executor client) {
        String managementUrl = ResourceAdminManager.getManagementUrl(requestUri, resource);
        if (managementUrl != null) {
            String host;
            MultivaluedHashMap adapterSessionIds = null;
            if (clientSessions != null && clientSessions.size() > 0) {
                adapterSessionIds = new MultivaluedHashMap();
                for (ClientSessionModel clientSession : clientSessions) {
                    String adapterSessionId = clientSession.getNote("application_session_state");
                    if (adapterSessionId == null) continue;
                    host = clientSession.getNote("application_session_host");
                    adapterSessionIds.add((Object)host, (Object)adapterSessionId);
                }
            }
            if (adapterSessionIds == null || adapterSessionIds.isEmpty()) {
                logger.debugv("Can't logout {0}: no logged adapter sessions", (Object)resource.getName());
                return false;
            }
            if (managementUrl.contains(APPLICATION_SESSION_HOST_PROPERTY)) {
                boolean allPassed = true;
                for (Map.Entry entry : adapterSessionIds.entrySet()) {
                    String currentHostMgmtUrl;
                    host = (String)entry.getKey();
                    List sessionIds = (List)entry.getValue();
                    allPassed = this.sendLogoutRequest(realm, resource, sessionIds, client, 0, currentHostMgmtUrl = managementUrl.replace(APPLICATION_SESSION_HOST_PROPERTY, host)) && allPassed;
                }
                return allPassed;
            }
            ArrayList<String> allSessionIds = new ArrayList<String>();
            for (List currentIds : adapterSessionIds.values()) {
                allSessionIds.addAll(currentIds);
            }
            return this.sendLogoutRequest(realm, resource, allSessionIds, client, 0, managementUrl);
        }
        logger.debugv("Can't logout {0}: no management url", (Object)resource.getName());
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GlobalRequestResult logoutAll(URI requestUri, RealmModel realm) {
        ApacheHttpClient4Executor executor = ResourceAdminManager.createExecutor();
        try {
            realm.setNotBefore(Time.currentTime());
            List resources = realm.getApplications();
            logger.debugv("logging out {0} resources ", (Object)resources.size());
            GlobalRequestResult finalResult = new GlobalRequestResult();
            for (ApplicationModel resource : resources) {
                GlobalRequestResult currentResult = this.logoutApplication(requestUri, realm, resource, executor, realm.getNotBefore());
                finalResult.addAll(currentResult);
            }
            GlobalRequestResult globalRequestResult = finalResult;
            return globalRequestResult;
        }
        finally {
            executor.getHttpClient().getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GlobalRequestResult logoutApplication(URI requestUri, RealmModel realm, ApplicationModel resource) {
        ApacheHttpClient4Executor executor = ResourceAdminManager.createExecutor();
        try {
            resource.setNotBefore(Time.currentTime());
            GlobalRequestResult globalRequestResult = this.logoutApplication(requestUri, realm, resource, executor, resource.getNotBefore());
            return globalRequestResult;
        }
        finally {
            executor.getHttpClient().getConnectionManager().shutdown();
        }
    }

    protected GlobalRequestResult logoutApplication(URI requestUri, RealmModel realm, ApplicationModel resource, ApacheHttpClient4Executor executor, int notBefore) {
        List<String> mgmtUrls = this.getAllManagementUrls(requestUri, resource);
        if (mgmtUrls.isEmpty()) {
            logger.debug((Object)("No management URL or no registered cluster nodes for the application " + resource.getName()));
            return new GlobalRequestResult();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Send logoutApplication for URLs: " + mgmtUrls));
        }
        GlobalRequestResult result = new GlobalRequestResult();
        for (String mgmtUrl : mgmtUrls) {
            if (this.sendLogoutRequest(realm, resource, null, executor, notBefore, mgmtUrl)) {
                result.addSuccessRequest(mgmtUrl);
                continue;
            }
            result.addFailedRequest(mgmtUrl);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean sendLogoutRequest(RealmModel realm, ApplicationModel resource, List<String> adapterSessionIds, ApacheHttpClient4Executor client, int notBefore, String managementUrl) {
        ClientResponse response;
        LogoutAction adminAction = new LogoutAction(TokenIdGenerator.generateId(), Time.currentTime() + 30, resource.getName(), adapterSessionIds, notBefore);
        String token = new TokenManager().encodeToken(realm, adminAction);
        if (logger.isDebugEnabled()) {
            logger.debugv("logout resource {0} url: {1} sessionIds: " + adapterSessionIds, (Object)resource.getName(), (Object)managementUrl);
        }
        ClientRequest request = client.createRequest(UriBuilder.fromUri((String)managementUrl).path("k_logout").build(new Object[0]).toString());
        try {
            response = request.body(MediaType.TEXT_PLAIN_TYPE, (Object)token).post();
        }
        catch (Exception e) {
            logger.warn((Object)("Logout for application '" + resource.getName() + "' failed"), (Throwable)e);
            return false;
        }
        try {
            boolean success = response.getStatus() == 204 || response.getStatus() == 200;
            logger.debugf("logout success for %s: %s", (Object)managementUrl, (Object)success);
            boolean bl = success;
            return bl;
        }
        finally {
            response.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GlobalRequestResult pushRealmRevocationPolicy(URI requestUri, RealmModel realm) {
        ApacheHttpClient4Executor executor = ResourceAdminManager.createExecutor();
        try {
            GlobalRequestResult finalResult = new GlobalRequestResult();
            for (ApplicationModel application : realm.getApplications()) {
                GlobalRequestResult currentResult = this.pushRevocationPolicy(requestUri, realm, application, realm.getNotBefore(), executor);
                finalResult.addAll(currentResult);
            }
            GlobalRequestResult globalRequestResult = finalResult;
            return globalRequestResult;
        }
        finally {
            executor.getHttpClient().getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GlobalRequestResult pushApplicationRevocationPolicy(URI requestUri, RealmModel realm, ApplicationModel application) {
        ApacheHttpClient4Executor executor = ResourceAdminManager.createExecutor();
        try {
            GlobalRequestResult globalRequestResult = this.pushRevocationPolicy(requestUri, realm, application, application.getNotBefore(), executor);
            return globalRequestResult;
        }
        finally {
            executor.getHttpClient().getConnectionManager().shutdown();
        }
    }

    protected GlobalRequestResult pushRevocationPolicy(URI requestUri, RealmModel realm, ApplicationModel resource, int notBefore, ApacheHttpClient4Executor executor) {
        List<String> mgmtUrls = this.getAllManagementUrls(requestUri, resource);
        if (mgmtUrls.isEmpty()) {
            logger.debugf("No management URL or no registered cluster nodes for the application %s", (Object)resource.getName());
            return new GlobalRequestResult();
        }
        if (logger.isDebugEnabled()) {
            logger.info((Object)("Sending push revocation to URLS: " + mgmtUrls));
        }
        GlobalRequestResult result = new GlobalRequestResult();
        for (String mgmtUrl : mgmtUrls) {
            if (this.sendPushRevocationPolicyRequest(realm, resource, notBefore, executor, mgmtUrl)) {
                result.addSuccessRequest(mgmtUrl);
                continue;
            }
            result.addFailedRequest(mgmtUrl);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean sendPushRevocationPolicyRequest(RealmModel realm, ApplicationModel resource, int notBefore, ApacheHttpClient4Executor client, String managementUrl) {
        ClientResponse response;
        PushNotBeforeAction adminAction = new PushNotBeforeAction(TokenIdGenerator.generateId(), Time.currentTime() + 30, resource.getName(), notBefore);
        String token = new TokenManager().encodeToken(realm, adminAction);
        logger.infov("pushRevocation resource: {0} url: {1}", (Object)resource.getName(), (Object)managementUrl);
        ClientRequest request = client.createRequest(UriBuilder.fromUri((String)managementUrl).path("k_push_not_before").build(new Object[0]).toString());
        try {
            response = request.body(MediaType.TEXT_PLAIN_TYPE, (Object)token).post();
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to send revocation request", (Throwable)e);
            return false;
        }
        try {
            boolean success = response.getStatus() == 204 || response.getStatus() == 200;
            logger.debugf("pushRevocation success for %s: %s", (Object)managementUrl, (Object)success);
            boolean bl = success;
            return bl;
        }
        finally {
            response.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GlobalRequestResult testNodesAvailability(URI requestUri, RealmModel realm, ApplicationModel application) {
        List<String> mgmtUrls = this.getAllManagementUrls(requestUri, application);
        if (mgmtUrls.isEmpty()) {
            logger.debug((Object)("No management URL or no registered cluster nodes for the application " + application.getName()));
            return new GlobalRequestResult();
        }
        ApacheHttpClient4Executor executor = ResourceAdminManager.createExecutor();
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Sending test nodes availability: " + mgmtUrls));
            }
            GlobalRequestResult result = new GlobalRequestResult();
            for (String mgmtUrl : mgmtUrls) {
                if (this.sendTestNodeAvailabilityRequest(realm, application, executor, mgmtUrl)) {
                    result.addSuccessRequest(mgmtUrl);
                    continue;
                }
                result.addFailedRequest(mgmtUrl);
            }
            GlobalRequestResult globalRequestResult = result;
            return globalRequestResult;
        }
        finally {
            executor.getHttpClient().getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean sendTestNodeAvailabilityRequest(RealmModel realm, ApplicationModel application, ApacheHttpClient4Executor client, String managementUrl) {
        ClientResponse response;
        TestAvailabilityAction adminAction = new TestAvailabilityAction(TokenIdGenerator.generateId(), Time.currentTime() + 30, application.getName());
        String token = new TokenManager().encodeToken(realm, adminAction);
        logger.debugv("testNodes availability resource: {0} url: {1}", (Object)application.getName(), (Object)managementUrl);
        ClientRequest request = client.createRequest(UriBuilder.fromUri((String)managementUrl).path("k_test_available").build(new Object[0]).toString());
        try {
            response = request.body(MediaType.TEXT_PLAIN_TYPE, (Object)token).post();
        }
        catch (Exception e) {
            logger.warn((Object)("Availability test failed for uri '" + managementUrl + "'"), (Throwable)e);
            return false;
        }
        try {
            boolean success = response.getStatus() == 204 || response.getStatus() == 200;
            logger.debugf("testAvailability success for %s: %s", (Object)managementUrl, (Object)success);
            boolean bl = success;
            return bl;
        }
        finally {
            response.releaseConnection();
        }
    }
}

