/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database;

import java.io.File;
import java.io.FileInputStream;
import java.sql.Connection;
import java.sql.Driver;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.SortedSet;
import java.util.TreeSet;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.InternalDatabase;
import liquibase.database.OfflineConnection;
import liquibase.database.core.UnsupportedDatabase;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.logging.LogFactory;
import liquibase.resource.ResourceAccessor;
import liquibase.servicelocator.ServiceLocator;
import liquibase.util.StringUtils;

public class DatabaseFactory {
    private static DatabaseFactory instance;
    private Map<String, SortedSet<Database>> implementedDatabases = new HashMap<String, SortedSet<Database>>();
    private Map<String, SortedSet<Database>> internalDatabases = new HashMap<String, SortedSet<Database>>();

    private DatabaseFactory() {
        try {
            Class<Database>[] classes;
            for (Class<Database> clazz : classes = ServiceLocator.getInstance().findClasses(Database.class)) {
                this.register(clazz.getConstructor(new Class[0]).newInstance(new Object[0]));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static DatabaseFactory getInstance() {
        if (instance == null) {
            instance = new DatabaseFactory();
        }
        return instance;
    }

    public static void reset() {
        instance = new DatabaseFactory();
    }

    public static void setInstance(DatabaseFactory databaseFactory) {
        instance = databaseFactory;
    }

    public List<Database> getImplementedDatabases() {
        ArrayList<Database> returnList = new ArrayList<Database>();
        for (SortedSet<Database> set : this.implementedDatabases.values()) {
            returnList.add((Database)set.iterator().next());
        }
        return returnList;
    }

    public List<Database> getInternalDatabases() {
        ArrayList<Database> returnList = new ArrayList<Database>();
        for (SortedSet<Database> set : this.internalDatabases.values()) {
            returnList.add((Database)set.iterator().next());
        }
        return returnList;
    }

    public void register(Database database) {
        Map<String, SortedSet<Database>> map = null;
        map = database instanceof InternalDatabase ? this.internalDatabases : this.implementedDatabases;
        if (!map.containsKey(database.getShortName())) {
            map.put(database.getShortName(), new TreeSet<Database>((SortedSet<Database>)new TreeSet<Database>(new DatabaseComparator())));
        }
        map.get(database.getShortName()).add(database);
    }

    public Database findCorrectDatabaseImplementation(DatabaseConnection connection) throws DatabaseException {
        Database returnDatabase;
        TreeSet<Database> foundDatabases = new TreeSet<Database>(new DatabaseComparator());
        for (Database implementedDatabase : this.getImplementedDatabases()) {
            if (connection instanceof OfflineConnection) {
                if (!((OfflineConnection)connection).isCorrectDatabaseImplementation(implementedDatabase)) continue;
                foundDatabases.add(implementedDatabase);
                continue;
            }
            if (!implementedDatabase.isCorrectDatabaseImplementation(connection)) continue;
            foundDatabases.add(implementedDatabase);
        }
        if (foundDatabases.size() == 0) {
            LogFactory.getLogger().warning("Unknown database: " + connection.getDatabaseProductName());
            UnsupportedDatabase unsupportedDB = new UnsupportedDatabase();
            unsupportedDB.setConnection(connection);
            return unsupportedDB;
        }
        try {
            returnDatabase = (Database)((Database)foundDatabases.iterator().next()).getClass().newInstance();
        }
        catch (Exception e) {
            throw new UnexpectedLiquibaseException(e);
        }
        returnDatabase.setConnection(connection);
        return returnDatabase;
    }

    public Database openDatabase(String url, String username, String password, ResourceAccessor resourceAccessor) throws DatabaseException {
        return this.openDatabase(url, username, password, null, null, null, resourceAccessor);
    }

    public Database openDatabase(String url, String username, String password, String driver, String databaseClass, String driverPropertiesFile, ResourceAccessor resourceAccessor) throws DatabaseException {
        return this.findCorrectDatabaseImplementation(this.openConnection(url, username, password, driver, databaseClass, driverPropertiesFile, resourceAccessor));
    }

    public DatabaseConnection openConnection(String url, String username, String password, ResourceAccessor resourceAccessor) throws DatabaseException {
        return this.openConnection(url, username, password, null, null, null, resourceAccessor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatabaseConnection openConnection(String url, String username, String password, String driver, String databaseClass, String driverPropertiesFile, ResourceAccessor resourceAccessor) throws DatabaseException {
        if (url.startsWith("offline:")) {
            return new OfflineConnection(url);
        }
        if ((driver = StringUtils.trimToNull(driver)) == null) {
            driver = DatabaseFactory.getInstance().findDefaultDriver(url);
        }
        try {
            Connection connection;
            Driver driverObject;
            DatabaseFactory databaseFactory = DatabaseFactory.getInstance();
            if (databaseClass != null) {
                databaseFactory.clearRegistry();
                databaseFactory.register((Database)Class.forName(databaseClass, true, resourceAccessor.toClassLoader()).newInstance());
            }
            try {
                if (driver == null) {
                    driver = databaseFactory.findDefaultDriver(url);
                }
                if (driver == null) {
                    throw new RuntimeException("Driver class was not specified and could not be determined from the url (" + url + ")");
                }
                driverObject = (Driver)Class.forName(driver, true, resourceAccessor.toClassLoader()).newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot find database driver: " + e.getMessage());
            }
            Properties driverProperties = new Properties();
            if (username != null) {
                driverProperties.put("user", username);
            }
            if (password != null) {
                driverProperties.put("password", password);
            }
            if (null != driverPropertiesFile) {
                File propertiesFile = new File(driverPropertiesFile);
                if (propertiesFile.exists()) {
                    FileInputStream inputStream = new FileInputStream(propertiesFile);
                    try {
                        driverProperties.load(inputStream);
                    }
                    finally {
                        inputStream.close();
                    }
                } else {
                    throw new RuntimeException("Can't open JDBC Driver specific properties from the file: '" + driverPropertiesFile + "'");
                }
            }
            if ((connection = driverObject.connect(url, driverProperties)) == null) {
                throw new DatabaseException("Connection could not be created to " + url + " with driver " + driverObject.getClass().getName() + ".  Possibly the wrong driver for the given database URL");
            }
            return new JdbcConnection(connection);
        }
        catch (Exception e) {
            throw new DatabaseException(e);
        }
    }

    public String findDefaultDriver(String url) {
        for (Database database : this.getImplementedDatabases()) {
            String defaultDriver = database.getDefaultDriver(url);
            if (defaultDriver == null) continue;
            return defaultDriver;
        }
        return null;
    }

    public void clearRegistry() {
        this.implementedDatabases.clear();
    }

    public Database getDatabase(String shortName) {
        if (!this.implementedDatabases.containsKey(shortName)) {
            return null;
        }
        return (Database)this.implementedDatabases.get(shortName).iterator().next();
    }

    private static class DatabaseComparator
    implements Comparator<Database> {
        private DatabaseComparator() {
        }

        @Override
        public int compare(Database o1, Database o2) {
            return -1 * new Integer(o1.getPriority()).compareTo(o2.getPriority());
        }
    }
}

