/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change;

import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import liquibase.change.Change;
import liquibase.change.ChangeFactory;
import liquibase.change.ChangeMetaData;
import liquibase.change.ChangeParameterMetaData;
import liquibase.change.ChangeStatus;
import liquibase.change.ChangeWithColumns;
import liquibase.change.CheckSum;
import liquibase.change.ColumnConfig;
import liquibase.change.DatabaseChange;
import liquibase.change.DatabaseChangeNote;
import liquibase.change.DatabaseChangeProperty;
import liquibase.changelog.ChangeSet;
import liquibase.database.Database;
import liquibase.exception.LiquibaseException;
import liquibase.exception.RollbackImpossibleException;
import liquibase.exception.SetupException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.exception.ValidationErrors;
import liquibase.exception.Warnings;
import liquibase.parser.core.ParsedNode;
import liquibase.parser.core.ParsedNodeException;
import liquibase.resource.ResourceAccessor;
import liquibase.serializer.LiquibaseSerializable;
import liquibase.serializer.core.string.StringChangeLogSerializer;
import liquibase.sqlgenerator.SqlGeneratorFactory;
import liquibase.statement.SqlStatement;
import liquibase.structure.DatabaseObject;
import liquibase.util.StringUtils;

public abstract class AbstractChange
implements Change {
    private ResourceAccessor resourceAccessor;
    private ChangeSet changeSet;

    @Override
    public void finishInitialization() throws SetupException {
    }

    @Override
    public ChangeMetaData createChangeMetaData() {
        try {
            DatabaseChange databaseChange = this.getClass().getAnnotation(DatabaseChange.class);
            if (databaseChange == null) {
                throw new UnexpectedLiquibaseException("No @DatabaseChange annotation for " + this.getClass().getName());
            }
            HashSet<ChangeParameterMetaData> params = new HashSet<ChangeParameterMetaData>();
            for (PropertyDescriptor property : Introspector.getBeanInfo(this.getClass()).getPropertyDescriptors()) {
                DatabaseChangeProperty annotation;
                if (this.isInvalidProperty(property)) continue;
                Method readMethod = property.getReadMethod();
                Method writeMethod = property.getWriteMethod();
                if (readMethod == null) {
                    try {
                        readMethod = this.getClass().getMethod("is" + StringUtils.upperCaseFirst(property.getName()), new Class[0]);
                    }
                    catch (Exception ignore) {
                        // empty catch block
                    }
                }
                if (readMethod == null || writeMethod == null || (annotation = readMethod.getAnnotation(DatabaseChangeProperty.class)) != null && !annotation.isChangeProperty()) continue;
                params.add(this.createChangeParameterMetadata(property.getDisplayName()));
            }
            HashMap<String, String> notes = new HashMap<String, String>();
            for (DatabaseChangeNote note : databaseChange.databaseNotes()) {
                notes.put(note.database(), note.notes());
            }
            return new ChangeMetaData(databaseChange.name(), databaseChange.description(), databaseChange.priority(), databaseChange.appliesTo(), notes, params);
        }
        catch (Throwable e) {
            throw new UnexpectedLiquibaseException(e);
        }
    }

    protected boolean isInvalidProperty(PropertyDescriptor property) {
        return property.getDisplayName().equals("metaClass");
    }

    protected ChangeParameterMetaData createChangeParameterMetadata(String parameterName) {
        try {
            String displayName = parameterName.replaceAll("([A-Z])", " $1");
            displayName = displayName.substring(0, 1).toUpperCase() + displayName.substring(1);
            PropertyDescriptor property = null;
            for (PropertyDescriptor prop : Introspector.getBeanInfo(this.getClass()).getPropertyDescriptors()) {
                if (!prop.getDisplayName().equals(parameterName)) continue;
                property = prop;
                break;
            }
            if (property == null) {
                throw new UnexpectedLiquibaseException("Could not find property " + parameterName);
            }
            Method readMethod = property.getReadMethod();
            if (readMethod == null) {
                readMethod = this.getClass().getMethod("is" + StringUtils.upperCaseFirst(property.getName()), new Class[0]);
            }
            Type type = readMethod.getGenericReturnType();
            DatabaseChangeProperty changePropertyAnnotation = readMethod.getAnnotation(DatabaseChangeProperty.class);
            String mustEqualExisting = this.createMustEqualExistingMetaData(parameterName, changePropertyAnnotation);
            String description = this.createDescriptionMetaData(parameterName, changePropertyAnnotation);
            Map<String, Object> examples = this.createExampleValueMetaData(parameterName, changePropertyAnnotation);
            String since = this.createSinceMetaData(parameterName, changePropertyAnnotation);
            LiquibaseSerializable.SerializationType serializationType = this.createSerializationTypeMetaData(parameterName, changePropertyAnnotation);
            String[] requiredForDatabase = this.createRequiredDatabasesMetaData(parameterName, changePropertyAnnotation);
            String[] supportsDatabase = this.createSupportedDatabasesMetaData(parameterName, changePropertyAnnotation);
            return new ChangeParameterMetaData(this, parameterName, displayName, description, examples, since, type, requiredForDatabase, supportsDatabase, mustEqualExisting, serializationType);
        }
        catch (Exception e) {
            throw new UnexpectedLiquibaseException(e);
        }
    }

    protected String createSinceMetaData(String parameterName, DatabaseChangeProperty changePropertyAnnotation) {
        if (changePropertyAnnotation == null) {
            return null;
        }
        return StringUtils.trimToNull(changePropertyAnnotation.since());
    }

    protected String createDescriptionMetaData(String parameterName, DatabaseChangeProperty changePropertyAnnotation) {
        if (changePropertyAnnotation == null) {
            return null;
        }
        return StringUtils.trimToNull(changePropertyAnnotation.description());
    }

    protected LiquibaseSerializable.SerializationType createSerializationTypeMetaData(String parameterName, DatabaseChangeProperty changePropertyAnnotation) {
        if (changePropertyAnnotation == null) {
            return LiquibaseSerializable.SerializationType.NAMED_FIELD;
        }
        return changePropertyAnnotation.serializationType();
    }

    protected String createMustEqualExistingMetaData(String parameterName, DatabaseChangeProperty changePropertyAnnotation) {
        if (changePropertyAnnotation == null) {
            return null;
        }
        return changePropertyAnnotation.mustEqualExisting();
    }

    protected Map<String, Object> createExampleValueMetaData(String parameterName, DatabaseChangeProperty changePropertyAnnotation) {
        if (changePropertyAnnotation == null) {
            return null;
        }
        HashMap<String, Object> examples = new HashMap<String, Object>();
        examples.put("all", StringUtils.trimToNull(changePropertyAnnotation.exampleValue()));
        return examples;
    }

    protected String[] createRequiredDatabasesMetaData(String parameterName, DatabaseChangeProperty changePropertyAnnotation) {
        if (changePropertyAnnotation == null) {
            return new String[]{"COMPUTE"};
        }
        return changePropertyAnnotation.requiredForDatabase();
    }

    protected String[] createSupportedDatabasesMetaData(String parameterName, DatabaseChangeProperty changePropertyAnnotation) {
        if (changePropertyAnnotation == null) {
            return new String[]{"COMPUTE"};
        }
        return changePropertyAnnotation.supportsDatabase();
    }

    @Override
    @DatabaseChangeProperty(isChangeProperty=false)
    public ChangeSet getChangeSet() {
        return this.changeSet;
    }

    @Override
    public void setChangeSet(ChangeSet changeSet) {
        this.changeSet = changeSet;
    }

    @Override
    public boolean generateStatementsVolatile(Database database) {
        SqlStatement[] statements = this.generateStatements(database);
        if (statements == null) {
            return false;
        }
        for (SqlStatement statement : statements) {
            if (!SqlGeneratorFactory.getInstance().generateStatementsVolatile(statement, database)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean generateRollbackStatementsVolatile(Database database) {
        if (this.generateStatementsVolatile(database)) {
            return true;
        }
        SqlStatement[] statements = this.generateStatements(database);
        if (statements == null) {
            return false;
        }
        for (SqlStatement statement : statements) {
            if (!SqlGeneratorFactory.getInstance().generateRollbackStatementsVolatile(statement, database)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean supports(Database database) {
        if (this.generateStatementsVolatile(database)) {
            return true;
        }
        SqlStatement[] statements = this.generateStatements(database);
        if (statements == null) {
            return true;
        }
        for (SqlStatement statement : statements) {
            if (SqlGeneratorFactory.getInstance().supports(statement, database)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Warnings warn(Database database) {
        Warnings warnings = new Warnings();
        if (this.generateStatementsVolatile(database)) {
            return warnings;
        }
        SqlStatement[] statements = this.generateStatements(database);
        if (statements == null) {
            return warnings;
        }
        for (SqlStatement statement : statements) {
            if (SqlGeneratorFactory.getInstance().supports(statement, database)) {
                warnings.addAll(SqlGeneratorFactory.getInstance().warn(statement, database));
                continue;
            }
            if (!statement.skipOnUnsupported()) continue;
            warnings.addWarning(statement.getClass().getName() + " is not supported on " + database.getShortName() + ", but " + ChangeFactory.getInstance().getChangeMetaData(this).getName() + " will still execute");
        }
        return warnings;
    }

    @Override
    public ValidationErrors validate(Database database) {
        ValidationErrors changeValidationErrors = new ValidationErrors();
        for (ChangeParameterMetaData param : ChangeFactory.getInstance().getChangeMetaData(this).getParameters().values()) {
            if (!param.isRequiredFor(database) || param.getCurrentValue(this) != null) continue;
            changeValidationErrors.addError(param.getParameterName() + " is required for " + ChangeFactory.getInstance().getChangeMetaData(this).getName() + " on " + database.getShortName());
        }
        if (changeValidationErrors.hasErrors()) {
            return changeValidationErrors;
        }
        String unsupportedWarning = ChangeFactory.getInstance().getChangeMetaData(this).getName() + " is not supported on " + database.getShortName();
        if (!this.supports(database)) {
            changeValidationErrors.addError(unsupportedWarning);
        } else if (!this.generateStatementsVolatile(database)) {
            boolean sawUnsupportedError = false;
            SqlStatement[] statements = this.generateStatements(database);
            if (statements != null) {
                for (SqlStatement statement : statements) {
                    boolean supported = SqlGeneratorFactory.getInstance().supports(statement, database);
                    if (!supported && !sawUnsupportedError) {
                        if (statement.skipOnUnsupported()) continue;
                        changeValidationErrors.addError(unsupportedWarning);
                        sawUnsupportedError = true;
                        continue;
                    }
                    changeValidationErrors.addAll(SqlGeneratorFactory.getInstance().validate(statement, database));
                }
            }
        }
        return changeValidationErrors;
    }

    @Override
    public ChangeStatus checkStatus(Database database) {
        return new ChangeStatus().unknown("Not implemented");
    }

    @Override
    public SqlStatement[] generateRollbackStatements(Database database) throws RollbackImpossibleException {
        return this.generateRollbackStatementsFromInverse(database);
    }

    @Override
    public boolean supportsRollback(Database database) {
        return this.createInverses() != null;
    }

    @Override
    public CheckSum generateCheckSum() {
        return CheckSum.compute(new StringChangeLogSerializer().serialize(this, false));
    }

    private SqlStatement[] generateRollbackStatementsFromInverse(Database database) throws RollbackImpossibleException {
        Change[] inverses = this.createInverses();
        if (inverses == null) {
            throw new RollbackImpossibleException("No inverse to " + this.getClass().getName() + " created");
        }
        ArrayList<SqlStatement> statements = new ArrayList<SqlStatement>();
        try {
            for (Change inverse : inverses) {
                if (!inverse.supports(database)) {
                    throw new RollbackImpossibleException(ChangeFactory.getInstance().getChangeMetaData(inverse).getName() + " is not supported on " + database.getShortName());
                }
                statements.addAll(Arrays.asList(inverse.generateStatements(database)));
            }
        }
        catch (LiquibaseException e) {
            throw new RollbackImpossibleException(e);
        }
        return statements.toArray(new SqlStatement[statements.size()]);
    }

    protected Change[] createInverses() {
        return null;
    }

    @Override
    public void setResourceAccessor(ResourceAccessor resourceAccessor) {
        this.resourceAccessor = resourceAccessor;
    }

    @DatabaseChangeProperty(isChangeProperty=false)
    public ResourceAccessor getResourceAccessor() {
        return this.resourceAccessor;
    }

    @Override
    public Set<DatabaseObject> getAffectedDatabaseObjects(Database database) {
        if (this.generateStatementsVolatile(database)) {
            return new HashSet<DatabaseObject>();
        }
        HashSet<DatabaseObject> affectedObjects = new HashSet<DatabaseObject>();
        SqlStatement[] statements = this.generateStatements(database);
        if (statements != null) {
            for (SqlStatement statement : statements) {
                affectedObjects.addAll(SqlGeneratorFactory.getInstance().getAffectedDatabaseObjects(statement, database));
            }
        }
        return affectedObjects;
    }

    @Override
    public Set<String> getSerializableFields() {
        return ChangeFactory.getInstance().getChangeMetaData(this).getParameters().keySet();
    }

    @Override
    public Object getSerializableFieldValue(String field) {
        return ChangeFactory.getInstance().getChangeMetaData(this).getParameters().get(field).getCurrentValue(this);
    }

    @Override
    public String getSerializedObjectName() {
        return ChangeFactory.getInstance().getChangeMetaData(this).getName();
    }

    @Override
    public LiquibaseSerializable.SerializationType getSerializableFieldType(String field) {
        return ChangeFactory.getInstance().getChangeMetaData(this).getParameters().get(field).getSerializationType();
    }

    @Override
    public String getSerializedObjectNamespace() {
        return "http://www.liquibase.org/xml/ns/dbchangelog-ext";
    }

    public String toString() {
        return ChangeFactory.getInstance().getChangeMetaData(this).getName();
    }

    @Override
    public void load(ParsedNode parsedNode, ResourceAccessor resourceAccessor) throws ParsedNodeException {
        ChangeMetaData metaData = ChangeFactory.getInstance().getChangeMetaData(this);
        this.setResourceAccessor(resourceAccessor);
        try {
            for (ChangeParameterMetaData param : metaData.getParameters().values()) {
                if (Collection.class.isAssignableFrom(param.getDataTypeClass())) {
                    Class collectionType = (Class)param.getDataTypeClassParameters()[0];
                    if (param.getDataTypeClassParameters().length != 1) continue;
                    if (ColumnConfig.class.isAssignableFrom(collectionType)) {
                        ArrayList<ParsedNode> columnNodes = new ArrayList<ParsedNode>(parsedNode.getChildren(null, param.getParameterName()));
                        columnNodes.addAll(parsedNode.getChildren(null, "column"));
                        Object nodeValue = parsedNode.getValue();
                        if (nodeValue instanceof ParsedNode) {
                            columnNodes.add((ParsedNode)nodeValue);
                        } else if (nodeValue instanceof Collection) {
                            for (Object nodeValueChild : (Collection)nodeValue) {
                                if (!(nodeValueChild instanceof ParsedNode)) continue;
                                columnNodes.add((ParsedNode)nodeValueChild);
                            }
                        }
                        for (ParsedNode child : columnNodes) {
                            if (!child.getName().equals("column") && !child.getName().equals("columns")) continue;
                            List<ParsedNode> columnChildren = child.getChildren(null, "column");
                            if (columnChildren != null && columnChildren.size() > 0) {
                                for (ParsedNode columnChild : columnChildren) {
                                    ColumnConfig columnConfig = (ColumnConfig)collectionType.newInstance();
                                    columnConfig.load(columnChild, resourceAccessor);
                                    ((ChangeWithColumns)((Object)this)).addColumn(columnConfig);
                                }
                                continue;
                            }
                            ColumnConfig columnConfig = (ColumnConfig)collectionType.newInstance();
                            columnConfig.load(child, resourceAccessor);
                            ((ChangeWithColumns)((Object)this)).addColumn(columnConfig);
                        }
                        continue;
                    }
                    if (!LiquibaseSerializable.class.isAssignableFrom(collectionType)) continue;
                    ArrayList<ParsedNode> childNodes = new ArrayList<ParsedNode>(parsedNode.getChildren(null, param.getParameterName()));
                    for (ParsedNode childNode : childNodes) {
                        LiquibaseSerializable childObject = (LiquibaseSerializable)collectionType.newInstance();
                        childObject.load(childNode, resourceAccessor);
                        ((Collection)param.getCurrentValue(this)).add(childObject);
                    }
                    continue;
                }
                if (LiquibaseSerializable.class.isAssignableFrom(param.getDataTypeClass())) {
                    try {
                        ParsedNode child = parsedNode.getChild(null, param.getParameterName());
                        if (child == null) continue;
                        LiquibaseSerializable serializableChild = (LiquibaseSerializable)param.getDataTypeClass().newInstance();
                        serializableChild.load(child, resourceAccessor);
                        param.setValue(this, serializableChild);
                        continue;
                    }
                    catch (InstantiationException e) {
                        throw new UnexpectedLiquibaseException(e);
                    }
                    catch (IllegalAccessException e) {
                        throw new UnexpectedLiquibaseException(e);
                    }
                }
                Object childValue = parsedNode.getChildValue((String)null, param.getParameterName(), param.getDataTypeClass());
                if (childValue == null && param.getSerializationType() == LiquibaseSerializable.SerializationType.DIRECT_VALUE) {
                    childValue = parsedNode.getValue();
                }
                param.setValue(this, childValue);
            }
        }
        catch (InstantiationException e) {
            throw new UnexpectedLiquibaseException(e);
        }
        catch (IllegalAccessException e) {
            throw new UnexpectedLiquibaseException(e);
        }
        this.customLoadLogic(parsedNode, resourceAccessor);
        try {
            this.finishInitialization();
        }
        catch (SetupException e) {
            throw new ParsedNodeException(e);
        }
    }

    protected void customLoadLogic(ParsedNode parsedNode, ResourceAccessor resourceAccessor) throws ParsedNodeException {
    }

    @Override
    public ParsedNode serialize() throws ParsedNodeException {
        ParsedNode node = new ParsedNode(null, this.getSerializedObjectName());
        ChangeMetaData metaData = ChangeFactory.getInstance().getChangeMetaData(this);
        for (ChangeParameterMetaData param : metaData.getSetParameters(this).values()) {
            Object currentValue = param.getCurrentValue(this);
            if ((currentValue = this.serializeValue(currentValue)) == null) continue;
            node.addChild(null, param.getParameterName(), currentValue);
        }
        return node;
    }

    protected Object serializeValue(Object value) throws ParsedNodeException {
        if (value instanceof Collection) {
            ArrayList<Object> returnList = new ArrayList<Object>();
            for (Object obj : (Collection)value) {
                Object objValue = this.serializeValue(obj);
                if (objValue == null) continue;
                returnList.add(objValue);
            }
            if (((Collection)value).size() == 0) {
                return null;
            }
            return returnList;
        }
        if (value instanceof LiquibaseSerializable) {
            return ((LiquibaseSerializable)value).serialize();
        }
        return value;
    }
}

