/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.scheduled;

import org.jboss.resteasy.logging.Logger;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.services.scheduled.ScheduledTask;

public class ScheduledTaskRunner
implements Runnable {
    private static final Logger logger = Logger.getLogger(ScheduledTaskRunner.class);
    private final KeycloakSessionFactory sessionFactory;
    private final ScheduledTask task;

    public ScheduledTaskRunner(KeycloakSessionFactory sessionFactory, ScheduledTask task) {
        this.sessionFactory = sessionFactory;
        this.task = task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        KeycloakSession session = this.sessionFactory.create();
        try {
            session.getTransaction().begin();
            this.task.run(session);
            session.getTransaction().commit();
            logger.debug("Executed scheduled task " + this.task.getClass().getSimpleName());
        }
        catch (Throwable t) {
            logger.error("Failed to run scheduled task " + this.task.getClass().getSimpleName(), t);
            session.getTransaction().rollback();
        }
        finally {
            try {
                session.close();
            }
            catch (Throwable t) {
                logger.error("Failed to close ProviderSession", t);
            }
        }
    }
}

