/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.gui.metacommand;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ProgressMonitor;
import javax.swing.SwingWorker;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.gui.CliGuiContext;
import org.jboss.dmr.ModelNode;

public class DownloadServerLogDialog
extends JDialog
implements ActionListener,
PropertyChangeListener {
    private static final JFileChooser fileChooser = new JFileChooser(new File("."));
    private static final JCheckBox viewInLogViewer = new JCheckBox("View in default log viewer");
    private CliGuiContext cliGuiCtx;
    private String fileName;
    private Long fileSize;
    private JPanel inputPanel = new JPanel(new GridBagLayout());
    private JTextField pathField = new JTextField(40);
    private ProgressMonitor progressMonitor;
    private DownloadLogTask downloadTask;
    private boolean openInViewerSupported = Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.OPEN);

    public DownloadServerLogDialog(CliGuiContext cliGuiCtx, String fileName, Long fileSize) {
        super(cliGuiCtx.getMainWindow(), "Download " + fileName, Dialog.ModalityType.APPLICATION_MODAL);
        this.cliGuiCtx = cliGuiCtx;
        this.fileName = fileName;
        this.fileSize = fileSize;
        fileChooser.setSelectedFile(new File(fileChooser.getCurrentDirectory(), fileName));
        this.setPathField();
        this.setDefaultCloseOperation(2);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout(10, 10));
        contentPane.add((Component)this.makeInputPanel(), "Center");
        contentPane.add((Component)this.makeButtonPanel(), "South");
        this.pack();
        this.setResizable(false);
    }

    private void setPathField() {
        try {
            this.pathField.setText(fileChooser.getSelectedFile().getCanonicalPath());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private JPanel makeInputPanel() {
        GridBagConstraints gbConst = new GridBagConstraints();
        gbConst.anchor = 17;
        gbConst.insets = new Insets(5, 5, 5, 5);
        JLabel pathLabel = new JLabel("Download To:");
        gbConst.gridwidth = 1;
        this.inputPanel.add((Component)pathLabel, gbConst);
        this.addStrut();
        this.inputPanel.add((Component)this.pathField, gbConst);
        this.addStrut();
        JButton browse = new JButton("Browse ...");
        browse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                int returnVal = fileChooser.showOpenDialog(DownloadServerLogDialog.this);
                if (returnVal == 0) {
                    DownloadServerLogDialog.this.setPathField();
                }
            }
        });
        gbConst.gridwidth = 0;
        this.inputPanel.add((Component)browse, gbConst);
        if (this.openInViewerSupported) {
            JLabel emptyLabel = new JLabel("");
            gbConst.gridwidth = 1;
            this.inputPanel.add((Component)emptyLabel, gbConst);
            this.addStrut();
            gbConst.gridwidth = 0;
            this.inputPanel.add((Component)viewInLogViewer, gbConst);
        }
        return this.inputPanel;
    }

    private void addStrut() {
        this.inputPanel.add(Box.createHorizontalStrut(5));
    }

    private JPanel makeButtonPanel() {
        JPanel buttonPanel = new JPanel();
        JButton ok = new JButton("OK");
        ok.addActionListener(this);
        ok.setMnemonic(10);
        JButton cancel = new JButton("Cancel");
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                DownloadServerLogDialog.this.dispose();
            }
        });
        buttonPanel.add(ok);
        buttonPanel.add(cancel);
        return buttonPanel;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String path = this.pathField.getText();
        if (path.trim().isEmpty()) {
            JOptionPane.showMessageDialog(this, "A file path must be selected.", "Empty File Path", 0);
            return;
        }
        File selectedFile = new File(path);
        if (selectedFile.exists()) {
            this.setVisible(false);
            int option = JOptionPane.showConfirmDialog(this.cliGuiCtx.getMainWindow(), "Overwrite " + path, "Overwrite?", 0);
            if (option == 1) {
                this.setVisible(true);
                return;
            }
        }
        this.dispose();
        this.progressMonitor = new ProgressMonitor(this.cliGuiCtx.getMainWindow(), "Downloading " + this.fileName, "", 0, 100);
        this.progressMonitor.setProgress(0);
        this.downloadTask = new DownloadLogTask(selectedFile);
        this.downloadTask.addPropertyChangeListener(this);
        this.downloadTask.execute();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("progress".equals(evt.getPropertyName())) {
            int percentRead = (Integer)evt.getNewValue();
            this.progressMonitor.setProgress(percentRead);
        }
        if ("bytesRead".equals(evt.getPropertyName())) {
            this.progressMonitor.setNote(evt.getNewValue() + " of " + this.fileSize + " bytes received.");
        }
        if (this.progressMonitor.isCanceled()) {
            this.downloadTask.cancel(false);
        }
    }

    static {
        viewInLogViewer.setSelected(true);
    }

    class DownloadLogTask
    extends SwingWorker<Void, Void> {
        private File selectedFile;

        public DownloadLogTask(File selectedFile) {
            this.selectedFile = selectedFile;
        }

        @Override
        public Void doInBackground() {
            PrintStream out = null;
            try {
                out = new PrintStream(new BufferedOutputStream(new FileOutputStream(this.selectedFile)));
                int linesToRead = 5000;
                int skip = 0;
                List dataLines = null;
                long bytesRead = 0L;
                long bytesReadOldValue = 0L;
                int lineSepLength = System.getProperty("line.separator").length();
                do {
                    String command = "/subsystem=logging/:read-log-file(name=" + DownloadServerLogDialog.this.fileName + ",lines=" + linesToRead + ",skip=" + skip + ",tail=false)";
                    ModelNode result = DownloadServerLogDialog.this.cliGuiCtx.getExecutor().doCommand(command);
                    if (result.get("outcome").asString().equals("failed")) {
                        this.cancel(false);
                        String error = "Failure at server: " + result.get("failure-description").toString();
                        JOptionPane.showMessageDialog(DownloadServerLogDialog.this.cliGuiCtx.getMainWindow(), error, "Download Failed", 0);
                        Void void_ = null;
                        return void_;
                    }
                    dataLines = result.get("result").asList();
                    for (ModelNode line : dataLines) {
                        String strLine = line.asString();
                        bytesRead += (long)(strLine.length() + lineSepLength);
                        out.println(strLine);
                    }
                    skip += linesToRead;
                    this.setProgress(Math.min(Math.round((float)bytesRead / (float)DownloadServerLogDialog.this.fileSize.longValue() * 100.0f), 100));
                    this.firePropertyChange("bytesRead", bytesReadOldValue, bytesRead);
                    bytesReadOldValue = bytesRead;
                } while (dataLines.size() == linesToRead && !this.isCancelled());
            }
            catch (IOException | CommandFormatException ex) {
                throw new RuntimeException(ex);
            }
            finally {
                if (out != null) {
                    out.close();
                }
                if (this.isCancelled()) {
                    this.selectedFile.delete();
                }
            }
            return null;
        }

        @Override
        public void done() {
            String message = "Download " + DownloadServerLogDialog.this.fileName + " ";
            if (this.isCancelled()) {
                JOptionPane.showMessageDialog(DownloadServerLogDialog.this.cliGuiCtx.getMainWindow(), message + "cancelled.", message + "cancelled.", 0);
                return;
            }
            if (!viewInLogViewer.isSelected() || !DownloadServerLogDialog.this.openInViewerSupported) {
                JOptionPane.showMessageDialog(DownloadServerLogDialog.this.cliGuiCtx.getMainWindow(), message + "complete.");
                return;
            }
            try {
                Desktop.getDesktop().open(this.selectedFile);
            }
            catch (IOException ioe) {
                try {
                    Desktop.getDesktop().open(fileChooser.getCurrentDirectory());
                }
                catch (IOException ioe2) {
                    JOptionPane.showMessageDialog(DownloadServerLogDialog.this.cliGuiCtx.getMainWindow(), "Download success.  No registered application to view " + DownloadServerLogDialog.this.fileName, "Can't view file.", 0);
                }
            }
        }
    }
}

