/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.mongo.keycloak.adapters;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.keycloak.connections.mongo.api.MongoIdentifiableEntity;
import org.keycloak.connections.mongo.api.context.MongoStoreInvocationContext;
import org.keycloak.models.ApplicationModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.PasswordPolicy;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserCredentialValueModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.entities.CredentialEntity;
import org.keycloak.models.mongo.keycloak.adapters.AbstractMongoAdapter;
import org.keycloak.models.mongo.keycloak.adapters.RoleAdapter;
import org.keycloak.models.mongo.keycloak.entities.MongoRoleEntity;
import org.keycloak.models.mongo.keycloak.entities.MongoUserEntity;
import org.keycloak.models.mongo.utils.MongoModelUtils;
import org.keycloak.models.utils.Pbkdf2PasswordEncoder;

public class UserAdapter
extends AbstractMongoAdapter<MongoUserEntity>
implements UserModel {
    private final MongoUserEntity user;
    private final RealmModel realm;
    private final KeycloakSession session;

    public UserAdapter(KeycloakSession session, RealmModel realm, MongoUserEntity userEntity, MongoStoreInvocationContext invContext) {
        super(invContext);
        this.user = userEntity;
        this.realm = realm;
        this.session = session;
    }

    public String getId() {
        return this.user.getId();
    }

    public String getUsername() {
        return this.user.getUsername();
    }

    public void setUsername(String username) {
        this.user.setUsername(username);
        this.updateUser();
    }

    public boolean isEnabled() {
        return this.user.isEnabled();
    }

    public void setEnabled(boolean enabled) {
        this.user.setEnabled(enabled);
        this.updateUser();
    }

    public String getFirstName() {
        return this.user.getFirstName();
    }

    public void setFirstName(String firstName) {
        this.user.setFirstName(firstName);
        this.updateUser();
    }

    public String getLastName() {
        return this.user.getLastName();
    }

    public void setLastName(String lastName) {
        this.user.setLastName(lastName);
        this.updateUser();
    }

    public String getEmail() {
        return this.user.getEmail();
    }

    public void setEmail(String email) {
        this.user.setEmail(email);
        this.updateUser();
    }

    public boolean isEmailVerified() {
        return this.user.isEmailVerified();
    }

    public void setEmailVerified(boolean verified) {
        this.user.setEmailVerified(verified);
        this.updateUser();
    }

    public void setAttribute(String name, String value) {
        if (this.user.getAttributes() == null) {
            this.user.setAttributes(new HashMap());
        }
        this.user.getAttributes().put(name, value);
        this.updateUser();
    }

    public void removeAttribute(String name) {
        if (this.user.getAttributes() == null) {
            return;
        }
        this.user.getAttributes().remove(name);
        this.updateUser();
    }

    public String getAttribute(String name) {
        return this.user.getAttributes() == null ? null : (String)this.user.getAttributes().get(name);
    }

    public Map<String, String> getAttributes() {
        return this.user.getAttributes() == null ? Collections.emptyMap() : Collections.unmodifiableMap(this.user.getAttributes());
    }

    public MongoUserEntity getUser() {
        return this.user;
    }

    public Set<UserModel.RequiredAction> getRequiredActions() {
        HashSet<UserModel.RequiredAction> result = new HashSet<UserModel.RequiredAction>();
        if (this.user.getRequiredActions() != null) {
            result.addAll(this.user.getRequiredActions());
        }
        return result;
    }

    public void addRequiredAction(UserModel.RequiredAction action) {
        this.getMongoStore().pushItemToList((MongoIdentifiableEntity)this.user, "requiredActions", (Object)action, true, this.invocationContext);
    }

    public void removeRequiredAction(UserModel.RequiredAction action) {
        this.getMongoStore().pullItemFromList((MongoIdentifiableEntity)this.user, "requiredActions", (Object)action, this.invocationContext);
    }

    public boolean isTotp() {
        return this.user.isTotp();
    }

    public void setTotp(boolean totp) {
        this.user.setTotp(totp);
        this.updateUser();
    }

    public void updateCredential(UserCredentialModel cred) {
        CredentialEntity credentialEntity = this.getCredentialEntity(this.user, cred.getType());
        if (credentialEntity == null) {
            credentialEntity = new CredentialEntity();
            credentialEntity.setType(cred.getType());
            credentialEntity.setDevice(cred.getDevice());
            this.user.getCredentials().add(credentialEntity);
        }
        if (cred.getType().equals("password")) {
            byte[] salt = Pbkdf2PasswordEncoder.getSalt();
            int hashIterations = 1;
            PasswordPolicy policy = this.realm.getPasswordPolicy();
            if (policy != null && (hashIterations = policy.getHashIterations()) == -1) {
                hashIterations = 1;
            }
            credentialEntity.setValue(new Pbkdf2PasswordEncoder(salt).encode(cred.getValue(), hashIterations));
            credentialEntity.setSalt(salt);
            credentialEntity.setHashIterations(hashIterations);
        } else {
            credentialEntity.setValue(cred.getValue());
        }
        credentialEntity.setDevice(cred.getDevice());
        this.getMongoStore().updateEntity((MongoIdentifiableEntity)this.user, this.invocationContext);
    }

    private CredentialEntity getCredentialEntity(MongoUserEntity userEntity, String credType) {
        for (CredentialEntity entity : userEntity.getCredentials()) {
            if (!entity.getType().equals(credType)) continue;
            return entity;
        }
        return null;
    }

    public List<UserCredentialValueModel> getCredentialsDirectly() {
        List credentials = this.user.getCredentials();
        ArrayList<UserCredentialValueModel> result = new ArrayList<UserCredentialValueModel>();
        for (CredentialEntity credEntity : credentials) {
            UserCredentialValueModel credModel = new UserCredentialValueModel();
            credModel.setType(credEntity.getType());
            credModel.setDevice(credEntity.getDevice());
            credModel.setValue(credEntity.getValue());
            credModel.setSalt(credEntity.getSalt());
            credModel.setHashIterations(credEntity.getHashIterations());
            result.add(credModel);
        }
        return result;
    }

    public void updateCredentialDirectly(UserCredentialValueModel credModel) {
        CredentialEntity credentialEntity = this.getCredentialEntity(this.user, credModel.getType());
        if (credentialEntity == null) {
            credentialEntity = new CredentialEntity();
            credentialEntity.setType(credModel.getType());
            this.user.getCredentials().add(credentialEntity);
        }
        credentialEntity.setValue(credModel.getValue());
        credentialEntity.setSalt(credModel.getSalt());
        credentialEntity.setDevice(credModel.getDevice());
        credentialEntity.setHashIterations(credModel.getHashIterations());
        this.getMongoStore().updateEntity((MongoIdentifiableEntity)this.user, this.invocationContext);
    }

    protected void updateUser() {
        super.updateMongoEntity();
    }

    @Override
    public MongoUserEntity getMongoEntity() {
        return this.user;
    }

    public boolean hasRole(RoleModel role) {
        Set<RoleModel> roles = this.getRoleMappings();
        if (roles.contains(role)) {
            return true;
        }
        for (RoleModel mapping : roles) {
            if (!mapping.hasRole(role)) continue;
            return true;
        }
        return false;
    }

    public void grantRole(RoleModel role) {
        this.getMongoStore().pushItemToList((MongoIdentifiableEntity)this.getUser(), "roleIds", (Object)role.getId(), true, this.invocationContext);
    }

    public Set<RoleModel> getRoleMappings() {
        HashSet<RoleModel> result = new HashSet<RoleModel>();
        List<MongoRoleEntity> roles = MongoModelUtils.getAllRolesOfUser(this, this.invocationContext);
        for (MongoRoleEntity role : roles) {
            if (this.realm.getId().equals(role.getRealmId())) {
                result.add(new RoleAdapter(this.session, this.realm, role, (RoleContainerModel)this.realm, this.invocationContext));
                continue;
            }
            result.add(new RoleAdapter(this.session, this.realm, role, this.invocationContext));
        }
        return result;
    }

    public Set<RoleModel> getRealmRoleMappings() {
        Set<RoleModel> allRoles = this.getRoleMappings();
        HashSet<RoleModel> realmRoles = new HashSet<RoleModel>();
        for (RoleModel role : allRoles) {
            MongoRoleEntity roleEntity = ((RoleAdapter)role).getRole();
            if (!this.realm.getId().equals(roleEntity.getRealmId())) continue;
            realmRoles.add(role);
        }
        return realmRoles;
    }

    public void deleteRoleMapping(RoleModel role) {
        if (this.user == null || role == null) {
            return;
        }
        this.getMongoStore().pullItemFromList((MongoIdentifiableEntity)this.getUser(), "roleIds", (Object)role.getId(), this.invocationContext);
    }

    public Set<RoleModel> getApplicationRoleMappings(ApplicationModel app) {
        HashSet<RoleModel> result = new HashSet<RoleModel>();
        List<MongoRoleEntity> roles = MongoModelUtils.getAllRolesOfUser(this, this.invocationContext);
        for (MongoRoleEntity role : roles) {
            if (!app.getId().equals(role.getApplicationId())) continue;
            result.add(new RoleAdapter(this.session, this.realm, role, (RoleContainerModel)app, this.invocationContext));
        }
        return result;
    }

    public String getFederationLink() {
        return this.user.getFederationLink();
    }

    public void setFederationLink(String link) {
        this.user.setFederationLink(link);
        this.updateUser();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof UserModel)) {
            return false;
        }
        UserModel that = (UserModel)o;
        return that.getId().equals(this.getId());
    }

    @Override
    public int hashCode() {
        return this.getId().hashCode();
    }
}

