/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.provider.Provider;
import org.keycloak.provider.ProviderEvent;
import org.keycloak.provider.ProviderEventListener;
import org.keycloak.provider.ProviderFactory;
import org.keycloak.provider.ProviderManager;
import org.keycloak.provider.Spi;
import org.keycloak.services.DefaultKeycloakSession;

public class DefaultKeycloakSessionFactory
implements KeycloakSessionFactory {
    private static final Logger log = Logger.getLogger(DefaultKeycloakSessionFactory.class);
    private Map<Class<? extends Provider>, String> provider = new HashMap<Class<? extends Provider>, String>();
    private Map<Class<? extends Provider>, Map<String, ProviderFactory>> factoriesMap = new HashMap<Class<? extends Provider>, Map<String, ProviderFactory>>();
    protected CopyOnWriteArrayList<ProviderEventListener> listeners = new CopyOnWriteArrayList();

    public void register(ProviderEventListener listener) {
        this.listeners.add(listener);
    }

    public void unregister(ProviderEventListener listener) {
        this.listeners.remove(listener);
    }

    public void publish(ProviderEvent event) {
        for (ProviderEventListener listener : this.listeners) {
            listener.onEvent(event);
        }
    }

    public void init() {
        ProviderManager pm = new ProviderManager(this.getClass().getClassLoader(), Config.scope((String[])new String[0]).getArray("providers"));
        for (Spi spi : ServiceLoader.load(Spi.class, this.getClass().getClassLoader())) {
            HashMap<String, ProviderFactory> factories = new HashMap<String, ProviderFactory>();
            this.factoriesMap.put(spi.getProviderClass(), factories);
            String provider = Config.getProvider((String)spi.getName());
            if (provider != null) {
                this.provider.put(spi.getProviderClass(), provider);
                ProviderFactory factory = pm.load(spi, provider);
                if (factory == null) {
                    throw new RuntimeException("Failed to find provider " + provider + " for " + spi.getName());
                }
                Config.Scope scope = Config.scope((String[])new String[]{spi.getName(), provider});
                factory.init(scope);
                factories.put(factory.getId(), factory);
                log.debugv("Loaded SPI {0} (provider = {1})", (Object)spi.getName(), (Object)provider);
                continue;
            }
            for (ProviderFactory factory : pm.load(spi)) {
                Config.Scope scope = Config.scope((String[])new String[]{spi.getName(), factory.getId()});
                factory.init(scope);
                factories.put(factory.getId(), factory);
            }
            if (factories.size() == 1) {
                provider = ((ProviderFactory)factories.values().iterator().next()).getId();
                this.provider.put(spi.getProviderClass(), provider);
                log.debugv("Loaded SPI {0}  (provider = {1})", (Object)spi.getName(), (Object)provider);
                continue;
            }
            log.debugv("Loaded SPI {0} (providers = {1})", (Object)spi.getName(), factories.keySet());
        }
        for (Map map : this.factoriesMap.values()) {
            for (ProviderFactory factory : map.values()) {
                factory.postInit((KeycloakSessionFactory)this);
            }
        }
    }

    public KeycloakSession create() {
        return new DefaultKeycloakSession(this);
    }

    <T extends Provider> String getDefaultProvider(Class<T> clazz) {
        return this.provider.get(clazz);
    }

    public <T extends Provider> ProviderFactory<T> getProviderFactory(Class<T> clazz) {
        return this.getProviderFactory(clazz, this.provider.get(clazz));
    }

    public <T extends Provider> ProviderFactory<T> getProviderFactory(Class<T> clazz, String id) {
        return this.factoriesMap.get(clazz).get(id);
    }

    public List<ProviderFactory> getProviderFactories(Class<? extends Provider> clazz) {
        LinkedList<ProviderFactory> list = new LinkedList<ProviderFactory>();
        if (this.factoriesMap == null) {
            return list;
        }
        Map<String, ProviderFactory> providerFactoryMap = this.factoriesMap.get(clazz);
        if (providerFactoryMap == null) {
            return list;
        }
        list.addAll(providerFactoryMap.values());
        return list;
    }

    <T extends Provider> Set<String> getAllProviderIds(Class<T> clazz) {
        HashSet<String> ids = new HashSet<String>();
        for (ProviderFactory f : this.factoriesMap.get(clazz).values()) {
            ids.add(f.getId());
        }
        return ids;
    }

    public void close() {
        for (Map<String, ProviderFactory> factories : this.factoriesMap.values()) {
            for (ProviderFactory factory : factories.values()) {
                factory.close();
            }
        }
    }
}

