/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.spi.NotFoundException;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.models.utils.RepresentationToModel;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.services.ErrorResponse;
import org.keycloak.services.resources.admin.ClientResource;
import org.keycloak.services.resources.admin.RealmAdminResource;
import org.keycloak.services.resources.admin.RealmAuth;

public class ClientsResource {
    protected static final Logger logger = Logger.getLogger(RealmAdminResource.class);
    protected RealmModel realm;
    private RealmAuth auth;
    @Context
    protected KeycloakSession session;

    public ClientsResource(RealmModel realm, RealmAuth auth) {
        this.realm = realm;
        this.auth = auth;
        auth.init(RealmAuth.Resource.CLIENT);
    }

    @GET
    @Produces(value={"application/json"})
    @NoCache
    public List<ClientRepresentation> getClients() {
        this.auth.requireAny();
        ArrayList<ClientRepresentation> rep = new ArrayList<ClientRepresentation>();
        List clientModels = this.realm.getClients();
        boolean view = this.auth.hasView();
        for (ClientModel clientModel : clientModels) {
            if (view) {
                rep.add(ModelToRepresentation.toRepresentation((ClientModel)clientModel));
                continue;
            }
            ClientRepresentation client = new ClientRepresentation();
            client.setClientId(clientModel.getClientId());
            rep.add(client);
        }
        return rep;
    }

    @POST
    @Consumes(value={"application/json"})
    public Response createClient(@Context UriInfo uriInfo, ClientRepresentation rep) {
        this.auth.requireManage();
        try {
            ClientModel clientModel = RepresentationToModel.createClient((KeycloakSession)this.session, (RealmModel)this.realm, (ClientRepresentation)rep, (boolean)true);
            return Response.created((URI)uriInfo.getAbsolutePathBuilder().path(this.getClientPath(clientModel)).build(new Object[0])).build();
        }
        catch (ModelDuplicateException e) {
            return ErrorResponse.exists("Client " + rep.getClientId() + " already exists");
        }
    }

    protected String getClientPath(ClientModel clientModel) {
        return clientModel.getClientId();
    }

    @Path(value="{app-name}")
    public ClientResource getClient(@PathParam(value="app-name") String name) {
        ClientModel clientModel = this.getClientByPathParam(name);
        if (clientModel == null) {
            throw new NotFoundException("Could not find client: " + name);
        }
        ClientResource clientResource = new ClientResource(this.realm, this.auth, clientModel, this.session);
        ResteasyProviderFactory.getInstance().injectProperties((Object)clientResource);
        return clientResource;
    }

    protected ClientModel getClientByPathParam(String name) {
        return this.realm.getClientByClientId(name);
    }
}

