/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.federation.ldap;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.logging.Logger;
import org.keycloak.federation.kerberos.impl.KerberosUsernamePasswordAuthenticator;
import org.keycloak.federation.kerberos.impl.SPNEGOAuthenticator;
import org.keycloak.federation.ldap.LDAPFederationProviderFactory;
import org.keycloak.federation.ldap.LDAPUtils;
import org.keycloak.federation.ldap.ReadonlyLDAPUserModelDelegate;
import org.keycloak.federation.ldap.UnsyncedLDAPUserModelDelegate;
import org.keycloak.federation.ldap.WritableLDAPUserModelDelegate;
import org.keycloak.federation.ldap.idm.model.LDAPUser;
import org.keycloak.federation.ldap.idm.query.IdentityQuery;
import org.keycloak.federation.ldap.idm.query.IdentityQueryBuilder;
import org.keycloak.federation.ldap.idm.store.ldap.LDAPIdentityStore;
import org.keycloak.federation.ldap.kerberos.LDAPProviderKerberosConfig;
import org.keycloak.models.CredentialValidationOutput;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserCredentialValueModel;
import org.keycloak.models.UserFederationProvider;
import org.keycloak.models.UserFederationProviderModel;
import org.keycloak.models.UserModel;

public class LDAPFederationProvider
implements UserFederationProvider {
    private static final Logger logger = Logger.getLogger(LDAPFederationProvider.class);
    protected LDAPFederationProviderFactory factory;
    protected KeycloakSession session;
    protected UserFederationProviderModel model;
    protected LDAPIdentityStore ldapIdentityStore;
    protected UserFederationProvider.EditMode editMode;
    protected LDAPProviderKerberosConfig kerberosConfig;
    protected final Set<String> supportedCredentialTypes = new HashSet<String>();

    public LDAPFederationProvider(LDAPFederationProviderFactory factory, KeycloakSession session, UserFederationProviderModel model, LDAPIdentityStore ldapIdentityStore) {
        this.factory = factory;
        this.session = session;
        this.model = model;
        this.ldapIdentityStore = ldapIdentityStore;
        this.kerberosConfig = new LDAPProviderKerberosConfig(model);
        String editModeString = (String)model.getConfig().get("editMode");
        this.editMode = editModeString == null ? UserFederationProvider.EditMode.READ_ONLY : UserFederationProvider.EditMode.valueOf((String)editModeString);
        this.supportedCredentialTypes.add("password");
        if (this.kerberosConfig.isAllowKerberosAuthentication()) {
            this.supportedCredentialTypes.add("kerberos");
        }
    }

    public KeycloakSession getSession() {
        return this.session;
    }

    public UserFederationProviderModel getModel() {
        return this.model;
    }

    public LDAPIdentityStore getLdapIdentityStore() {
        return this.ldapIdentityStore;
    }

    public UserModel proxy(UserModel local) {
        switch (this.editMode) {
            case READ_ONLY: {
                return new ReadonlyLDAPUserModelDelegate(local, this);
            }
            case WRITABLE: {
                return new WritableLDAPUserModelDelegate(local, this);
            }
            case UNSYNCED: {
                return new UnsyncedLDAPUserModelDelegate(local, this);
            }
        }
        return local;
    }

    public Set<String> getSupportedCredentialTypes(UserModel local) {
        HashSet<String> supportedCredentialTypes = new HashSet<String>(this.supportedCredentialTypes);
        if (this.editMode == UserFederationProvider.EditMode.UNSYNCED) {
            for (UserCredentialValueModel cred : local.getCredentialsDirectly()) {
                if (!cred.getType().equals("password")) continue;
                supportedCredentialTypes.remove("password");
            }
        }
        return supportedCredentialTypes;
    }

    public Set<String> getSupportedCredentialTypes() {
        return new HashSet<String>(this.supportedCredentialTypes);
    }

    public boolean synchronizeRegistrations() {
        return "true".equalsIgnoreCase((String)this.model.getConfig().get("syncRegistrations")) && this.editMode == UserFederationProvider.EditMode.WRITABLE;
    }

    public UserModel register(RealmModel realm, UserModel user) {
        if (this.editMode == UserFederationProvider.EditMode.READ_ONLY || this.editMode == UserFederationProvider.EditMode.UNSYNCED) {
            throw new IllegalStateException("Registration is not supported by this ldap server");
        }
        if (!this.synchronizeRegistrations()) {
            throw new IllegalStateException("Registration is not supported by this ldap server");
        }
        LDAPUser ldapUser = LDAPUtils.addUser(this.ldapIdentityStore, user.getUsername(), user.getFirstName(), user.getLastName(), user.getEmail());
        user.setAttribute("LDAP_ID", ldapUser.getId());
        user.setAttribute("LDAP_ENTRY_DN", ldapUser.getEntryDN());
        return this.proxy(user);
    }

    public boolean removeUser(RealmModel realm, UserModel user) {
        if (this.editMode == UserFederationProvider.EditMode.READ_ONLY || this.editMode == UserFederationProvider.EditMode.UNSYNCED) {
            logger.warnf("User '%s' can't be deleted in LDAP as editMode is '%s'", (Object)user.getUsername(), (Object)this.editMode.toString());
            return false;
        }
        return LDAPUtils.removeUser(this.ldapIdentityStore, user.getUsername());
    }

    public List<UserModel> searchByAttributes(Map<String, String> attributes, RealmModel realm, int maxResults) {
        LinkedList<UserModel> searchResults = new LinkedList<UserModel>();
        Map<String, LDAPUser> ldapUsers = this.searchLDAP(attributes, maxResults);
        for (LDAPUser ldapUser : ldapUsers.values()) {
            if (this.session.userStorage().getUserByUsername(ldapUser.getLoginName(), realm) != null) continue;
            UserModel imported = this.importUserFromLDAP(realm, ldapUser);
            searchResults.add(imported);
        }
        return searchResults;
    }

    protected Map<String, LDAPUser> searchLDAP(Map<String, String> attributes, int maxResults) {
        LDAPUser user;
        HashMap<String, LDAPUser> results = new HashMap<String, LDAPUser>();
        if (attributes.containsKey("username") && (user = LDAPUtils.getUser(this.ldapIdentityStore, attributes.get("username"))) != null) {
            results.put(user.getLoginName(), user);
        }
        if (attributes.containsKey("email") && (user = this.queryByEmail(attributes.get("email"))) != null) {
            results.put(user.getLoginName(), user);
        }
        if (attributes.containsKey("firstName") || attributes.containsKey("lastName")) {
            IdentityQueryBuilder queryBuilder = this.ldapIdentityStore.createQueryBuilder();
            IdentityQuery<LDAPUser> query = queryBuilder.createIdentityQuery(LDAPUser.class);
            if (attributes.containsKey("firstName")) {
                query.where(queryBuilder.equal(LDAPUser.FIRST_NAME, attributes.get("firstName")));
            }
            if (attributes.containsKey("lastName")) {
                query.where(queryBuilder.equal(LDAPUser.LAST_NAME, attributes.get("lastName")));
            }
            query.setLimit(maxResults);
            List<LDAPUser> users = query.getResultList();
            for (LDAPUser user2 : users) {
                results.put(user2.getLoginName(), user2);
            }
        }
        return results;
    }

    public boolean isValid(UserModel local) {
        LDAPUser ldapUser = LDAPUtils.getUser(this.ldapIdentityStore, local.getUsername());
        if (ldapUser == null) {
            return false;
        }
        return ldapUser.getId().equals(local.getAttribute("LDAP_ID"));
    }

    public UserModel getUserByUsername(RealmModel realm, String username) {
        LDAPUser ldapUser = LDAPUtils.getUser(this.ldapIdentityStore, username);
        if (ldapUser == null) {
            return null;
        }
        if (!username.equals(ldapUser.getLoginName())) {
            logger.warnf("User found in LDAP but with different username. LDAP username: %s, Searched username: %s", (Object)username, (Object)ldapUser.getLoginName());
            return null;
        }
        return this.importUserFromLDAP(realm, ldapUser);
    }

    protected UserModel importUserFromLDAP(RealmModel realm, LDAPUser ldapUser) {
        String email;
        String string = email = ldapUser.getEmail() != null && ldapUser.getEmail().trim().length() > 0 ? ldapUser.getEmail() : null;
        if (ldapUser.getLoginName() == null) {
            throw new ModelException("User returned from LDAP has null username! Check configuration of your LDAP mappings. ID of user from LDAP: " + ldapUser.getId());
        }
        UserModel imported = this.session.userStorage().addUser(realm, ldapUser.getLoginName());
        imported.setEnabled(true);
        imported.setEmail(email);
        imported.setFirstName(ldapUser.getFirstName());
        imported.setLastName(ldapUser.getLastName());
        imported.setFederationLink(this.model.getId());
        imported.setAttribute("LDAP_ID", ldapUser.getId());
        imported.setAttribute("LDAP_ENTRY_DN", ldapUser.getEntryDN());
        logger.debugf("Imported new user from LDAP to Keycloak DB. Username: [%s], Email: [%s], LDAP_ID: [%s], LDAP Entry DN: [%s]", new Object[]{imported.getUsername(), imported.getEmail(), ldapUser.getId(), ldapUser.getEntryDN()});
        return this.proxy(imported);
    }

    protected LDAPUser queryByEmail(String email) {
        return LDAPUtils.getUserByEmail(this.ldapIdentityStore, email);
    }

    public UserModel getUserByEmail(RealmModel realm, String email) {
        LDAPUser ldapUser = this.queryByEmail(email);
        if (ldapUser == null) {
            return null;
        }
        if (!email.equals(ldapUser.getEmail())) {
            logger.warnf("User found in LDAP but with different email. LDAP email: %s, Searched email: %s", (Object)email, (Object)ldapUser.getEmail());
            return null;
        }
        return this.importUserFromLDAP(realm, ldapUser);
    }

    public void preRemove(RealmModel realm) {
    }

    public void preRemove(RealmModel realm, RoleModel role) {
    }

    public boolean validPassword(UserModel user, String password) {
        if (this.kerberosConfig.isAllowKerberosAuthentication() && this.kerberosConfig.isUseKerberosForPasswordAuthentication()) {
            KerberosUsernamePasswordAuthenticator authenticator = this.factory.createKerberosUsernamePasswordAuthenticator(this.kerberosConfig);
            return authenticator.validUser(user.getUsername(), password);
        }
        return LDAPUtils.validatePassword(this.ldapIdentityStore, user, password);
    }

    public boolean validCredentials(RealmModel realm, UserModel user, List<UserCredentialModel> input) {
        Iterator<UserCredentialModel> i$ = input.iterator();
        if (i$.hasNext()) {
            UserCredentialModel cred = i$.next();
            if (cred.getType().equals("password")) {
                return this.validPassword(user, cred.getValue());
            }
            return false;
        }
        return true;
    }

    public boolean validCredentials(RealmModel realm, UserModel user, UserCredentialModel ... input) {
        return this.validCredentials(realm, user, Arrays.asList(input));
    }

    public CredentialValidationOutput validCredentials(RealmModel realm, UserCredentialModel credential) {
        if (credential.getType().equals("kerberos") && this.kerberosConfig.isAllowKerberosAuthentication()) {
            String spnegoToken = credential.getValue();
            SPNEGOAuthenticator spnegoAuthenticator = this.factory.createSPNEGOAuthenticator(spnegoToken, this.kerberosConfig);
            spnegoAuthenticator.authenticate();
            HashMap<String, String> state = new HashMap<String, String>();
            if (spnegoAuthenticator.isAuthenticated()) {
                String username = spnegoAuthenticator.getAuthenticatedUsername();
                UserModel user = this.findOrCreateAuthenticatedUser(realm, username);
                if (user == null) {
                    logger.warnf("Kerberos/SPNEGO authentication succeeded with username [%s], but couldn't find or create user with federation provider [%s]", (Object)username, (Object)this.model.getDisplayName());
                    return CredentialValidationOutput.failed();
                }
                String delegationCredential = spnegoAuthenticator.getSerializedDelegationCredential();
                if (delegationCredential != null) {
                    state.put("gss_delegation_credential", delegationCredential);
                }
                return new CredentialValidationOutput(user, CredentialValidationOutput.Status.AUTHENTICATED, state);
            }
            state.put("SpnegoResponseToken", spnegoAuthenticator.getResponseToken());
            return new CredentialValidationOutput(null, CredentialValidationOutput.Status.CONTINUE, state);
        }
        return CredentialValidationOutput.failed();
    }

    public void close() {
    }

    protected void importLDAPUsers(RealmModel realm, List<LDAPUser> ldapUsers, UserFederationProviderModel fedModel) {
        for (LDAPUser ldapUser : ldapUsers) {
            String username = ldapUser.getLoginName();
            UserModel currentUser = this.session.userStorage().getUserByUsername(username, realm);
            if (currentUser == null) {
                this.importUserFromLDAP(realm, ldapUser);
                continue;
            }
            if (fedModel.getId().equals(currentUser.getFederationLink()) && ldapUser.getId().equals(currentUser.getAttribute("LDAP_ID"))) {
                String email = ldapUser.getEmail() != null && ldapUser.getEmail().trim().length() > 0 ? ldapUser.getEmail() : null;
                currentUser.setEmail(email);
                currentUser.setFirstName(ldapUser.getFirstName());
                currentUser.setLastName(ldapUser.getLastName());
                logger.debugf("Updated user from LDAP: %s", (Object)currentUser.getUsername());
                continue;
            }
            logger.warnf("User '%s' is not updated during sync as he is not linked to federation provider '%s'", (Object)username, (Object)fedModel.getDisplayName());
        }
    }

    protected UserModel findOrCreateAuthenticatedUser(RealmModel realm, String username) {
        UserModel user = this.session.userStorage().getUserByUsername(username, realm);
        if (user != null) {
            logger.debugf("Kerberos authenticated user [%s] found in Keycloak storage", (Object)username);
            if (!this.model.getId().equals(user.getFederationLink())) {
                logger.warnf("User with username [%s] already exists, but is not linked to provider [%s]", (Object)username, (Object)this.model.getDisplayName());
                return null;
            }
            if (this.isValid(user)) {
                return this.proxy(user);
            }
            logger.warnf("User with username [%s] aready exists and is linked to provider [%s] but is not valid. Stale LDAP_ID on local user is: %s", (Object)username, (Object)this.model.getDisplayName(), (Object)user.getAttribute("LDAP_ID"));
            logger.warn((Object)"Will re-create user");
            this.session.userStorage().removeUser(realm, user);
        }
        logger.debugf("Kerberos authenticated user [%s] not in Keycloak storage. Creating him", (Object)username);
        return this.getUserByUsername(realm, username);
    }
}

