/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.keycloak.models.ClientModel;
import org.keycloak.models.CredentialValidationOutput;
import org.keycloak.models.FederatedIdentityModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakTransaction;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserFederationProviderModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserProvider;
import org.keycloak.models.cache.CacheUserProvider;
import org.keycloak.models.cache.UserAdapter;
import org.keycloak.models.cache.UserCache;
import org.keycloak.models.cache.entities.CachedUser;

public class DefaultCacheUserProvider
implements CacheUserProvider {
    protected UserCache cache;
    protected KeycloakSession session;
    protected UserProvider delegate;
    protected boolean transactionActive;
    protected boolean setRollbackOnly;
    protected Map<String, String> userInvalidations = new HashMap<String, String>();
    protected Set<String> realmInvalidations = new HashSet<String>();
    protected Map<String, UserModel> managedUsers = new HashMap<String, UserModel>();
    protected boolean clearAll;

    public DefaultCacheUserProvider(UserCache cache, KeycloakSession session) {
        this.cache = cache;
        this.session = session;
        session.getTransaction().enlistAfterCompletion(this.getTransaction());
    }

    @Override
    public boolean isEnabled() {
        return this.cache.isEnabled();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.cache.setEnabled(enabled);
    }

    @Override
    public UserProvider getDelegate() {
        if (!this.transactionActive) {
            throw new IllegalStateException("Cannot access delegate without a transaction");
        }
        if (this.delegate != null) {
            return this.delegate;
        }
        this.delegate = (UserProvider)this.session.getProvider(UserProvider.class);
        return this.delegate;
    }

    @Override
    public void registerUserInvalidation(RealmModel realm, String id) {
        this.userInvalidations.put(id, realm.getId());
    }

    protected void runInvalidations() {
        for (Map.Entry<String, String> invalidation : this.userInvalidations.entrySet()) {
            this.cache.invalidateCachedUserById(invalidation.getValue(), invalidation.getKey());
        }
        for (String realmId : this.realmInvalidations) {
            this.cache.invalidateRealmUsers(realmId);
        }
    }

    private KeycloakTransaction getTransaction() {
        return new KeycloakTransaction(){

            public void begin() {
                DefaultCacheUserProvider.this.transactionActive = true;
            }

            public void commit() {
                if (DefaultCacheUserProvider.this.delegate == null) {
                    return;
                }
                if (DefaultCacheUserProvider.this.clearAll) {
                    DefaultCacheUserProvider.this.cache.clear();
                }
                DefaultCacheUserProvider.this.runInvalidations();
                DefaultCacheUserProvider.this.transactionActive = false;
            }

            public void rollback() {
                DefaultCacheUserProvider.this.setRollbackOnly = true;
                DefaultCacheUserProvider.this.runInvalidations();
                DefaultCacheUserProvider.this.transactionActive = false;
            }

            public void setRollbackOnly() {
                DefaultCacheUserProvider.this.setRollbackOnly = true;
            }

            public boolean getRollbackOnly() {
                return DefaultCacheUserProvider.this.setRollbackOnly;
            }

            public boolean isActive() {
                return DefaultCacheUserProvider.this.transactionActive;
            }
        };
    }

    public UserModel getUserById(String id, RealmModel realm) {
        if (!this.cache.isEnabled()) {
            return this.getDelegate().getUserById(id, realm);
        }
        if (this.realmInvalidations.contains(realm.getId())) {
            return this.getDelegate().getUserById(id, realm);
        }
        if (this.userInvalidations.containsKey(id)) {
            return this.getDelegate().getUserById(id, realm);
        }
        CachedUser cached = this.cache.getCachedUser(realm.getId(), id);
        if (cached == null) {
            UserModel model = this.getDelegate().getUserById(id, realm);
            if (model == null) {
                return null;
            }
            if (this.userInvalidations.containsKey(id)) {
                return model;
            }
            cached = new CachedUser(realm, model);
            this.cache.addCachedUser(realm.getId(), cached);
        } else if (this.managedUsers.containsKey(id)) {
            return this.managedUsers.get(id);
        }
        UserAdapter adapter = new UserAdapter(cached, this, this.session, realm);
        this.managedUsers.put(id, adapter);
        return adapter;
    }

    public UserModel getUserByUsername(String username, RealmModel realm) {
        username = username.toLowerCase();
        if (!this.cache.isEnabled()) {
            return this.getDelegate().getUserByUsername(username, realm);
        }
        if (this.realmInvalidations.contains(realm.getId())) {
            return this.getDelegate().getUserByUsername(username, realm);
        }
        CachedUser cached = this.cache.getCachedUserByUsername(realm.getId(), username);
        if (cached == null) {
            UserModel model = this.getDelegate().getUserByUsername(username, realm);
            if (model == null) {
                return null;
            }
            if (this.userInvalidations.containsKey(model.getId())) {
                return model;
            }
            cached = new CachedUser(realm, model);
            this.cache.addCachedUser(realm.getId(), cached);
        } else {
            if (this.userInvalidations.containsKey(cached.getId())) {
                return this.getDelegate().getUserById(cached.getId(), realm);
            }
            if (this.managedUsers.containsKey(cached.getId())) {
                return this.managedUsers.get(cached.getId());
            }
        }
        UserAdapter adapter = new UserAdapter(cached, this, this.session, realm);
        this.managedUsers.put(cached.getId(), adapter);
        return adapter;
    }

    public UserModel getUserByEmail(String email, RealmModel realm) {
        email = email.toLowerCase();
        if (!this.cache.isEnabled()) {
            return this.getDelegate().getUserByEmail(email, realm);
        }
        if (this.realmInvalidations.contains(realm.getId())) {
            return this.getDelegate().getUserByEmail(email, realm);
        }
        CachedUser cached = this.cache.getCachedUserByEmail(realm.getId(), email);
        if (cached == null) {
            UserModel model = this.getDelegate().getUserByEmail(email, realm);
            if (model == null) {
                return null;
            }
            if (this.userInvalidations.containsKey(model.getId())) {
                return model;
            }
            cached = new CachedUser(realm, model);
            this.cache.addCachedUser(realm.getId(), cached);
        } else {
            if (this.userInvalidations.containsKey(cached.getId())) {
                return this.getDelegate().getUserByEmail(email, realm);
            }
            if (this.managedUsers.containsKey(cached.getId())) {
                return this.managedUsers.get(cached.getId());
            }
        }
        UserAdapter adapter = new UserAdapter(cached, this, this.session, realm);
        this.managedUsers.put(cached.getId(), adapter);
        return adapter;
    }

    public void close() {
        if (this.delegate != null) {
            this.delegate.close();
        }
    }

    public UserModel getUserByFederatedIdentity(FederatedIdentityModel socialLink, RealmModel realm) {
        return this.getDelegate().getUserByFederatedIdentity(socialLink, realm);
    }

    public List<UserModel> getUsers(RealmModel realm) {
        return this.getDelegate().getUsers(realm);
    }

    public int getUsersCount(RealmModel realm) {
        return this.getDelegate().getUsersCount(realm);
    }

    public List<UserModel> getUsers(RealmModel realm, int firstResult, int maxResults) {
        return this.getDelegate().getUsers(realm, firstResult, maxResults);
    }

    public List<UserModel> searchForUser(String search, RealmModel realm) {
        return this.getDelegate().searchForUser(search, realm);
    }

    public List<UserModel> searchForUser(String search, RealmModel realm, int firstResult, int maxResults) {
        return this.getDelegate().searchForUser(search, realm, firstResult, maxResults);
    }

    public List<UserModel> searchForUserByAttributes(Map<String, String> attributes, RealmModel realm) {
        return this.getDelegate().searchForUserByAttributes(attributes, realm);
    }

    public List<UserModel> searchForUserByAttributes(Map<String, String> attributes, RealmModel realm, int firstResult, int maxResults) {
        return this.getDelegate().searchForUserByAttributes(attributes, realm, firstResult, maxResults);
    }

    public Set<FederatedIdentityModel> getFederatedIdentities(UserModel user, RealmModel realm) {
        return this.getDelegate().getFederatedIdentities(user, realm);
    }

    public FederatedIdentityModel getFederatedIdentity(UserModel user, String socialProvider, RealmModel realm) {
        return this.getDelegate().getFederatedIdentity(user, socialProvider, realm);
    }

    public UserModel addUser(RealmModel realm, String id, String username, boolean addDefaultRoles) {
        return this.getDelegate().addUser(realm, id, username, addDefaultRoles);
    }

    public UserModel addUser(RealmModel realm, String username) {
        return this.getDelegate().addUser(realm, username);
    }

    public boolean removeUser(RealmModel realm, UserModel user) {
        if (!this.cache.isEnabled()) {
            return this.getDelegate().removeUser(realm, user);
        }
        this.registerUserInvalidation(realm, user.getId());
        return this.getDelegate().removeUser(realm, user);
    }

    public void addFederatedIdentity(RealmModel realm, UserModel user, FederatedIdentityModel socialLink) {
        this.getDelegate().addFederatedIdentity(realm, user, socialLink);
    }

    public void updateFederatedIdentity(RealmModel realm, UserModel federatedUser, FederatedIdentityModel federatedIdentityModel) {
        this.getDelegate().updateFederatedIdentity(realm, federatedUser, federatedIdentityModel);
    }

    public boolean removeFederatedIdentity(RealmModel realm, UserModel user, String socialProvider) {
        return this.getDelegate().removeFederatedIdentity(realm, user, socialProvider);
    }

    public boolean validCredentials(RealmModel realm, UserModel user, List<UserCredentialModel> input) {
        return this.getDelegate().validCredentials(realm, user, input);
    }

    public boolean validCredentials(RealmModel realm, UserModel user, UserCredentialModel ... input) {
        return this.getDelegate().validCredentials(realm, user, input);
    }

    public CredentialValidationOutput validCredentials(RealmModel realm, UserCredentialModel ... input) {
        return this.getDelegate().validCredentials(realm, input);
    }

    public void preRemove(RealmModel realm) {
        this.realmInvalidations.add(realm.getId());
        this.getDelegate().preRemove(realm);
    }

    public void preRemove(RealmModel realm, RoleModel role) {
        this.getDelegate().preRemove(realm, role);
    }

    public void preRemove(RealmModel realm, UserFederationProviderModel link) {
        this.realmInvalidations.add(realm.getId());
        this.getDelegate().preRemove(realm, link);
    }

    public void preRemove(RealmModel realm, ClientModel client) {
        this.getDelegate().preRemove(realm, client);
    }

    public void preRemove(ClientModel client, ProtocolMapperModel protocolMapper) {
        this.getDelegate().preRemove(client, protocolMapper);
    }
}

