/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.migration;

import org.jboss.logging.Logger;
import org.keycloak.migration.MigrationModel;
import org.keycloak.migration.ModelVersion;
import org.keycloak.migration.migrators.MigrationTo1_2_0_CR1;
import org.keycloak.models.KeycloakSession;

public class MigrationModelManager {
    private static Logger logger = Logger.getLogger(MigrationModelManager.class);

    public static void migrate(KeycloakSession session) {
        MigrationModel model = session.realms().getMigrationModel();
        String storedVersion = model.getStoredVersion();
        if ("1.2.0.CR1".equals(storedVersion)) {
            return;
        }
        ModelVersion stored = null;
        if (storedVersion != null) {
            new ModelVersion(storedVersion);
        }
        if (stored == null || stored.lessThan(MigrationTo1_2_0_CR1.VERSION)) {
            if (stored != null) {
                logger.debug((Object)"Migrating older model to 1.2.0.RC1 updates");
            }
            new MigrationTo1_2_0_CR1().migrate(session);
        }
        model.setStoredVersion("1.2.0.CR1");
    }
}

