/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.broker.oidc;

import java.io.IOException;
import java.io.InputStream;
import java.security.Key;
import java.security.PublicKey;
import java.util.Map;
import org.keycloak.broker.oidc.OIDCIdentityProvider;
import org.keycloak.broker.oidc.OIDCIdentityProviderConfig;
import org.keycloak.broker.provider.AbstractIdentityProviderFactory;
import org.keycloak.broker.provider.util.SimpleHttp;
import org.keycloak.jose.jwk.JWK;
import org.keycloak.jose.jwk.JWKParser;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.protocol.oidc.representations.JSONWebKeySet;
import org.keycloak.protocol.oidc.representations.OIDCConfigurationRepresentation;
import org.keycloak.util.JsonSerialization;

public class OIDCIdentityProviderFactory
extends AbstractIdentityProviderFactory<OIDCIdentityProvider> {
    public static final String PROVIDER_ID = "oidc";

    public String getName() {
        return "OpenID Connect v1.0";
    }

    public OIDCIdentityProvider create(IdentityProviderModel model) {
        return new OIDCIdentityProvider(new OIDCIdentityProviderConfig(model));
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public Map<String, String> parseConfig(InputStream inputStream) {
        return OIDCIdentityProviderFactory.parseOIDCConfig(inputStream);
    }

    protected static Map<String, String> parseOIDCConfig(InputStream inputStream) {
        OIDCConfigurationRepresentation rep = null;
        try {
            rep = (OIDCConfigurationRepresentation)JsonSerialization.readValue((InputStream)inputStream, OIDCConfigurationRepresentation.class);
        }
        catch (IOException e) {
            throw new RuntimeException("failed to load openid connect metadata", e);
        }
        OIDCIdentityProviderConfig config = new OIDCIdentityProviderConfig(new IdentityProviderModel());
        config.setIssuer(rep.getIssuer());
        config.setLogoutUrl(rep.getLogoutEndpoint());
        config.setAuthorizationUrl(rep.getAuthorizationEndpoint());
        config.setTokenUrl(rep.getTokenEndpoint());
        config.setUserInfoUrl(rep.getUserinfoEndpoint());
        if (rep.getJwksUri() != null) {
            String uri = rep.getJwksUri();
            String keySetString = null;
            try {
                keySetString = SimpleHttp.doGet((String)uri).asString();
                JSONWebKeySet keySet = (JSONWebKeySet)JsonSerialization.readValue((String)keySetString, JSONWebKeySet.class);
                for (JWK jwk : keySet.getKeys()) {
                    JWKParser parse = JWKParser.create((JWK)jwk);
                    if (!parse.getJwk().getPublicKeyUse().equals("sig") || !OIDCIdentityProviderFactory.keyTypeSupported(jwk.getKeyType())) continue;
                    PublicKey key = parse.toPublicKey();
                    config.setPublicKeySignatureVerifier(KeycloakModelUtils.getPemFromKey((Key)key));
                    config.setValidateSignature(true);
                    break;
                }
            }
            catch (IOException e) {
                throw new RuntimeException("F   ailed to query JWKSet from: " + uri, e);
            }
        }
        return config.getConfig();
    }

    protected static boolean keyTypeSupported(String type) {
        return type != null && type.equals("RSA");
    }
}

