/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.core;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import liquibase.CatalogAndSchema;
import liquibase.database.AbstractJdbcDatabase;
import liquibase.database.DatabaseConnection;
import liquibase.database.OfflineConnection;
import liquibase.exception.DatabaseException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.executor.ExecutorService;
import liquibase.logging.LogFactory;
import liquibase.statement.DatabaseFunction;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.RawCallStatement;
import liquibase.statement.core.RawSqlStatement;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Catalog;
import liquibase.structure.core.Schema;

public class OracleDatabase
extends AbstractJdbcDatabase {
    public static final String PRODUCT_NAME = "oracle";
    private Set<String> reservedWords = new HashSet<String>();
    private Set<String> userDefinedTypes = null;

    public OracleDatabase() {
        this.unquotedObjectsAreUppercased = true;
        super.setCurrentDateTimeFunction("SYSTIMESTAMP");
        this.dateFunctions.add(new DatabaseFunction("SYSDATE"));
        this.dateFunctions.add(new DatabaseFunction("SYSTIMESTAMP"));
        this.dateFunctions.add(new DatabaseFunction("CURRENT_TIMESTAMP"));
        this.sequenceNextValueFunction = "%s.nextval";
        this.sequenceCurrentValueFunction = "%s.currval";
    }

    @Override
    public int getPriority() {
        return 1;
    }

    @Override
    public void setConnection(DatabaseConnection conn) {
        Connection sqlConn = null;
        try {
            Method wrappedConn = conn.getClass().getMethod("getWrappedConnection", new Class[0]);
            wrappedConn.setAccessible(true);
            sqlConn = (Connection)wrappedConn.invoke((Object)conn, new Object[0]);
        }
        catch (Exception e) {
            throw new UnexpectedLiquibaseException(e);
        }
        if (sqlConn != null) {
            try {
                Method method = sqlConn.getClass().getMethod("setRemarksReporting", Boolean.TYPE);
                method.setAccessible(true);
                method.invoke((Object)sqlConn, true);
            }
            catch (Exception e) {
                LogFactory.getLogger().info("Could not set remarks reporting on OracleDatabase: " + e.getMessage());
            }
            try {
                this.reservedWords.addAll(Arrays.asList(sqlConn.getMetaData().getSQLKeywords().toUpperCase().split(",\\s*")));
            }
            catch (SQLException e) {
                LogFactory.getLogger().info("Could get sql keywords on OracleDatabase: " + e.getMessage());
            }
        }
        this.reservedWords.addAll(Arrays.asList("GROUP", "USER", "SESSION", "PASSWORD", "RESOURCE", "START", "SIZE", "UID", "DESC"));
        super.setConnection(conn);
    }

    @Override
    public String getShortName() {
        return PRODUCT_NAME;
    }

    @Override
    protected String getDefaultDatabaseProductName() {
        return "Oracle";
    }

    @Override
    public Integer getDefaultPort() {
        return 1521;
    }

    @Override
    public String getJdbcCatalogName(CatalogAndSchema schema) {
        return null;
    }

    @Override
    public String getJdbcSchemaName(CatalogAndSchema schema) {
        return this.correctObjectName(schema.getCatalogName() == null ? schema.getSchemaName() : schema.getCatalogName(), Schema.class);
    }

    @Override
    public String generatePrimaryKeyName(String tableName) {
        if (tableName.length() > 27) {
            return "PK_" + tableName.toUpperCase().substring(0, 27);
        }
        return "PK_" + tableName.toUpperCase();
    }

    @Override
    public boolean supportsInitiallyDeferrableColumns() {
        return true;
    }

    @Override
    public boolean isReservedWord(String objectName) {
        return this.reservedWords.contains(objectName.toUpperCase());
    }

    @Override
    public boolean supportsSequences() {
        return true;
    }

    @Override
    public boolean supportsSchemas() {
        return false;
    }

    @Override
    protected String getConnectionCatalogName() throws DatabaseException {
        if (this.getConnection() instanceof OfflineConnection) {
            return this.getConnection().getCatalog();
        }
        try {
            return ExecutorService.getInstance().getExecutor(this).queryForObject(new RawCallStatement("select sys_context( 'userenv', 'current_schema' ) from dual"), String.class);
        }
        catch (Exception e) {
            LogFactory.getLogger().info("Error getting default schema", e);
            return null;
        }
    }

    @Override
    public boolean isCorrectDatabaseImplementation(DatabaseConnection conn) throws DatabaseException {
        return PRODUCT_NAME.equalsIgnoreCase(conn.getDatabaseProductName());
    }

    @Override
    public String getDefaultDriver(String url) {
        if (url.startsWith("jdbc:oracle")) {
            return "oracle.jdbc.OracleDriver";
        }
        return null;
    }

    @Override
    public String getDefaultCatalogName() {
        return super.getDefaultCatalogName() == null ? null : super.getDefaultCatalogName().toUpperCase();
    }

    @Override
    public String getDateLiteral(String isoDate) {
        String normalLiteral = super.getDateLiteral(isoDate);
        if (this.isDateOnly(isoDate)) {
            StringBuffer val = new StringBuffer();
            val.append("to_date(");
            val.append(normalLiteral);
            val.append(", 'YYYY-MM-DD')");
            return val.toString();
        }
        if (this.isTimeOnly(isoDate)) {
            StringBuffer val = new StringBuffer();
            val.append("to_date(");
            val.append(normalLiteral);
            val.append(", 'HH24:MI:SS')");
            return val.toString();
        }
        if (this.isDateTime(isoDate)) {
            normalLiteral = normalLiteral.substring(0, normalLiteral.lastIndexOf(46)) + "'";
            StringBuffer val = new StringBuffer(26);
            val.append("to_date(");
            val.append(normalLiteral);
            val.append(", 'YYYY-MM-DD HH24:MI:SS')");
            return val.toString();
        }
        return "UNSUPPORTED:" + isoDate;
    }

    @Override
    public boolean isSystemObject(DatabaseObject example) {
        if (example == null) {
            return false;
        }
        if (this.isLiquibaseObject(example)) {
            return false;
        }
        if (example instanceof Schema) {
            if ("SYSTEM".equals(example.getName()) || "SYS".equals(example.getName()) || "CTXSYS".equals(example.getName()) || "XDB".equals(example.getName())) {
                return true;
            }
            if ("SYSTEM".equals(example.getSchema().getCatalogName()) || "SYS".equals(example.getSchema().getCatalogName()) || "CTXSYS".equals(example.getSchema().getCatalogName()) || "XDB".equals(example.getSchema().getCatalogName())) {
                return true;
            }
        } else if (this.isSystemObject(example.getSchema())) {
            return true;
        }
        if (example instanceof Catalog) {
            if ("SYSTEM".equals(example.getName()) || "SYS".equals(example.getName()) || "CTXSYS".equals(example.getName()) || "XDB".equals(example.getName())) {
                return true;
            }
        } else if (example.getName() != null) {
            if (example.getName().startsWith("BIN$")) {
                return true;
            }
            if (example.getName().startsWith("AQ$")) {
                return true;
            }
            if (example.getName().startsWith("DR$")) {
                return true;
            }
            if (example.getName().startsWith("SYS_IOT_OVER")) {
                return true;
            }
            if (example.getName().startsWith("MLOG$_")) {
                return true;
            }
            if (example.getName().startsWith("RUPD$_")) {
                return true;
            }
            if (example.getName().startsWith("WM$_")) {
                return true;
            }
            if (example.getName().equals("CREATE$JAVA$LOB$TABLE")) {
                return true;
            }
            if (example.getName().equals("JAVA$CLASS$MD5$TABLE")) {
                return true;
            }
        }
        return super.isSystemObject(example);
    }

    @Override
    public boolean supportsTablespaces() {
        return true;
    }

    @Override
    public boolean supportsAutoIncrement() {
        return false;
    }

    @Override
    public boolean supportsRestrictForeignKeys() {
        return false;
    }

    @Override
    public int getDataTypeMaxParameters(String dataTypeName) {
        if (dataTypeName.toUpperCase().equals("BINARY_FLOAT")) {
            return 0;
        }
        if (dataTypeName.toUpperCase().equals("BINARY_DOUBLE")) {
            return 0;
        }
        return super.getDataTypeMaxParameters(dataTypeName);
    }

    @Override
    public boolean jdbcCallsCatalogsSchemas() {
        return true;
    }

    public Set<String> getUserDefinedTypes() {
        if (this.userDefinedTypes == null) {
            this.userDefinedTypes = new HashSet<String>();
            if (this.getConnection() != null && !(this.getConnection() instanceof OfflineConnection)) {
                try {
                    this.userDefinedTypes.addAll(ExecutorService.getInstance().getExecutor(this).queryForList((SqlStatement)new RawSqlStatement("SELECT TYPE_NAME FROM USER_TYPES"), String.class));
                }
                catch (DatabaseException databaseException) {
                    // empty catch block
                }
            }
        }
        return this.userDefinedTypes;
    }

    @Override
    public String generateDatabaseFunctionValue(DatabaseFunction databaseFunction) {
        if (databaseFunction != null && databaseFunction.toString().equalsIgnoreCase("current_timestamp")) {
            return databaseFunction.toString();
        }
        return super.generateDatabaseFunctionValue(databaseFunction);
    }
}

