/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.federation.kerberos;

import org.keycloak.federation.kerberos.KerberosFederationProvider;
import org.keycloak.models.ModelReadOnlyException;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.UserModelDelegate;

public class ReadOnlyKerberosUserModelDelegate
extends UserModelDelegate {
    protected KerberosFederationProvider provider;

    public ReadOnlyKerberosUserModelDelegate(UserModel delegate, KerberosFederationProvider provider) {
        super(delegate);
        this.provider = provider;
    }

    public void updateCredential(UserCredentialModel cred) {
        if (this.provider.getSupportedCredentialTypes(this.delegate).contains(cred.getType())) {
            throw new ModelReadOnlyException("Can't change password in Keycloak database. Change password with your Kerberos server");
        }
        this.delegate.updateCredential(cred);
    }
}

