/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.mongo.updater.impl.updates;

import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import org.keycloak.connections.mongo.updater.impl.updates.Update;
import org.keycloak.models.KeycloakSession;

public class Update1_2_0_CR1
extends Update {
    @Override
    public String getId() {
        return "1.2.0.CR1";
    }

    @Override
    public void update(KeycloakSession session) {
        this.deleteEntries("clientSessions");
        this.deleteEntries("sessions");
        this.convertApplicationsToClients();
        this.convertOAuthClientsToClients();
        this.db.getCollection("realms").update((DBObject)new BasicDBObject(), (DBObject)new BasicDBObject("$rename", (Object)new BasicDBObject("adminAppId", (Object)"masterAdminClient")), false, true);
        this.ensureIndex("userConsents", new String[]{"clientId", "userId"}, true, false);
    }

    private void convertApplicationsToClients() {
        DBCollection applications = this.db.getCollection("applications");
        applications.dropIndex("realmId_1_name_1");
        applications.update((DBObject)new BasicDBObject(), (DBObject)new BasicDBObject("$set", (Object)new BasicDBObject("consentRequired", (Object)false)), false, true);
        applications.update((DBObject)new BasicDBObject(), (DBObject)new BasicDBObject("$rename", (Object)new BasicDBObject("name", (Object)"clientId")), false, true);
        this.renameCollection("applications", "clients");
        this.log.debugv("Converted applications to clients", new Object[0]);
        DBCollection roles = this.db.getCollection("roles");
        roles.update((DBObject)new BasicDBObject(), (DBObject)new BasicDBObject("$rename", (Object)new BasicDBObject("applicationId", (Object)"clientId")), false, true);
        this.log.debugv("Renamed roles.applicationId to roles.clientId", new Object[0]);
        this.ensureIndex("clients", new String[]{"realmId", "clientId"}, true, false);
    }

    private void convertOAuthClientsToClients() {
        DBCollection clients = this.db.getCollection("clients");
        DBCollection oauthClients = this.db.getCollection("oauthClients");
        oauthClients.dropIndex("realmId_1_name_1");
        oauthClients.update((DBObject)new BasicDBObject(), (DBObject)new BasicDBObject("$rename", (Object)new BasicDBObject("name", (Object)"clientId")), false, true);
        oauthClients.update((DBObject)new BasicDBObject(), (DBObject)new BasicDBObject("$set", (Object)new BasicDBObject("consentRequired", (Object)true)), false, true);
        DBCursor curs = oauthClients.find();
        while (curs.hasNext()) {
            clients.insert(new DBObject[]{curs.next()});
        }
        oauthClients.drop();
        this.log.debugv("Converted oauthClients to clients", new Object[0]);
    }
}

