/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import javax.ws.rs.GET;
import javax.ws.rs.core.Context;
import org.keycloak.Version;
import org.keycloak.broker.provider.IdentityProvider;
import org.keycloak.broker.provider.IdentityProviderFactory;
import org.keycloak.events.EventListenerProvider;
import org.keycloak.events.EventType;
import org.keycloak.exportimport.ClientImporter;
import org.keycloak.exportimport.ClientImporterFactory;
import org.keycloak.freemarker.Theme;
import org.keycloak.freemarker.ThemeProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.protocol.LoginProtocol;
import org.keycloak.protocol.LoginProtocolFactory;
import org.keycloak.protocol.ProtocolMapper;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderFactory;
import org.keycloak.provider.Spi;
import org.keycloak.representations.idm.ConfigPropertyRepresentation;
import org.keycloak.representations.idm.ProtocolMapperRepresentation;
import org.keycloak.representations.idm.ProtocolMapperTypeRepresentation;
import org.keycloak.social.SocialIdentityProvider;

public class ServerInfoAdminResource {
    @Context
    private KeycloakSession session;

    @GET
    public ServerInfoRepresentation getInfo() {
        ServerInfoRepresentation info = new ServerInfoRepresentation();
        info.version = Version.VERSION;
        info.serverTime = new Date().toString();
        this.setSocialProviders(info);
        this.setIdentityProviders(info);
        this.setThemes(info);
        this.setEventListeners(info);
        this.setProtocols(info);
        this.setClientImporters(info);
        this.setProviders(info);
        this.setProtocolMapperTypes(info);
        this.setBuiltinProtocolMappers(info);
        this.setEventTypes(info);
        return info;
    }

    private void setProviders(ServerInfoRepresentation info) {
        HashMap<String, Set> providers = new HashMap<String, Set>();
        for (Spi spi : ServiceLoader.load(Spi.class)) {
            providers.put(spi.getName(), this.session.listProviderIds(spi.getProviderClass()));
        }
        info.providers = providers;
    }

    private void setThemes(ServerInfoRepresentation info) {
        ThemeProvider themeProvider = (ThemeProvider)this.session.getProvider(ThemeProvider.class, "extending");
        info.themes = new HashMap();
        for (Theme.Type type : Theme.Type.values()) {
            LinkedList themes = new LinkedList(themeProvider.nameSet(type));
            Collections.sort(themes);
            info.themes.put(type.toString().toLowerCase(), themes);
        }
    }

    private void setSocialProviders(ServerInfoRepresentation info) {
        info.socialProviders = new LinkedList();
        List providerFactories = this.session.getKeycloakSessionFactory().getProviderFactories(SocialIdentityProvider.class);
        this.setIdentityProviders(providerFactories, info.socialProviders, "Social");
    }

    private void setIdentityProviders(ServerInfoRepresentation info) {
        info.identityProviders = new LinkedList<Map<String, String>>();
        List providerFactories = this.session.getKeycloakSessionFactory().getProviderFactories(IdentityProvider.class);
        this.setIdentityProviders(providerFactories, info.identityProviders, "User-defined");
        providerFactories = this.session.getKeycloakSessionFactory().getProviderFactories(SocialIdentityProvider.class);
        this.setIdentityProviders(providerFactories, info.identityProviders, "Social");
    }

    public void setIdentityProviders(List<ProviderFactory> factories, List<Map<String, String>> providers, String groupName) {
        for (ProviderFactory providerFactory : factories) {
            IdentityProviderFactory factory = (IdentityProviderFactory)providerFactory;
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("groupName", groupName);
            data.put("name", factory.getName());
            data.put("id", factory.getId());
            providers.add(data);
        }
    }

    private void setEventListeners(ServerInfoRepresentation info) {
        info.eventListeners = new LinkedList();
        Set providers = this.session.listProviderIds(EventListenerProvider.class);
        if (providers != null) {
            info.eventListeners.addAll(providers);
        }
    }

    private void setProtocols(ServerInfoRepresentation info) {
        info.protocols = new LinkedList();
        for (ProviderFactory p : this.session.getKeycloakSessionFactory().getProviderFactories(LoginProtocol.class)) {
            info.protocols.add(p.getId());
        }
        Collections.sort(info.protocols);
    }

    private void setProtocolMapperTypes(ServerInfoRepresentation info) {
        info.protocolMapperTypes = new HashMap();
        for (ProviderFactory p : this.session.getKeycloakSessionFactory().getProviderFactories(ProtocolMapper.class)) {
            ProtocolMapper mapper = (ProtocolMapper)p;
            LinkedList<ProtocolMapperTypeRepresentation> types = (LinkedList<ProtocolMapperTypeRepresentation>)info.protocolMapperTypes.get(mapper.getProtocol());
            if (types == null) {
                types = new LinkedList<ProtocolMapperTypeRepresentation>();
                info.protocolMapperTypes.put(mapper.getProtocol(), types);
            }
            ProtocolMapperTypeRepresentation rep = new ProtocolMapperTypeRepresentation();
            rep.setId(mapper.getId());
            rep.setName(mapper.getDisplayType());
            rep.setHelpText(mapper.getHelpText());
            rep.setCategory(mapper.getDisplayCategory());
            rep.setProperties(new LinkedList());
            List configProperties = mapper.getConfigProperties();
            for (ProviderConfigProperty prop : configProperties) {
                ConfigPropertyRepresentation propRep = new ConfigPropertyRepresentation();
                propRep.setName(prop.getName());
                propRep.setLabel(prop.getLabel());
                propRep.setType(prop.getType());
                propRep.setDefaultValue(prop.getDefaultValue());
                propRep.setHelpText(prop.getHelpText());
                rep.getProperties().add(propRep);
            }
            types.add(rep);
        }
    }

    private void setBuiltinProtocolMappers(ServerInfoRepresentation info) {
        info.builtinProtocolMappers = new HashMap();
        for (ProviderFactory p : this.session.getKeycloakSessionFactory().getProviderFactories(LoginProtocol.class)) {
            LoginProtocolFactory factory = (LoginProtocolFactory)p;
            LinkedList<ProtocolMapperRepresentation> mappers = new LinkedList<ProtocolMapperRepresentation>();
            for (ProtocolMapperModel mapper : factory.getBuiltinMappers()) {
                mappers.add(ModelToRepresentation.toRepresentation((ProtocolMapperModel)mapper));
            }
            info.builtinProtocolMappers.put(p.getId(), mappers);
        }
    }

    private void setClientImporters(ServerInfoRepresentation info) {
        info.clientImporters = new LinkedList();
        for (ProviderFactory p : this.session.getKeycloakSessionFactory().getProviderFactories(ClientImporter.class)) {
            ClientImporterFactory factory = (ClientImporterFactory)p;
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("id", factory.getId());
            data.put("name", factory.getDisplayName());
            info.clientImporters.add(data);
        }
    }

    private void setEventTypes(ServerInfoRepresentation info) {
        LinkedList<String> eventTypes = new LinkedList<String>();
        for (EventType t : EventType.values()) {
            eventTypes.add(t.name());
        }
        Collections.sort(eventTypes);
        info.setEventTypes(eventTypes);
    }

    public static class ServerInfoRepresentation {
        private String version;
        private String serverTime;
        private Map<String, List<String>> themes;
        private List<Map<String, String>> socialProviders;
        public List<Map<String, String>> identityProviders;
        private List<String> protocols;
        private List<Map<String, String>> clientImporters;
        private Map<String, Set<String>> providers;
        private List<String> eventListeners;
        private Map<String, List<ProtocolMapperTypeRepresentation>> protocolMapperTypes;
        private Map<String, List<ProtocolMapperRepresentation>> builtinProtocolMappers;
        private List<String> eventTypes;

        public String getServerTime() {
            return this.serverTime;
        }

        public String getVersion() {
            return this.version;
        }

        public Map<String, List<String>> getThemes() {
            return this.themes;
        }

        public List<Map<String, String>> getSocialProviders() {
            return this.socialProviders;
        }

        public List<Map<String, String>> getIdentityProviders() {
            return this.identityProviders;
        }

        public List<String> getEventListeners() {
            return this.eventListeners;
        }

        public List<String> getProtocols() {
            return this.protocols;
        }

        public List<Map<String, String>> getClientImporters() {
            return this.clientImporters;
        }

        public Map<String, Set<String>> getProviders() {
            return this.providers;
        }

        public Map<String, List<ProtocolMapperTypeRepresentation>> getProtocolMapperTypes() {
            return this.protocolMapperTypes;
        }

        public Map<String, List<ProtocolMapperRepresentation>> getBuiltinProtocolMappers() {
            return this.builtinProtocolMappers;
        }

        public void setBuiltinProtocolMappers(Map<String, List<ProtocolMapperRepresentation>> builtinProtocolMappers) {
            this.builtinProtocolMappers = builtinProtocolMappers;
        }

        public List<String> getEventTypes() {
            return this.eventTypes;
        }

        public void setEventTypes(List<String> eventTypes) {
            this.eventTypes = eventTypes;
        }
    }
}

