/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.events.mongo;

import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.LinkedList;
import java.util.List;
import org.keycloak.events.Event;
import org.keycloak.events.EventQuery;
import org.keycloak.events.EventType;
import org.keycloak.events.mongo.MongoEventStoreProvider;

public class MongoEventQuery
implements EventQuery {
    private Integer firstResult;
    private Integer maxResults;
    private DBCollection audit;
    private final BasicDBObject query;

    public MongoEventQuery(DBCollection audit) {
        this.audit = audit;
        this.query = new BasicDBObject();
    }

    public EventQuery type(EventType ... types) {
        LinkedList<String> eventStrings = new LinkedList<String>();
        for (EventType e : types) {
            eventStrings.add(e.toString());
        }
        this.query.put("type", (Object)new BasicDBObject("$in", eventStrings));
        return this;
    }

    public EventQuery realm(String realmId) {
        this.query.put("realmId", (Object)realmId);
        return this;
    }

    public EventQuery client(String clientId) {
        this.query.put("clientId", (Object)clientId);
        return this;
    }

    public EventQuery user(String userId) {
        this.query.put("userId", (Object)userId);
        return this;
    }

    public EventQuery fromDate(String fromDate) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        Long from = null;
        try {
            from = df.parse(fromDate).getTime();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        BasicDBObject time = this.query.containsField("time") ? (BasicDBObject)this.query.get("time") : new BasicDBObject();
        time.append("$gte", (Object)from);
        this.query.put("time", (Object)time);
        return this;
    }

    public EventQuery toDate(String toDate) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        Long to = null;
        try {
            to = df.parse(toDate).getTime();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        BasicDBObject time = this.query.containsField("time") ? (BasicDBObject)this.query.get("time") : new BasicDBObject();
        time.append("$lte", (Object)to);
        this.query.put("time", (Object)time);
        return this;
    }

    public EventQuery ipAddress(String ipAddress) {
        this.query.put("ipAddress", (Object)ipAddress);
        return this;
    }

    public EventQuery firstResult(int firstResult) {
        this.firstResult = firstResult;
        return this;
    }

    public EventQuery maxResults(int maxResults) {
        this.maxResults = maxResults;
        return this;
    }

    public List<Event> getResultList() {
        DBCursor cur = this.audit.find((DBObject)this.query).sort((DBObject)new BasicDBObject("time", (Object)-1));
        if (this.firstResult != null) {
            cur.skip(this.firstResult.intValue());
        }
        if (this.maxResults != null) {
            cur.limit(this.maxResults.intValue());
        }
        LinkedList<Event> events = new LinkedList<Event>();
        while (cur.hasNext()) {
            events.add(MongoEventStoreProvider.convert((BasicDBObject)cur.next()));
        }
        return events;
    }
}

