/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.events.mongo;

import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import java.util.HashMap;
import java.util.Map;
import org.keycloak.events.Event;
import org.keycloak.events.EventQuery;
import org.keycloak.events.EventStoreProvider;
import org.keycloak.events.EventType;
import org.keycloak.events.mongo.MongoEventQuery;

public class MongoEventStoreProvider
implements EventStoreProvider {
    private DBCollection events;

    public MongoEventStoreProvider(DBCollection events) {
        this.events = events;
    }

    public EventQuery createQuery() {
        return new MongoEventQuery(this.events);
    }

    public void clear() {
        this.events.remove((DBObject)new BasicDBObject());
    }

    public void clear(String realmId) {
        this.events.remove((DBObject)new BasicDBObject("realmId", (Object)realmId));
    }

    public void clear(String realmId, long olderThan) {
        BasicDBObject q = new BasicDBObject();
        q.put("realmId", (Object)realmId);
        q.put("time", (Object)new BasicDBObject("$lt", (Object)olderThan));
        this.events.remove((DBObject)q);
    }

    public void onEvent(Event event) {
        this.events.insert(new DBObject[]{MongoEventStoreProvider.convert(event)});
    }

    public void close() {
    }

    static DBObject convert(Event o) {
        BasicDBObject e = new BasicDBObject();
        e.put("time", (Object)o.getTime());
        e.put("type", (Object)o.getType().toString());
        e.put("realmId", (Object)o.getRealmId());
        e.put("clientId", (Object)o.getClientId());
        e.put("userId", (Object)o.getUserId());
        e.put("sessionId", (Object)o.getSessionId());
        e.put("ipAddress", (Object)o.getIpAddress());
        e.put("error", (Object)o.getError());
        BasicDBObject details = new BasicDBObject();
        if (o.getDetails() != null) {
            for (Map.Entry entry : o.getDetails().entrySet()) {
                details.put((String)entry.getKey(), entry.getValue());
            }
        }
        e.put("details", (Object)details);
        return e;
    }

    static Event convert(BasicDBObject o) {
        Event e = new Event();
        e.setTime(o.getLong("time"));
        e.setType(EventType.valueOf((String)o.getString("type")));
        e.setRealmId(o.getString("realmId"));
        e.setClientId(o.getString("clientId"));
        e.setUserId(o.getString("userId"));
        e.setSessionId(o.getString("sessionId"));
        e.setIpAddress(o.getString("ipAddress"));
        e.setError(o.getString("error"));
        BasicDBObject d = (BasicDBObject)o.get("details");
        if (d != null) {
            HashMap<String, String> details = new HashMap<String, String>();
            for (Object k : d.keySet()) {
                details.put((String)k, d.getString((String)k));
            }
            e.setDetails(details);
        }
        return e;
    }
}

